/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.scrolling;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Dictionary;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.dnd.Autoscroll;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public abstract class ScrollableComponent
extends LWComponent
implements Scrollable,
Autoscroll {
    private transient JViewport _viewport;
    private boolean _preferredSizeSet;

    protected ScrollableComponent() {
        this.setOpaque(true);
    }

    public final void invalidateCanvas() {
        boolean isValid = this.isValid();
        if (!isValid && !this.isShowing()) {
            return;
        }
        this.revalidate();
        this.repaint();
    }

    public void printPage(PaintContext context, Dictionary printProperties, Graphics g) {
        this.paintCanvasInterior(g);
    }

    public Dimension getDocumentSize(PaintContext context, Dictionary printProperties) {
        return this.getCanvasSize();
    }

    public final void repaintCanvas(int x, int y, int width, int height) {
        this.repaintInterior(x, y, width, height);
    }

    public final void paintImmediateCanvas(int x, int y, int width, int height) {
        this.paintImmediateInterior(x, y, width, height);
    }

    public final Point convertOuterToCanvas(int x, int y) {
        ImmInsets innerOrg = this.getBorderInsets();
        return new Point(x - innerOrg.left, y - innerOrg.top);
    }

    public final Point convertCanvasToOuter(int x, int y) {
        ImmInsets innerOrg = this.getBorderInsets();
        return new Point(x + innerOrg.left, y + innerOrg.top);
    }

    public final Point convertOuterToInterior(int x, int y) {
        ImmInsets innerOrigin = this.getBorderInsets();
        return new Point(x - innerOrigin.left, y - innerOrigin.top);
    }

    public final Point convertInteriorToOuter(int x, int y) {
        ImmInsets innerOrigin = this.getBorderInsets();
        return new Point(x + innerOrigin.left, y + innerOrigin.top);
    }

    public final Dimension convertInnerToOuterSize(Dimension innerSize) {
        ImmInsets insets = this.getBorderInsets();
        innerSize.width += insets.left + insets.right;
        innerSize.height += insets.top + insets.bottom;
        return innerSize;
    }

    public final Dimension convertInnerToOuterSize(int width, int height) {
        return this.convertInnerToOuterSize(new Dimension(width, height));
    }

    public final int getInnerWidth() {
        JViewport viewport = this.getViewport();
        int innerWidth = viewport != null ? viewport.getWidth() : this.getWidth();
        ImmInsets insets = this.getBorderInsets();
        if ((innerWidth -= insets.left + insets.right) < 0) {
            innerWidth = 0;
        }
        return innerWidth;
    }

    public final int getInnerHeight() {
        JViewport viewport = this.getViewport();
        int innerHeight = viewport != null ? viewport.getHeight() : this.getHeight();
        ImmInsets insets = this.getBorderInsets();
        if ((innerHeight -= insets.top + insets.bottom) < 0) {
            innerHeight = 0;
        }
        return innerHeight;
    }

    public final Dimension getInnerSize() {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            return viewport.getExtentSize();
        }
        return new Dimension(this.getInnerWidth(), this.getInnerHeight());
    }

    public final Point getInnerOrigin() {
        ImmInsets insets = this.getBorderInsets();
        return new Point(insets.left, insets.top);
    }

    public final Rectangle getInnerBounds() {
        ImmInsets insets = this.getBorderInsets();
        return new Rectangle(insets.left, insets.top, this.getInnerWidth(), this.getInnerHeight());
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int topValue = this.getVValueOfOffset(-visibleRect.y);
            if (direction < 0) {
                if (topValue > 0) {
                    --topValue;
                }
            } else {
                ++topValue;
            }
            if (topValue >= this.getVMaximum()) {
                topValue = this.getVMaximum() - 1;
            }
            int delta = -this.getVOffsetOfValue(topValue) - visibleRect.y;
            if (direction < 0) {
                delta = -delta;
            }
            return delta;
        }
        int topValue = this.getHValueOfOffset(-visibleRect.x);
        if (direction < 0) {
            if (topValue > 0) {
                --topValue;
            }
        } else {
            ++topValue;
        }
        if (topValue >= this.getHMaximum()) {
            topValue = this.getHMaximum() - 1;
        }
        int delta = -this.getHOffsetOfValue(topValue) - visibleRect.x;
        if (direction < 0) {
            delta = -delta;
        }
        return delta;
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        if (orientation == 1) {
            int delta = visibleRect.height;
            delta = direction < 0 ? Math.min(visibleRect.y, delta) : Math.min(this.getCanvasHeight() - (visibleRect.height + visibleRect.y), delta);
            return delta;
        }
        int delta = visibleRect.width;
        delta = direction < 0 ? Math.min(visibleRect.x, delta) : Math.min(this.getCanvasWidth() - (visibleRect.width + visibleRect.x), delta);
        return delta;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (!this.isHScrollable()) {
            return true;
        }
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            return viewport.getWidth() >= this.getPreferredSize().width;
        }
        return false;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (!this.isVScrollable()) {
            return true;
        }
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            return viewport.getHeight() >= this.getPreferredSize().height;
        }
        return false;
    }

    public JViewport getViewport() {
        return this._viewport;
    }

    public final Rectangle getCanvasBounds() {
        return this.getScrollParent().getBounds();
    }

    public final Point getCanvasOrigin() {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            return this.getScrollParent().getLocation();
        }
        return new Point();
    }

    public final int getCanvasOriginX() {
        JViewport viewport = this.getViewport();
        if (viewport != null && this.isHScrollable()) {
            Component scrollParent = this.getScrollParent();
            if (scrollParent == this) {
                return this.getX();
            }
            return scrollParent.getLocation().x;
        }
        return 0;
    }

    public final int getCanvasOriginY() {
        JViewport viewport = this.getViewport();
        if (viewport != null && this.isVScrollable()) {
            Component scrollParent = this.getScrollParent();
            if (scrollParent == this) {
                return this.getY();
            }
            return scrollParent.getLocation().y;
        }
        return 0;
    }

    public final int getCanvasWidth() {
        return this.getWidth();
    }

    public final int getCanvasHeight() {
        return this.getHeight();
    }

    public final Dimension getCanvasSize() {
        return this.getSize();
    }

    public boolean isHScrollable() {
        return false;
    }

    public boolean isVScrollable() {
        return false;
    }

    public void setCanvasOrigin(int x, int y) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            viewport.setViewPosition(new Point(-x, -y));
        }
    }

    public void setCanvasBounds(int x, int y, int width, int height) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            this.setCanvasOrigin(x, y);
            this.setCanvasSize(width, height);
        }
    }

    public final void clipCanvasToParents(Rectangle rect) {
        int maxHeight;
        ImmInsets innerOrg = this.getBorderInsets();
        int canvasOriginX = this.getCanvasOriginX();
        int canvasOriginY = this.getCanvasOriginY();
        rect.x += canvasOriginX + innerOrg.left;
        rect.y += canvasOriginY + innerOrg.top;
        this.computeVisibleRect(rect);
        if (rect.x < innerOrg.left) {
            rect.width -= innerOrg.left - rect.x;
            rect.x = innerOrg.left;
        }
        if (rect.y < innerOrg.top) {
            rect.height -= innerOrg.top - rect.y;
            rect.y = innerOrg.top;
        }
        Dimension d = this.getInnerSize();
        int maxWidth = d.width - (rect.x - innerOrg.left);
        if (rect.width > maxWidth) {
            rect.width = maxWidth;
        }
        if (rect.height > (maxHeight = d.height - (rect.y - innerOrg.top))) {
            rect.height = maxHeight;
        }
        rect.x -= canvasOriginX + innerOrg.left;
        rect.y -= canvasOriginY + innerOrg.top;
    }

    public void addNotify() {
        Container parent;
        super.addNotify();
        if ((this.isHScrollable() || this.isVScrollable()) && (parent = this.getScrollParent().getParent()) instanceof JViewport) {
            this._viewport = (JViewport)parent;
        }
    }

    public void removeNotify() {
        super.removeNotify();
        this._viewport = null;
    }

    public void setPreferredSize(Dimension size) {
        this._preferredSizeSet = size != null;
        super.setPreferredSize(size);
    }

    public Dimension getPreferredSize() {
        if (this._preferredSizeSet) {
            return super.getPreferredSize();
        }
        Dimension d = this.layoutCanvas();
        ImmInsets insets = this.getBorderInsets();
        d.width += insets.left + insets.right;
        d.height += insets.top + insets.bottom;
        return d;
    }

    public final void layout() {
        super.layout();
        this.layoutCanvas();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ImmInsets borderInsets = this.getBorderInsets();
        int originX = borderInsets.left;
        int originY = borderInsets.top;
        Shape savedClip = null;
        if (originX != 0 || originY != 0) {
            g.translate(originX, originY);
        }
        if (!borderInsets.equals(ImmInsets.getEmptyInsets())) {
            savedClip = g.getClip();
            g.clipRect(0, 0, this.getWidth() - originX - borderInsets.right, this.getHeight() - originY - borderInsets.bottom);
        }
        this.paintCanvasInterior(g);
        if (savedClip != null) {
            g.setClip(savedClip);
        }
        if (originX != 0 || originY != 0) {
            g.translate(-originX, -originY);
        }
    }

    public Insets getAutoscrollInsets() {
        Insets i = new Insets(0, 0, 0, 0);
        if (this.isHScrollable()) {
            i.left = 8;
            i.right = 8;
        }
        if (this.isVScrollable()) {
            i.top = 8;
            i.bottom = 8;
        }
        return i;
    }

    public void autoscroll(Point cursorLocn) {
        int dy;
        int diff;
        Insets i = this.getAutoscrollInsets();
        Point canvasOrigin = this.getCanvasOrigin();
        Rectangle visibleRect = this.getVisibleRect();
        int dx = cursorLocn.x < i.left ? -1 : (cursorLocn.x >= visibleRect.width - i.right ? 1 : 0);
        if (dx != 0) {
            diff = this.getScrollableUnitIncrement(visibleRect, 0, dx);
            canvasOrigin.x -= dx * diff;
            canvasOrigin.x = Math.max(canvasOrigin.x, visibleRect.width - this.getCanvasWidth());
        }
        if ((dy = cursorLocn.y < i.top ? -1 : (cursorLocn.y >= visibleRect.height - i.bottom ? 1 : 0)) != 0) {
            diff = this.getScrollableUnitIncrement(visibleRect, 1, dy);
            canvasOrigin.y -= dy * diff;
            canvasOrigin.y = Math.max(canvasOrigin.y, visibleRect.height - this.getCanvasHeight());
        }
        this.setCanvasOrigin(canvasOrigin.x, canvasOrigin.y);
    }

    protected void paintCanvasInterior(Graphics g) {
    }

    protected int getHMaximum() {
        return this.getCanvasSize().width;
    }

    protected int getHValueOfOffset(int x) {
        return -x;
    }

    protected int getHOffsetOfValue(int value) {
        return -value;
    }

    protected int getVMaximum() {
        return this.getCanvasSize().height;
    }

    protected int getVOffsetOfValue(int value) {
        return -value;
    }

    protected int getVValueOfOffset(int y) {
        return -y;
    }

    protected Dimension layoutCanvas() {
        return new Dimension(0, 0);
    }

    public void setCanvasSize(int width, int height) {
        JViewport viewport = this.getViewport();
        if (viewport != null) {
            Dimension oldSize = viewport.getViewSize();
            viewport.setViewSize(new Dimension(Math.max(width, this.getInnerWidth()), Math.max(height, this.getInnerHeight())));
            if (!oldSize.equals(viewport.getViewSize())) {
                this.revalidate();
            }
        }
    }

    protected final void makeCanvasGraphics(Graphics g) {
        if (g != null) {
            Rectangle innerBounds = this.getInnerBounds();
            this.computeVisibleRect(innerBounds);
            int originX = this.getCanvasOriginX();
            int originY = this.getCanvasOriginY();
            g.translate(innerBounds.x + originX, innerBounds.y + originY);
            g.clipRect(-originX, -originY, innerBounds.width, innerBounds.height);
        }
    }

    public final Graphics getCanvasGraphics() {
        Graphics g = this.getGraphics();
        this.makeCanvasGraphics(g);
        return g;
    }

    protected Component getScrollParent() {
        return this;
    }

    private boolean _isContainedBy(Rectangle containee, Rectangle container) {
        return containee.x >= container.x && containee.y >= container.y && containee.x + containee.width <= container.x + container.width && containee.y + containee.height <= container.y + container.height;
    }

    private boolean _isDamaged() {
        return false;
    }
}

