/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.print;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.Shape;
import java.util.Stack;
import oracle.bali.ewt.graphics.FontUtils;
import oracle.bali.ewt.print.PrintGraphicsProxy;

public class StackPrintGraphics
extends PrintGraphicsProxy {
    private static final Color _DEFAULT_XOR_COLOR = new Color(0);
    private int _currXOrigin = 0;
    private int _currYOrigin = 0;
    private Color _currXORColor = _DEFAULT_XOR_COLOR;
    private Stack _stateStack = new Stack();

    public StackPrintGraphics(Graphics printGraphics) {
        this(printGraphics, (PrintGraphics)((Object)printGraphics));
        Font currentFont;
        Color currentColor = printGraphics.getColor();
        if (currentColor == null) {
            this.setColor(Color.black);
        }
        if ((currentFont = printGraphics.getFont()) == null) {
            this.setFont(FontUtils.getDefaultSansSerifFont());
        }
    }

    public StackPrintGraphics(Graphics g, PrintGraphics printGraphics) {
        super(g, printGraphics);
        this.create();
    }

    public synchronized Graphics create() {
        this._stateStack.push(new GraphicsState(this.getGraphics(), this._currXOrigin, this._currYOrigin, this._currXORColor));
        this._currXOrigin = 0;
        this._currYOrigin = 0;
        return this;
    }

    public synchronized void translate(int x, int y) {
        this._currXOrigin += x;
        this._currYOrigin += y;
        super.translate(x, y);
    }

    public synchronized void setXORMode(Color xorColor) {
        this._currXORColor = xorColor;
        super.setXORMode(xorColor);
    }

    public synchronized void dispose() {
        Graphics ourGraphics = this.getGraphics();
        ourGraphics.translate(-this._currXOrigin, -this._currYOrigin);
        GraphicsState restoredGraphics = (GraphicsState)this._stateStack.pop();
        restoredGraphics.apply(ourGraphics);
        this._currXOrigin = restoredGraphics.getXOrigin();
        this._currYOrigin = restoredGraphics.getYOrigin();
        if (this._stateStack.empty()) {
            super.dispose();
        }
    }

    private void _indent() {
        int depth = this._stateStack.size();
        for (int i = 0; i < depth; ++i) {
            System.out.print(" ");
        }
    }

    private class GraphicsState {
        private int _xOrigin;
        private int _yOrigin;
        private Color _color;
        private Font _font;
        private Shape _clipShape;
        private Color _xorColor;

        public GraphicsState(Graphics g, int xOrigin, int yOrigin, Color xorColor) {
            this._xOrigin = xOrigin;
            this._yOrigin = yOrigin;
            this._xorColor = xorColor;
            this._color = g.getColor();
            this._font = g.getFont();
            this._clipShape = g.getClip();
        }

        public void apply(Graphics g) {
            g.setColor(this._color);
            g.setFont(this._font);
            g.setClip(this._clipShape);
            if (this._xorColor != _DEFAULT_XOR_COLOR) {
                g.setXORMode(this._xorColor);
            }
        }

        public int getXOrigin() {
            return this._xOrigin;
        }

        public int getYOrigin() {
            return this._yOrigin;
        }
    }
}

