/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyVetoException;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.pivot.AbstractPivotHeaderHeaderItem;
import oracle.bali.ewt.pivot.PivotHeader;
import oracle.bali.ewt.selection.OneDSelection;

class PivotHeaderHeaderInputHandler
extends StandardHeaderKeyHandler
implements HeaderItemInputHandler {
    private PivotHeader _pivotHeader;
    private int _lastItem = -1;

    public PivotHeaderHeaderInputHandler(PivotHeader pivotHeader) {
        this._pivotHeader = pivotHeader;
    }

    public void mouseExited(MouseEvent e, Header header, int itemIndex) {
        header.setCursor(Cursor.getDefaultCursor());
    }

    public void mouseMoved(MouseEvent e, Header header, int itemIndex) {
        if (e.isConsumed()) {
            return;
        }
        AbstractPivotHeaderHeaderItem item = this._pivotHeader.getPivotHeaderHeaderItem(itemIndex);
        if (item != null && this._pivotHeader.isAxisLabelsVisible()) {
            Cursor oldCursor = header.getCursor();
            Point p = this._convertPointToImageSpace(header, itemIndex, e.getX(), e.getY());
            Cursor newCursor = this._pivotHeader.isAxisLabelDrill(itemIndex, p.x, p.y) ? this._pivotHeader.getAxisLabelDrillCursor(itemIndex) : Cursor.getDefaultCursor();
            if (oldCursor != newCursor) {
                header.setCursor(newCursor);
                e.consume();
            }
        } else {
            header.setCursor(this._pivotHeader.getPivotCursor(itemIndex));
        }
    }

    public void mousePressed(MouseEvent e, Header header, int itemIndex) {
        if (e.isConsumed()) {
            return;
        }
        if (!SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        if (this._pivotHeader.isAxisLabelsVisible()) {
            boolean drillable = this._pivotHeader.isAxisLabelDrillable(itemIndex);
            boolean collapsable = drillable ? false : this._pivotHeader.isAxisLabelCollapsable(itemIndex);
            Point p = this._convertPointToImageSpace(header, itemIndex, e.getX(), e.getY());
            if ((drillable || collapsable) && this._pivotHeader.isAxisLabelDrill(itemIndex, p.x, p.y)) {
                int column = -2;
                int row = -2;
                if (this._pivotHeader.getOrientation() == 0) {
                    row = itemIndex;
                } else {
                    column = itemIndex;
                }
                if (drillable) {
                    this._pivotHeader.fireHeaderCellDrillRequest(column, row);
                } else {
                    this._pivotHeader.fireCollapse(column, row);
                }
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            this._selectGrid(e, header, itemIndex);
        }
    }

    public void handleKeyEvent(Header header, KeyEvent e) {
        if (e.isConsumed()) {
            return;
        }
        if (this._pivotHeader.isAxisLabelsVisible() && e.getID() == 401) {
            int itemIndex = header.getFocusItem();
            boolean drillable = this._pivotHeader.isAxisLabelDrillable(itemIndex);
            boolean collapsable = drillable ? false : this._pivotHeader.isAxisLabelCollapsable(itemIndex);
            boolean controlOrAltDown = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() == 4 ? e.isControlDown() : e.isAltDown();
            int column = -2;
            int row = -2;
            if (this._pivotHeader.getOrientation() == 0) {
                row = itemIndex;
            } else {
                column = itemIndex;
            }
            if (drillable && controlOrAltDown && e.getKeyCode() == 40) {
                this._pivotHeader.fireHeaderCellDrillRequest(column, row);
                e.consume();
            } else if (collapsable & controlOrAltDown & e.getKeyCode() == 38) {
                this._pivotHeader.fireCollapse(column, row);
                e.consume();
            }
        }
        if (!e.isConsumed()) {
            super.handleKeyEvent(header, e);
        }
    }

    public void mouseClicked(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseDragged(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseEntered(MouseEvent e, Header header, int itemIndex) {
    }

    public void mouseReleased(MouseEvent e, Header header, int itemIndex) {
        this._pivotHeader.__selectGrid(true);
    }

    private Point _convertPointToImageSpace(Header header, int itemIndex, int x, int y) {
        Image image = this._pivotHeader.getAxisLabelDrillImage(itemIndex);
        int grippyWidth = 0;
        if (image != null) {
            FontMetrics metrics;
            int itemHeight = 0;
            int imageHeight = image.getHeight(this._pivotHeader);
            if (this._pivotHeader.getOrientation() == 0) {
                itemHeight = header.getItemSize(itemIndex);
                grippyWidth = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)this._pivotHeader.getPaintContext(), (int)header.getSize().width, (int)itemHeight).width;
            } else {
                itemHeight = header.getSize().height;
                grippyWidth = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)this._pivotHeader.getPaintContext(), (int)header.getItemSize((int)itemIndex), (int)header.getSize().height).width;
            }
            PaintContext context = header.getItemPaintContext(itemIndex);
            float alignY = context.getInteriorAlignmentY();
            Font f = context.getPaintFont();
            int fontSize = 0;
            if (f == null) {
                f = this._pivotHeader.getFont();
            }
            if (f != null && (metrics = context.getFontMetrics(f)) != null) {
                fontSize = metrics.getHeight();
            }
            if (itemHeight < fontSize) {
                itemHeight = fontSize;
            }
            y = (int)((float)y - (float)(itemHeight - fontSize) * alignY - (float)((fontSize - imageHeight) / 2));
        }
        return new Point(x - grippyWidth, y);
    }

    private void _selectGrid(MouseEvent me, Header header, int itemIndex) {
        if (this._pivotHeader.isAxisLabelsVisible()) {
            int width = 0;
            int height = 0;
            if (header.getOrientation() == 0) {
                width = header.getItemSize(itemIndex);
                height = header.getSize().height;
            } else {
                width = header.getSize().width;
                height = header.getItemSize(itemIndex);
            }
            int grippyWidth = this._pivotHeader.__getPivotGrippyPainter().getSize((PaintContext)header.getItemPaintContext((int)itemIndex), (int)width, (int)height).width;
            int x = me.getX();
            if (x >= 0 && x < grippyWidth) {
                this._pivotHeader.__selectGrid(true);
                if (itemIndex == this._lastItem) {
                    OneDSelection old = header.getSelection();
                    try {
                        header.setSelection(OneDSelection.getEmptySelection());
                        header.setSelection(old);
                    }
                    catch (PropertyVetoException e) {}
                }
            } else {
                Grid grid = this._pivotHeader.getGrid();
                try {
                    grid.deselectAll();
                }
                catch (PropertyVetoException e) {
                    // empty catch block
                }
                this._pivotHeader.__selectGrid(false);
                this._lastItem = itemIndex;
            }
        }
    }
}

