/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.pivot;

import java.awt.Color;
import oracle.bali.ewt.elaf.EWTPivotHeaderUI;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.grid.AppearanceManager;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.pivot.AbstractPivotHeaderCell;
import oracle.bali.ewt.pivot.PivotHeader;

class PivotHeaderAppearMgr
implements AppearanceManager {
    private PivotHeader _pivotHeader;
    private AppearanceManager _toWrap;
    private int _item = -1;

    public PivotHeaderAppearMgr(AppearanceManager toWrap, PivotHeader pivotHeader) {
        this._toWrap = toWrap;
        this._pivotHeader = pivotHeader;
    }

    public void dispose() {
        if (this._pivotHeader == null) {
            return;
        }
        this._toWrap.setGrid(null);
        this._toWrap = null;
        this._pivotHeader = null;
    }

    public void setSwapItem(int item) {
        this._item = item;
    }

    public AppearanceManager getWrapped() {
        return this._toWrap;
    }

    public void updateUI() {
        if (this._pivotHeader != null) {
            this._pivotHeader.resetAppearanceManager();
        }
    }

    public Appearance getCellPaintingAppearance(int column, int row) {
        boolean horizontal;
        Appearance app = this._toWrap.getCellPaintingAppearance(column, row);
        if (this._item == -1) {
            return app;
        }
        boolean bl = horizontal = this._pivotHeader.getOrientation() == 0;
        if (horizontal && this._item == row) {
            app = this._createSwapAppearance(app);
        } else if (!horizontal) {
            if (this._pivotHeader.isOutline()) {
                AbstractPivotHeaderCell cell = this._pivotHeader.getPivotHeaderCell(column, row);
                if (cell != null && cell.getIndent() == this._item) {
                    app = this._createSwapAppearance(app);
                }
            } else if (this._item == column) {
                app = this._createSwapAppearance(app);
            }
        }
        return app;
    }

    private Appearance _createSwapAppearance(Appearance base) {
        Appearance newApp = base.copy();
        EWTPivotHeaderUI ui = this._pivotHeader.getPivotHeaderUI();
        Color color = ui.getSwapForegroundColor(this._pivotHeader, base);
        newApp.setForeground(color);
        newApp.setSelectForeground(color);
        color = ui.getSwapBackgroundColor(this._pivotHeader, base);
        newApp.setBackground(color);
        newApp.setSelectBackground(color);
        return newApp;
    }

    public void setGrid(Grid grid) {
        if (this._toWrap != null) {
            this._toWrap.setGrid(grid);
        }
    }

    public TwoDModelListener getTwoDModelListener() {
        return this._toWrap.getTwoDModelListener();
    }
}

