/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import oracle.bali.ewt.graphics.ImageUtils;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;

public class ImagePainter
extends AbstractPainter {
    public static final int DONT_SCALE = 0;
    public static final int PRESERVE_ASPECT_RATIO = 1;
    public static final int SCALE_TO_FIT = 2;
    private Object _dataKey;
    private int _scalingMode;
    private boolean _progressive;

    public ImagePainter() {
        this(PaintContext.IMAGE_KEY, 2);
    }

    public ImagePainter(int scalingMode) {
        this(PaintContext.IMAGE_KEY, scalingMode);
    }

    public ImagePainter(Object dataKey) {
        this(dataKey, 2);
    }

    public ImagePainter(Object dataKey, int scalingMode) {
        this._dataKey = dataKey;
        this._scalingMode = scalingMode;
    }

    public void setProgressiveLoading(boolean progressive) {
        this._progressive = progressive;
    }

    public boolean getProgressiveLoading() {
        return this._progressive;
    }

    public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
        Dimension size = this._getNewSize(context, availableWidth, availableHeight);
        if (size != null) {
            return size;
        }
        return new Dimension(availableWidth, availableHeight);
    }

    public Dimension getMinimumSize(PaintContext context) {
        Image image = this.getImageData(context);
        if (image != null && (this._progressive && ImageUtils.isImageLoaded(image) || !this._progressive && ImageUtils.loadImage(image))) {
            ImageObserver observer = context.getImageObserver();
            return new Dimension(image.getWidth(observer), image.getHeight(observer));
        }
        return new Dimension(0, 0);
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Image image = this.getImageData(context);
        if (image != null) {
            Dimension paintSize = this._getNewSize(context, width, height);
            if (paintSize != null) {
                width = paintSize.width;
                height = paintSize.height;
            }
            g.drawImage(image, x, y, width, height, context.getImageObserver());
        }
    }

    public int getRepaintFlags(PaintContext context) {
        return this._scalingMode != 0 ? 128 : 0;
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    protected Image getImageData(PaintContext context) {
        return (Image)this.getData(context);
    }

    protected Object getDataKey() {
        return this._dataKey;
    }

    protected Object getData(PaintContext context) {
        Object data = super.getData(context);
        if (data instanceof Image) {
            return data;
        }
        return null;
    }

    private Dimension _getNewSize(PaintContext context, int availableWidth, int availableHeight) {
        int width = 0;
        int height = 0;
        if (this._scalingMode == 2) {
            return null;
        }
        Image image = this.getImageData(context);
        if (image != null) {
            if (this.getProgressiveLoading() ? !ImageUtils.isImageLoaded(image) : !ImageUtils.loadImage(image)) {
                return null;
            }
            ImageObserver observer = context.getImageObserver();
            width = image.getWidth(observer);
            height = image.getHeight(observer);
            if (this._scalingMode == 1) {
                float xRatio = (float)availableWidth / (float)width;
                float yRatio = (float)availableHeight / (float)height;
                if (xRatio < yRatio) {
                    width = availableWidth;
                    height = (int)((float)height * xRatio);
                } else {
                    width = (int)((float)width * yRatio);
                    height = availableHeight;
                }
            }
        }
        if (width == availableWidth && height == availableHeight) {
            return null;
        }
        return new Dimension(width, height);
    }
}

