/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import oracle.bali.ewt.painter.AbstractWrappingPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class AlignmentPainter
extends AbstractWrappingPainter {
    private boolean _clipAlignment;

    public AlignmentPainter(Painter alignedPainter) {
        this(alignedPainter, true);
    }

    public AlignmentPainter(Painter alignedPainter, boolean clipAlignment) {
        super(alignedPainter);
        this._clipAlignment = clipAlignment;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Dimension size;
        float hAlign = this.getAlignmentX(context);
        float vAlign = this.getAlignmentY(context);
        Dimension dimension = size = this._clipAlignment ? this.getSize(context, width, height) : this.getPreferredSize(context);
        if (this._clipAlignment && size.width > width) {
            size.width = width;
        } else {
            x += (int)((double)(width - size.width) * (double)hAlign);
        }
        if (this._clipAlignment && size.height > height) {
            size.height = height;
        } else {
            y += (int)((float)(height - size.height) * vAlign);
        }
        super.paint(context, g, x, y, size.width, size.height);
    }

    public Painter getPainterAt(PaintContext context, int availableWidth, int availableHeight, int x, int y, Painter proxyPainter) {
        Rectangle bounds = this._getPainterBounds(context, 0, 0, availableWidth, availableHeight);
        return super.getPainterAt(context, bounds.width, bounds.height, x - bounds.x, y - bounds.y, proxyPainter);
    }

    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 0x800 | 0x1000;
    }

    public boolean isTransparent(PaintContext context) {
        return true;
    }

    protected float getAlignmentX(PaintContext context) {
        return context.getInteriorAlignmentX();
    }

    protected float getAlignmentY(PaintContext context) {
        return context.getInteriorAlignmentY();
    }

    private Rectangle _getPainterBounds(PaintContext context, int x, int y, int width, int height) {
        Dimension size;
        float hAlign = this.getAlignmentX(context);
        float vAlign = this.getAlignmentY(context);
        Dimension dimension = size = this._clipAlignment ? this.getSize(context, width, height) : this.getPreferredSize(context);
        if (this._clipAlignment && size.width > width) {
            size.width = width;
        } else {
            x += (int)((double)(width - size.width) * (double)hAlign);
        }
        if (this._clipAlignment && size.height > height) {
            size.height = height;
        } else {
            y += (int)((float)(height - size.height) * vAlign);
        }
        return new Rectangle(x, y, size.width, size.height);
    }
}

