/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf2;

import java.awt.Color;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.JComponent;
import javax.swing.JViewport;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicTextAreaUI;
import javax.swing.text.JTextComponent;

public class OracleTextAreaUI
extends BasicTextAreaUI {
    private static Border _sBorder;

    public static ComponentUI createUI(JComponent ta) {
        return new OracleTextAreaUI();
    }

    protected void propertyChange(PropertyChangeEvent e) {
        JTextComponent comp;
        Color background;
        super.propertyChange(e);
        if ("ancestor".equals(e.getPropertyName())) {
            if (this.getComponent().getBorder() instanceof UIResource) {
                if (this.getComponent().getParent() instanceof JViewport) {
                    if (_sBorder == null) {
                        Border b = UIManager.getBorder("TextArea.border");
                        Insets i = b.getBorderInsets(this.getComponent());
                        _sBorder = new EmptyBorderUIResource(i.top, i.left, i.bottom, i.right);
                    }
                    this.getComponent().setBorder(_sBorder);
                } else {
                    this.getComponent().setBorder(UIManager.getBorder("TextArea.border"));
                }
            }
        } else if ("enabled".equals(e.getPropertyName()) && (background = (comp = this.getComponent()).getBackground()) instanceof UIResource) {
            LookAndFeel.installProperty(comp, "opaque", e.getNewValue());
        }
    }

    private static class EmptyBorderUIResource
    extends EmptyBorder
    implements UIResource {
        public EmptyBorderUIResource(int top, int left, int bottom, int right) {
            super(top, left, bottom, right);
        }
    }
}

