/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.olaf;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.ewt.border.BorderAdapter;
import oracle.bali.ewt.olaf.ColorScheme;
import oracle.bali.ewt.olaf.OracleButtonPainter;
import oracle.bali.ewt.olaf.PainterButton;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.AndOrStatePainterSwitcher;
import oracle.bali.ewt.painter.FixedAlignmentPainter;
import oracle.bali.ewt.painter.FixedBorderPainter;
import oracle.bali.ewt.painter.IconPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextComponent;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.util.MenuUtils;
import oracle.bali.share.nls.StringUtils;

final class TitleBar
extends PaintContextComponent
implements PropertyChangeListener {
    private JInternalFrame _frame;
    private TitleLabel _titleLabel;
    private CaptionComp _captionComp;
    private boolean _armed;
    private JMenuBar _systemMenuBar;
    private JMenu _systemMenu;
    private JButton _minimizeButton;
    private JButton _maximizeButton;
    private JButton _restoreButton;
    private JButton _closeButton;
    static final String _SYSTEM_MENU_BUNDLE_NAME = "oracle.bali.ewt.olaf.resource.OLAFBundle";
    static final String _RESTORE_KEY = "SYSTEMMENU.RESTORE";
    static final String _MOVE_KEY = "SYSTEMMENU.MOVE";
    static final String _RESIZE_KEY = "SYSTEMMENU.RESIZE";
    static final String _MINIMIZE_KEY = "SYSTEMMENU.MINIMIZE";
    static final String _MAXIMIZE_KEY = "SYSTEMMENU.MAXIMIZE";
    static final String _CLOSE_KEY = "SYSTEMMENU.CLOSE";
    private Painter _sCaptionFill = new AndOrStatePainterSwitcher(new FixedBorderPainter(new FixedAlignmentPainter(new Tile(), 0.0f, 0.5f), 0, 8, 0, 0), null, 4, 0, 0, 0);
    private static final Painter _sButtonPainter = new OracleButtonPainter((Painter)new IconPainter(), true, true, false);

    public TitleBar(JInternalFrame frame) {
        this._frame = frame;
        this.setBorder(new BorderAdapter(new FixedBorderPainter(null, 0, 0, 2, 0, true, true)));
        this._createComponents();
        this._addListeners();
        this._updateButtons();
        this._updateFrameIcon();
        this._updateTitle();
        this._titleLabel.setFont(new Font("Dialog", 1, 12));
    }

    public boolean isArmed() {
        return this._armed;
    }

    public void setArmed(boolean armed) {
        if (armed != this._armed) {
            this._armed = armed;
            this.repaint();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propertyName = evt.getPropertyName();
        if (propertyName.equals("selected")) {
            if (this._frame.isIcon()) {
                this._frame.getDesktopIcon().repaint();
            }
        } else if (propertyName.equals("title")) {
            this._updateTitle();
        } else if (propertyName.equals("frameIcon") || propertyName.equals("JMenuBar")) {
            this._updateFrameIcon();
        } else if (propertyName.equals("maximum") || propertyName.equals("icon")) {
            this._updateButtons();
        }
    }

    public void doLayout() {
        this._updateButtons();
        super.doLayout();
    }

    public void removeNotify() {
        super.removeNotify();
        JInternalFrame frame = this.__getFrame();
        Container parent = this.getParent();
        if (frame != null && parent == null) {
            frame.removePropertyChangeListener(this);
            this._frame = null;
        }
    }

    public Color getBackground() {
        String bgKey = this._isActive() ? "InternalFrame.activeTitleBackground" : "InternalFrame.inactiveTitleBackground";
        Color color = this.getUIDefaults().getColor(bgKey);
        return color != null ? color : super.getBackground();
    }

    protected void paintComponent(Graphics g) {
        Color old = g.getColor();
        g.setColor(this.getBackground());
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setColor(old);
    }

    final JInternalFrame __getFrame() {
        return this._frame;
    }

    final JMenu __getSystemMenu() {
        return this._systemMenu;
    }

    private void _addListeners() {
        this._frame.addPropertyChangeListener(this);
        Armer armer = new Armer();
        this._titleLabel.addMouseListener(armer);
        this._captionComp.addMouseListener(armer);
        Redispatcher redispatcher = new Redispatcher();
        this._titleLabel.addMouseListener(redispatcher);
        this._titleLabel.addMouseMotionListener(redispatcher);
        this._captionComp.addMouseListener(redispatcher);
        this._captionComp.addMouseMotionListener(redispatcher);
        new SMLoader(this._systemMenu.getPopupMenu());
        Maximizer maximizer = new Maximizer();
        this._maximizeButton.addActionListener(maximizer);
        Minimizer minimizer = new Minimizer();
        this._minimizeButton.addActionListener(minimizer);
        Restorer restorer = new Restorer();
        this._restoreButton.addActionListener(restorer);
        Closer closer = new Closer();
        this._closeButton.addActionListener(closer);
        this._systemMenu.addMouseListener(closer);
        SystemMenuDisplayer displayer = new SystemMenuDisplayer();
        this._titleLabel.addMouseListener(displayer);
        this._captionComp.addMouseListener(displayer);
    }

    private JButton _createButton(String iconName) {
        PainterButton button = new PainterButton(_sButtonPainter);
        button.setIcon(this.getUIDefaults().getIcon(iconName));
        button.setFocusable(false);
        button.setBackground(null);
        return button;
    }

    private void _createComponents() {
        JMenuBar systemMenuBar = this._createSystemMenu();
        this._titleLabel = new TitleLabel();
        this._captionComp = new CaptionComp();
        JPanel captionPane = new JPanel(new BorderLayout());
        captionPane.add("West", this._titleLabel);
        captionPane.add("Center", this._captionComp);
        this._minimizeButton = this._createButton("InternalFrame.iconifyIcon");
        this._restoreButton = this._createButton("InternalFrame.minimizeIcon");
        this._maximizeButton = this._createButton("InternalFrame.maximizeIcon");
        this._closeButton = this._createButton("InternalFrame.closeIcon");
        JPanel buttonPane = new JPanel(new FlowLayout(0, 0, 0));
        buttonPane.add(this._minimizeButton);
        buttonPane.add(this._restoreButton);
        buttonPane.add(this._maximizeButton);
        buttonPane.add(this._closeButton);
        this.setLayout(new BorderLayout());
        this.add("West", systemMenuBar);
        this.add("Center", captionPane);
        this.add("East", buttonPane);
    }

    private JMenuBar _createSystemMenu() {
        this._systemMenu = new ImageMenu();
        this._systemMenu.setMnemonic('-');
        this._systemMenuBar = new JMenuBar();
        this._systemMenuBar.setOpaque(false);
        this._systemMenuBar.setBorder(new BorderAdapter(new FixedBorderPainter(null, 0, 0, 0, 2, true)));
        this._systemMenuBar.add(this._systemMenu);
        return this._systemMenuBar;
    }

    private boolean _isActive() {
        PaintContext context = this.getPaintContext();
        return (context.getPaintState() & 4) == 0;
    }

    private void _updateButtons() {
        JInternalFrame frame = this.__getFrame();
        boolean minimized = frame.isIcon();
        boolean maximized = frame.isMaximum();
        this._minimizeButton.setVisible(frame.isIconifiable() && !minimized);
        this._restoreButton.setVisible(minimized || maximized);
        this._maximizeButton.setVisible(frame.isMaximizable() && !maximized);
        this._closeButton.setVisible(frame.isClosable());
        this._minimizeButton.setBackground(null);
        this._restoreButton.setBackground(null);
        this._maximizeButton.setBackground(null);
        this._closeButton.setBackground(null);
    }

    private void _updateFrameIcon() {
        JInternalFrame frame = this.__getFrame();
        Icon frameIcon = frame.getFrameIcon();
        this._systemMenu.setIcon(frameIcon);
        this._systemMenuBar.setVisible(frameIcon != null);
    }

    private void _updateTitle() {
        JInternalFrame frame = this.__getFrame();
        String title = frame.getTitle();
        if (title != this._titleLabel.getText()) {
            this._titleLabel.setText(title);
        }
    }

    private class TitleLabel
    extends JLabel {
        private TitleLabel() {
        }

        public Color getForeground() {
            if (TitleBar.this != null) {
                String fgKey = TitleBar.this._isActive() ? "InternalFrame.activeTitleForeground" : "InternalFrame.inactiveTitleForeground";
                Color color = TitleBar.this.getUIDefaults().getColor(fgKey);
                if (color != null) {
                    return color;
                }
            }
            return super.getForeground();
        }
    }

    private class SystemMenuDisplayer
    extends MouseAdapter {
        private JPopupMenu _systemPopup;

        private SystemMenuDisplayer() {
        }

        public void mousePressed(MouseEvent evt) {
            JInternalFrame frame = TitleBar.this.__getFrame();
            if (!frame.isSelected()) {
                try {
                    frame.setSelected(true);
                }
                catch (PropertyVetoException e) {
                    return;
                }
            }
            this._popup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this._popup(evt);
        }

        private void _popup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                if (this._systemPopup == null) {
                    this._systemPopup = new JPopupMenu();
                    new SMLoader(this._systemPopup);
                }
                MenuUtils.showPopupMenu(this._systemPopup, (Component)evt.getSource(), evt.getX(), evt.getY());
                evt.consume();
            }
        }
    }

    private static class Tile
    extends AbstractPainter {
        private Tile() {
        }

        public int getRepaintFlags(PaintContext context) {
            return 2;
        }

        public Dimension getMinimumSize(PaintContext context) {
            return new Dimension(0, 12);
        }

        public Dimension getSize(PaintContext context, int availableWidth, int availableHeight) {
            return new Dimension(availableWidth, this.getMinimumSize((PaintContext)context).height);
        }

        public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
            UIDefaults defaults = context.getPaintUIDefaults();
            Color dark = Color.black;
            Color light = defaults.getColor(ColorScheme.NORMAL_INTENSITY);
            boolean armed = (context.getPaintState() & 2) != 0;
            int right = x + width - 1;
            if (x % 4 != 0) {
                x -= x % 4;
            }
            while (x < right) {
                if (x % 8 == 0) {
                    if (right - x >= 4) {
                        this._drawDot(g, x, y, dark, light, armed);
                        this._drawDot(g, x, y + 8, dark, light, armed);
                    }
                } else if (right - x >= 8) {
                    this._drawDot(g, x, y + 4, dark, light, armed);
                }
                x += 4;
            }
        }

        private void _drawDot(Graphics g, int x, int y, Color dark, Color light, boolean armed) {
            if (armed) {
                g.setColor(dark);
                g.drawLine(x + 1, y, x + 1, y);
                g.drawLine(x, y + 1, x, y + 1);
                g.setColor(light);
                g.drawLine(x + 2, y + 1, x + 2, y + 1);
                g.drawLine(x + 1, y + 2, x + 2, y + 2);
            } else {
                g.setColor(dark);
                g.drawLine(x + 2, y + 3, x + 2, y + 3);
                g.drawLine(x + 3, y + 2, x + 3, y + 2);
                g.setColor(light);
                g.drawLine(x + 1, y + 1, x + 2, y + 1);
                g.drawLine(x + 1, y + 2, x + 1, y + 2);
            }
        }
    }

    private class SMLoader
    implements PopupMenuListener {
        private JMenuItem _restoreItem = new JMenuItem();
        private JMenuItem _moveItem;
        private JMenuItem _resizeItem;
        private JMenuItem _minimizeItem;
        private JMenuItem _maximizeItem;
        private JMenuItem _closeItem;
        private Locale _menuLocale;

        public SMLoader(JPopupMenu popupMenu) {
            popupMenu.add(this._restoreItem);
            this._moveItem = new JMenuItem();
            popupMenu.add(this._moveItem);
            this._resizeItem = new JMenuItem();
            popupMenu.add(this._resizeItem);
            this._minimizeItem = new JMenuItem();
            popupMenu.add(this._minimizeItem);
            this._maximizeItem = new JMenuItem();
            popupMenu.add(this._maximizeItem);
            popupMenu.addSeparator();
            this._closeItem = new JMenuItem();
            this._closeItem.setAccelerator(KeyStroke.getKeyStroke(115, 2, true));
            popupMenu.add(this._closeItem);
            this._restoreItem.addActionListener(new Restorer());
            this._minimizeItem.addActionListener(new Minimizer());
            this._maximizeItem.addActionListener(new Maximizer());
            this._closeItem.addActionListener(new Closer());
            popupMenu.addPopupMenuListener(this);
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent evt) {
            this._updateMessages();
            this._updateEnabled();
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }

        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        private void _loadMessage(ResourceBundle bundle, JMenuItem item, String key) {
            String label = bundle.getString(key);
            if (label != null) {
                item.setText(StringUtils.stripMnemonic((String)label));
                item.setMnemonic(StringUtils.getMnemonicKeyCode((String)label));
            }
        }

        private void _updateEnabled() {
            JInternalFrame frame = TitleBar.this.__getFrame();
            boolean minimized = frame.isIcon();
            boolean maximized = frame.isMaximum();
            this._restoreItem.setEnabled(minimized || maximized);
            this._moveItem.setEnabled(false);
            this._resizeItem.setEnabled(false);
            this._minimizeItem.setEnabled(frame.isIconifiable() && !minimized);
            this._maximizeItem.setEnabled(frame.isMaximizable() && !maximized);
            this._closeItem.setEnabled(frame.isClosable());
        }

        private void _updateMessages() {
            ResourceBundle bundle;
            Locale locale = TitleBar.this.getLocale();
            if (locale == null) {
                locale = Locale.getDefault();
            }
            if (!locale.equals(this._menuLocale) && (bundle = ResourceBundle.getBundle(TitleBar._SYSTEM_MENU_BUNDLE_NAME, locale)) != null) {
                this._loadMessage(bundle, this._restoreItem, TitleBar._RESTORE_KEY);
                this._loadMessage(bundle, this._moveItem, TitleBar._MOVE_KEY);
                this._loadMessage(bundle, this._resizeItem, TitleBar._RESIZE_KEY);
                this._loadMessage(bundle, this._minimizeItem, TitleBar._MINIMIZE_KEY);
                this._loadMessage(bundle, this._maximizeItem, TitleBar._MAXIMIZE_KEY);
                this._loadMessage(bundle, this._closeItem, TitleBar._CLOSE_KEY);
                this._menuLocale = locale;
            }
        }
    }

    private class Restorer
    implements ActionListener {
        private Restorer() {
        }

        public void actionPerformed(ActionEvent evt) {
            JInternalFrame frame = TitleBar.this.__getFrame();
            try {
                if (frame.isMaximum()) {
                    frame.setMaximum(false);
                } else if (frame.isIcon()) {
                    frame.setIcon(false);
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class Redispatcher
    implements MouseListener,
    MouseMotionListener {
        private Redispatcher() {
        }

        public void mouseClicked(MouseEvent e) {
            this._redispatch(e);
        }

        public void mousePressed(MouseEvent e) {
            this._redispatch(e);
        }

        public void mouseReleased(MouseEvent e) {
            this._redispatch(e);
        }

        public void mouseDragged(MouseEvent e) {
            this._redispatch(e);
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        private void _redispatch(MouseEvent evt) {
            if (!SwingUtilities.isLeftMouseButton(evt)) {
                return;
            }
            JInternalFrame frame = TitleBar.this.__getFrame();
            JComponent source = frame.isIcon() ? frame.getDesktopIcon() : TitleBar.this;
            Point pos = SwingUtilities.convertPoint(evt.getComponent(), evt.getX(), evt.getY(), source);
            source.dispatchEvent(new MouseEvent(source, evt.getID(), evt.getWhen(), evt.getModifiers(), pos.x, pos.y, evt.getClickCount(), evt.isPopupTrigger()));
        }
    }

    private class Minimizer
    implements ActionListener {
        private Minimizer() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                TitleBar.this.__getFrame().setIcon(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private class Maximizer
    implements ActionListener {
        private Maximizer() {
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                TitleBar.this.__getFrame().setMaximum(true);
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
        }
    }

    private static class ImageMenu
    extends JMenu {
        private ImageMenu() {
        }

        protected void paintComponent(Graphics g) {
            Icon icon = this.getIcon();
            if (icon != null) {
                icon.paintIcon(this, g, 0, 0);
            }
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }

        public Dimension getMinimumSize() {
            Icon icon = this.getIcon();
            if (icon != null) {
                return new Dimension(icon.getIconWidth(), icon.getIconHeight());
            }
            return new Dimension(0, 0);
        }
    }

    private class Closer
    extends MouseAdapter
    implements ActionListener {
        private Closer() {
        }

        public void actionPerformed(ActionEvent evt) {
            this._close();
        }

        public void mousePressed(MouseEvent evt) {
            if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt)) {
                JMenu systemMenu = TitleBar.this.__getSystemMenu();
                systemMenu.setPopupMenuVisible(false);
                this._close();
            }
        }

        private void _close() {
            JInternalFrame frame = TitleBar.this.__getFrame();
            if (frame.isClosable()) {
                try {
                    frame.setClosed(true);
                }
                catch (PropertyVetoException propertyVetoException) {
                    // empty catch block
                }
            }
        }
    }

    private class CaptionComp
    extends PaintContextComponent {
        private CaptionComp() {
        }

        public Dimension getMinimumSize() {
            return TitleBar.this._sCaptionFill.getPreferredSize(this.getPaintContext());
        }

        public Dimension getPeferredSize() {
            return TitleBar.this._sCaptionFill.getPreferredSize(this.getPaintContext());
        }

        protected int getPaintState() {
            int state = super.getPaintState();
            if (TitleBar.this.isArmed()) {
                state |= 2;
            }
            return state;
        }

        protected void paintComponent(Graphics g) {
            Dimension size = this.getSize();
            TitleBar.this._sCaptionFill.paint(this.getPaintContext(), g, 0, 0, size.width, size.height);
        }
    }

    private class Armer
    extends MouseAdapter {
        private Armer() {
        }

        public void mousePressed(MouseEvent evt) {
            if (SwingUtilities.isLeftMouseButton(evt)) {
                TitleBar.this.setArmed(true);
            }
        }

        public void mouseReleased(MouseEvent evt) {
            TitleBar.this.setArmed(false);
        }
    }
}

