/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.bigCell;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.PrintGraphics;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.print.PrinterGraphics;
import javax.swing.UIManager;
import oracle.bali.ewt.graphics.Appearance;
import oracle.bali.ewt.graphics.GraphicsProxy;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.bigCell.AbstractBigCell;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.BorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.PaintContextProxy;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.util.ImmInsets;

public class BigCellPainter
extends AbstractPainter {
    public static final String BIG_CELL_KEY = "BigCell";
    private boolean _horizontalSeparatorsVisible;
    private boolean _verticalSeparatorsVisible;
    private Painter _painter;
    private boolean _keepCellsVisible = false;

    public BigCellPainter() {
        this(null);
    }

    public BigCellPainter(Painter painter) {
        this._painter = painter;
        this._horizontalSeparatorsVisible = true;
        this._verticalSeparatorsVisible = true;
    }

    public void setPainter(Painter painter) {
        if (this._painter != painter) {
            this._painter = painter;
        }
    }

    public Painter getPainter() {
        if (this._painter == null) {
            Object value = UIManager.get("Grid.DefaultCellPainter");
            this._painter = value instanceof Painter ? (Painter)value : null;
        }
        return this._painter;
    }

    public boolean getHorizontalSeparatorsVisible() {
        return this._horizontalSeparatorsVisible;
    }

    public void setHorizontalSeparatorsVisible(boolean visible) {
        this._horizontalSeparatorsVisible = visible;
    }

    public boolean getVerticalSeparatorsVisible() {
        return this._verticalSeparatorsVisible;
    }

    public void setVerticalSeparatorsVisible(boolean visible) {
        this._verticalSeparatorsVisible = visible;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean printing;
        Grid grid = (Grid)context.getPaintData("Grid");
        if (grid == null) {
            return;
        }
        if (grid.isCellBorderVisible()) {
            grid.setCellBorderVisible(false);
        }
        Appearance appearance = (Appearance)context.getPaintData("Appearance");
        ImmInsets cellInsets = appearance.getInsets();
        x -= cellInsets.left;
        y -= cellInsets.top;
        width += cellInsets.left + cellInsets.right;
        height += cellInsets.top + cellInsets.bottom;
        boolean l2r = context.getReadingDirection() == 1;
        Shape oldClip = g.getClip();
        int realX = x;
        int realY = y;
        int realWidth = width;
        int realHeight = height;
        AbstractBigCell bigCell = null;
        Object data = context.getPaintData(null);
        BorderPainter cellBorderP = null;
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (data instanceof AbstractBigCell) {
            Rectangle rect;
            int temp;
            bigCell = (AbstractBigCell)data;
            int column = bigCell.getColumn();
            int row = bigCell.getRow();
            int columnCount = bigCell.getColumnCount();
            int rowCount = bigCell.getRowCount();
            int firstColumn = grid.getNextVisibleColumn(column - 1);
            if (firstColumn >= column + columnCount) {
                return;
            }
            int firstRow = grid.getNextVisibleRow(row - 1);
            if (firstRow >= row + rowCount) {
                return;
            }
            realX = grid.getColumnPosition(firstColumn);
            realY = grid.getRowPosition(firstRow);
            if (!l2r) {
                realX = grid.getColumnPosition(column + columnCount - 1);
            }
            context = !printing ? grid.getCellPaintContext(column, row) : grid.getCellPrintPaintContext(g, column, row);
            context = new Proxy(grid, context, bigCell, bigCell.getData());
            realWidth = 0;
            for (int i = 0; i < columnCount; ++i) {
                temp = i + column;
                if (!grid.isColumnVisible(temp)) continue;
                realWidth += grid.getColumnWidth(temp);
            }
            realHeight = 0;
            for (int j = 0; j < rowCount; ++j) {
                temp = j + row;
                if (!grid.isRowVisible(temp)) continue;
                realHeight += grid.getRowHeight(temp);
            }
            if (!printing) {
                Point p = grid.convertCanvasToOuter(realX, realY);
                rect = new Rectangle(p.x, p.y, realWidth, realHeight);
                rect = rect.intersection(grid.getVisibleRect());
                p = grid.convertOuterToCanvas(rect.x, rect.y);
                rect.x = p.x;
                rect.y = p.y;
                g.setClip(rect);
            } else {
                Object clip;
                rect = new Rectangle(realX, realY, realWidth, realHeight);
                if (g instanceof GraphicsProxy && (clip = ((GraphicsProxy)g).get("grid.clipRect")) instanceof Rectangle) {
                    rect = rect.intersection((Rectangle)clip);
                    g.setClip(rect);
                }
            }
            if (this._keepCellsVisible) {
                realX = rect.x;
                realY = rect.y;
                realWidth = rect.width;
                realHeight = rect.height;
            }
            appearance = grid.getAppearanceManager().getCellPaintingAppearance(firstColumn, firstRow);
            cellBorderP = appearance.getBorderPainter();
            cellInsets = appearance.getInsets();
        } else {
            Cell cell = (Cell)context.getPaintData("Cell");
            appearance = grid.getAppearanceManager().getCellPaintingAppearance(cell.column, cell.row);
            cellBorderP = appearance.getBorderPainter();
            cellInsets = appearance.getInsets();
        }
        boolean hSeparatorVisible = this.getHorizontalSeparatorsVisible();
        Painter hSeparatorPainter = grid.getHorizontalSeparatorPainter();
        int hSeparatorHeight = hSeparatorVisible ? hSeparatorPainter.getPreferredSize((PaintContext)context).height : 0;
        boolean vSeparatorVisible = this.getVerticalSeparatorsVisible();
        Painter vSeparatorPainter = grid.getVerticalSeparatorPainter();
        int vSeparatorWidth = vSeparatorVisible ? vSeparatorPainter.getPreferredSize((PaintContext)context).width : 0;
        realWidth -= vSeparatorWidth;
        realHeight -= hSeparatorHeight;
        Color color = context.getPaintBackground();
        if (color != null) {
            g.setColor(color);
            g.fillRect(realX, realY, realWidth, realHeight);
        }
        if (grid.isEnabled() && appearance.getBackground() == null) {
            Painter fillPainter;
            boolean transparent = false;
            int state = context.getPaintState();
            if ((state & 0x20) != 0) {
                if ((state & 4) == 0 && appearance.getSelectBackground() == null) {
                    transparent = true;
                }
            } else {
                transparent = true;
            }
            if (transparent && (fillPainter = grid.getFill()) != null) {
                fillPainter.paint(context, g, 0, 0, grid.getWidth(), grid.getHeight());
            }
        }
        g.setColor(context.getPaintForeground());
        g.setFont(context.getPaintFont());
        Painter painter = this.getPainter();
        if (cellBorderP != null) {
            cellBorderP.paint(context, g, realX, realY, realWidth, realHeight);
            ImmInsets insets = cellBorderP.getInsets(context);
            if (painter != null) {
                painter.paint(context, g, realX + insets.left + cellInsets.left, realY + insets.top + cellInsets.top, realWidth - (insets.left + insets.right) - (cellInsets.left + cellInsets.right), realHeight - (insets.top + insets.bottom) - (cellInsets.top + cellInsets.bottom));
            }
        } else if (painter != null) {
            painter.paint(context, g, realX + cellInsets.left, realY + cellInsets.top, realWidth - (cellInsets.left + cellInsets.right), realHeight - (cellInsets.top + cellInsets.bottom));
        }
        if (hSeparatorVisible) {
            hSeparatorPainter.paint(context, g, realX, realY + realHeight, realWidth + vSeparatorWidth, hSeparatorHeight);
        }
        if (vSeparatorVisible) {
            vSeparatorPainter.paint(context, g, realX + realWidth, realY, vSeparatorWidth, realHeight + hSeparatorHeight);
        }
        g.setClip(oldClip);
    }

    public void setKeepCellsVisible(boolean keepCellsVisible) {
        this._keepCellsVisible = keepCellsVisible;
    }

    public boolean isKeepCellsVisible() {
        return this._keepCellsVisible;
    }

    public Dimension getMinimumSize(PaintContext context) {
        if (this.getPainter() != null) {
            return this.getPainter().getMinimumSize(context);
        }
        return new Dimension(0, 0);
    }

    public int getRepaintFlags(PaintContext context) {
        return 0;
    }

    private class Proxy
    extends PaintContextProxy {
        private Grid _grid;
        private PaintContext _toProxy;
        private Object _realData;
        private Object _bigCell;

        public Proxy(Grid grid, PaintContext toProxy, AbstractBigCell bigCell, Object realData) {
            this._grid = grid;
            this._toProxy = toProxy;
            this._bigCell = bigCell;
            this._realData = realData;
        }

        public Object getPaintData(Object key) {
            Object data;
            if (BigCellPainter.BIG_CELL_KEY.equals(key)) {
                return this._bigCell;
            }
            if ("Cell".equals(key)) {
                return super.getPaintData(key);
            }
            if ("Appearance".equals(key)) {
                return super.getPaintData(key);
            }
            if ("Grid".equals(key)) {
                return super.getPaintData(key);
            }
            if ("Model".equals(key)) {
                return super.getPaintData(key);
            }
            if (key != null && (data = super.getPaintData(key)) != this._bigCell) {
                return data;
            }
            return this._realData;
        }

        protected PaintContext getPaintContext() {
            return this._toProxy;
        }
    }
}

