/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.ewt.selection.TwoDSelection;

public abstract class AbstractGridSelectionManager
implements GridSelectionManager {
    private GeometryChangeListener _listener;
    private PropertyChangeSupport _propertyChangeSupport;
    private VetoableChangeSupport _vetoableChangeSupport;

    protected AbstractGridSelectionManager() {
    }

    public TwoDModelListener getTwoDModelListener() {
        if (this._listener == null) {
            this._listener = new GeometryChangeListener();
        }
        return this._listener;
    }

    protected void rowsAdded(int start, int number) {
    }

    protected void rowsRemoved(int start, int number) {
    }

    protected void columnsAdded(int start, int number) {
    }

    protected void columnsRemoved(int start, int number) {
    }

    public abstract TwoDSelection getSelection();

    public abstract void addSelection(TwoDSelection var1) throws PropertyVetoException;

    public abstract void removeSelection(TwoDSelection var1) throws PropertyVetoException;

    public abstract void setSelection(TwoDSelection var1, Cell var2) throws PropertyVetoException;

    public TwoDSelection getRepaintSelection(TwoDSelection oldSelection, TwoDSelection newSelection) {
        return oldSelection.add(newSelection);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport == null) {
            this._propertyChangeSupport = new PropertyChangeSupport(this);
        }
        this._propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.removePropertyChangeListener(listener);
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoableChangeSupport == null) {
            this._vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this._vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.removeVetoableChangeListener(listener);
        }
    }

    protected void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        if (this._vetoableChangeSupport != null) {
            this._vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
        }
    }

    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this._propertyChangeSupport != null) {
            this._propertyChangeSupport.firePropertyChange(propertyName, oldValue, newValue);
        }
    }

    private class GeometryChangeListener
    implements TwoDModelListener {
        private GeometryChangeListener() {
        }

        public void rowsAdded(TwoDModelEvent e) {
            int startIndex = e.getRowStartIndex();
            int count = e.getRowCount();
            AbstractGridSelectionManager.this.rowsAdded(startIndex, count);
        }

        public void rowsRemoved(TwoDModelEvent e) {
            int startIndex = e.getRowStartIndex();
            int count = e.getRowCount();
            AbstractGridSelectionManager.this.rowsRemoved(startIndex, count);
        }

        public void invalidateRows(TwoDModelEvent e) {
        }

        public void columnsAdded(TwoDModelEvent e) {
            int startIndex = e.getColumnStartIndex();
            int count = e.getColumnCount();
            AbstractGridSelectionManager.this.columnsAdded(startIndex, count);
        }

        public void columnsRemoved(TwoDModelEvent e) {
            int startIndex = e.getColumnStartIndex();
            int count = e.getColumnCount();
            AbstractGridSelectionManager.this.columnsRemoved(startIndex, count);
        }

        public void invalidateColumns(TwoDModelEvent e) {
        }

        public void invalidateCells(TwoDModelEvent e) {
        }
    }
}

