/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.basic;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import oracle.bali.ewt.LookAndFeel;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;

public class PivotHeaderGrippyPainterWithBorder
extends AbstractPainter {
    private static final int _GRIPPY_SIZE = 3;
    private static final int _GRIPPY_GAP = 4;
    private static final int _GRIPPY_STRIDE = 7;
    private static final int _MIN_GRIPPIES = 3;
    private static final int _MIN_PERP_GRIPPY_SIZE = 7;
    private static final int _MIN_ORIENT_GRIPPY_SIZE = 17;
    private boolean _ignoreActive;
    private static Painter _sPainter;
    private static Painter _sIgnoreActivePainter;

    public static Painter getPainter(boolean ignoreActive) {
        if (ignoreActive) {
            if (_sIgnoreActivePainter == null) {
                _sIgnoreActivePainter = new PivotHeaderGrippyPainterWithBorder(true);
            }
            return _sIgnoreActivePainter;
        }
        if (_sPainter == null) {
            _sPainter = new PivotHeaderGrippyPainterWithBorder(false);
        }
        return _sPainter;
    }

    public Dimension getSize(PaintContext context, int width, int height) {
        if (width > 7) {
            width = 7;
        }
        if (height > 17) {
            height = 17;
        }
        return new Dimension(width, height);
    }

    public Dimension getMinimumSize(PaintContext context) {
        return new Dimension(7, 17);
    }

    public int getRepaintFlags(PaintContext context) {
        int state = 131;
        if (!this._ignoreActive) {
            state |= 4;
        }
        return state;
    }

    public void paint(PaintContext context, Graphics g, int x, int y, int width, int height) {
        boolean paint;
        boolean active;
        boolean printing;
        Color savedColor = g.getColor();
        int state = context.getPaintState();
        boolean bl = printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        if (!printing) {
            boolean raised;
            Object data;
            Color grippyColor = UIManager.getColor("EWTPivotPivotGrippy.background");
            g.setColor(grippyColor);
            g.fillRect(x - 1, y - 1, width + 1, height + 1);
            Color darkShadow = null;
            if ((state & 1) == 0 && (data = context.getPaintData("headerItemBorderColor")) instanceof Color) {
                darkShadow = (Color)data;
            }
            if (darkShadow == null) {
                darkShadow = UIManager.getColor("EWTPivot.darkShadow");
            }
            g.setColor(darkShadow);
            g.drawLine(x + width, y - 1, x + width, y + height);
            data = context.getPaintData(Header.KEY_DRAW_RAISED);
            boolean bl2 = raised = data instanceof Boolean ? (Boolean)data : true;
            if (raised) {
                g.setColor(Color.white);
                g.drawLine(x + width + 1, y, x + width + 1, y + height - 1);
            }
        }
        boolean enabled = (state & 1) == 0;
        boolean bl3 = active = (state & 4) == 0;
        if (this._ignoreActive) {
            active = true;
        }
        boolean bl4 = printing ? false : (paint = enabled && active);
        if (paint) {
            boolean isArmed;
            int numGrippies = 3;
            int grippySize = numGrippies * 3 + (numGrippies - 1) * 4;
            int grippyWidth = 3;
            int grippyHeight = 3;
            int xOffset = 0;
            int yOffset = 0;
            grippyHeight = grippySize;
            yOffset = 7;
            int grippyX = x - 1 + (width - grippyWidth) / 2;
            int grippyY = y + (height - grippyHeight) / 2;
            UIDefaults defaults = context.getPaintUIDefaults();
            Color highlight = defaults.getColor(LookAndFeel.CONTROL_LT_HIGHLIGHT);
            Color shadow = defaults.getColor(LookAndFeel.CONTROL_SHADOW);
            Color dark = defaults.getColor(LookAndFeel.CONTROL_DK_SHADOW);
            Color black = Color.black;
            boolean bl5 = isArmed = (state & 2) != 0;
            while (numGrippies > 0) {
                PivotHeaderGrippyPainterWithBorder.__drawGrippy(g, grippyX, grippyY, highlight, dark, black, isArmed);
                --numGrippies;
                grippyX += xOffset;
                grippyY += yOffset;
            }
        }
        g.setColor(savedColor);
    }

    static void __drawGrippy(Graphics g, int x, int y, Color highlight, Color dark, Color black, boolean isArmed) {
        g.setColor(dark);
        g.drawLine(x + 1, y + 1, x + 2, y + 2);
        if (isArmed) {
            g.setColor(black);
            g.drawLine(x + 2, y + 1, x + 2, y + 1);
            g.setColor(highlight);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        } else {
            g.setColor(highlight);
            g.drawLine(x + 2, y + 1, x + 2, y + 1);
            g.setColor(black);
            g.drawLine(x + 1, y + 2, x + 1, y + 2);
        }
    }

    private PivotHeaderGrippyPainterWithBorder(boolean ignoreActive) {
        this._ignoreActive = ignoreActive;
    }
}

