/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.dateEditor;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.TimeZone;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.access.OracleAccessibleRole;
import oracle.bali.ewt.elaf.EWTDateEditorUI;
import oracle.bali.ewt.elaf.EWTSpinnerUI;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.spinBox.SpinAccelerator;
import oracle.bali.ewt.spinBox.SpinButton;
import oracle.bali.ewt.spinBox.SpinButtonEvent;
import oracle.bali.ewt.spinBox.SpinButtonListener;
import oracle.bali.ewt.util.ImmInsets;
import oracle.bali.ewt.util.StringUtils;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.util.IntegerUtils;

public class DateEditor
extends LWComponent
implements Accessible {
    public static final String PROPERTY_DATE = "date";
    static final String _RESOURCE_BUNDLE = "oracle.bali.ewt.resource.AccessibilityBundle";
    static final String _INCREMENT_KEY = "INCREMENT";
    static final String _DECREMENT_KEY = "DECREMENT";
    static final String _LEFT_KEY = "NAVIGATE_LEFT";
    static final String _RIGHT_KEY = "NAVIGATE_RIGHT";
    static final String _AM_PM_KEY = "AM_PM";
    static final String _ZONE_OFFSET_KEY = "ZONE_OFFSET";
    static final String _YEAR_KEY = "YEAR";
    static final String _MONTH_KEY = "MONTH";
    static final String _DAY_OF_MONTH_KEY = "DAY_OF_MONTH";
    static final String _HOUR_OF_DAY_KEY = "HOUR_OF_DAY";
    static final String _MINUTE_KEY = "MINUTE";
    static final String _SECOND_KEY = "SECOND";
    static final String _MILLISECOND_KEY = "MILLISECOND";
    static final String _DAY_OF_WEEK_KEY = "DAY_OF_WEEK";
    private static final int _AM_PM = 0;
    private static final int _ZONE = 1;
    private static final int _YEAR = 2;
    private static final int _MONTH = 3;
    private static final int _DAY = 4;
    private static final int _HOUR_OF_DAY0 = 5;
    private static final int _HOUR1 = 6;
    private static final int _MINUTE = 7;
    private static final int _SECOND = 8;
    private static final int _MILLISECOND = 9;
    private static final int _HOUR_OF_DAY1 = 10;
    private static final int _HOUR0 = 11;
    private static final int _DAY_OF_WEEK = 12;
    private static int[] _constantArray;
    private static final int[] _DATE_FORMAT_ARRAY;
    private static final int[] _CALENDAR_ARRAY;
    private static final int _LEFT_MARGIN = 2;
    SpinButton _spinButton;
    int _currentField;
    private Calendar _calendar;
    private DateFormat _dateFormat;
    private Date _date;
    private Date _maximum;
    private Date _minimum;
    int _fieldCount;
    int[] _fields = new int[13];
    private int[] _formatFields = new int[13];
    private int _textXOffset;
    private boolean _defaultDateFormat;
    private boolean _defaultCalendar;
    private boolean _nullDate;
    private boolean _validateCurrentField = false;

    public DateEditor() {
        this(new Date());
    }

    public DateEditor(Date d) {
        this(d, Calendar.getInstance(), DateFormat.getInstance());
        this._defaultDateFormat = true;
        this._defaultCalendar = true;
    }

    public DateEditor(Date d, Calendar c, DateFormat df) {
        if (!(df instanceof SimpleDateFormat)) {
            throw new IllegalArgumentException("DateFormat must be a SimpleDateFormat");
        }
        this._nullDate = d == null;
        this._calendar = c;
        this._dateFormat = df;
        this._date = d;
        if (!this._nullDate) {
            this._calendar.setTime(d);
        }
        this._dateFormat.setCalendar(c);
        UIListener listener = new UIListener();
        this._spinButton = new SpinButton(false);
        this._spinButton.addSpinButtonListener(listener);
        this.setLayout(null);
        this.add(this._spinButton);
        this._currentField = -1;
        this._parseDateFormat();
        long mask = 28L;
        this.enableEvents(mask);
        this.setAlignmentX(0.0f);
        this.setAlignmentY(0.5f);
        this.updateUI();
    }

    public void updateUI() {
        this.setUI((EWTSpinnerUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return "EWTDateEditorUI";
    }

    public void setCalendar(Calendar c) {
        Calendar old = this._calendar;
        Date oldDate = this._calendar == null ? null : this._calendar.getTime();
        this._defaultCalendar = false;
        this._calendar = c;
        this._date = this._calendar.getTime();
        this._nullDate = this._date == null;
        this.getDateFormat().setCalendar(c);
        this.firePropertyChange("calendar", old, c);
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleVisibleData", oldDate, this._date);
        }
        if (!this._nullDate) {
            if (this._minimum != null && this._date.before(this._minimum)) {
                this.setDate(this._minimum);
            }
            if (this._maximum != null && this._date.after(this._maximum)) {
                this.setDate(this._maximum);
            }
        }
        this.repaint();
    }

    public Calendar getCalendar() {
        return this._calendar;
    }

    public void setDateFormat(DateFormat df) {
        if (!(df instanceof SimpleDateFormat)) {
            throw new IllegalArgumentException("DateFormat must be a SimpleDateFormat");
        }
        this._defaultDateFormat = false;
        DateFormat old = this._dateFormat;
        df.setCalendar(this.getCalendar());
        this._dateFormat = df;
        this._parseDateFormat();
        this.firePropertyChange("dateFormat", old, df);
        this._currentField = -1;
        this.repaint();
    }

    public DateFormat getDateFormat() {
        return this._dateFormat;
    }

    public void setDate(Date d) {
        AccessibleContext ac;
        this._nullDate = d == null;
        Date old = this._date;
        this._date = d;
        if (!this._nullDate) {
            this._date = this._checkMinMax(this._date, true);
        }
        if ((ac = this.accessibleContext) != null) {
            ac.firePropertyChange("AccessibleVisibleData", old, this._date);
        }
        this.firePropertyChange(PROPERTY_DATE, old, this._date);
        this.repaint();
    }

    public Date getDate() {
        return this._date;
    }

    public void setMinimumDate(Date minimum) {
        Date old = this._minimum;
        this._minimum = minimum;
        if (this._minimum != null && this._maximum != null && this._minimum.after(this._maximum)) {
            this._minimum = this._maximum;
        }
        this.firePropertyChange("minimumDate", old, this._minimum);
        this.setDate(this._date);
    }

    public Date getMinimumDate() {
        return this._minimum;
    }

    public void setMaximumDate(Date maximum) {
        Date old = this._maximum;
        this._maximum = maximum;
        if (this._maximum != null && this._minimum != null && this._maximum.before(this._minimum)) {
            this._maximum = this._minimum;
        }
        this.firePropertyChange("maximumDate", old, this._maximum);
        this.setDate(this._date);
    }

    public Date getMaximumDate() {
        return this._maximum;
    }

    public String getDateString() {
        if (this._nullDate) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        Position position = new Position(1);
        sb = this.getFieldPosition(this.getDate(), sb, position);
        sb = this._getProperlyFormatedDate(position);
        return sb.toString();
    }

    public void setDateString(String date) throws ParseException {
        this.setDate(this.getDateFormat().parse(date));
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleDateEditor();
        }
        return this.accessibleContext;
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        locale = LocaleUtils.getDefaultableLocale((Component)this);
        if (this._defaultCalendar) {
            this.setCalendar(Calendar.getInstance(locale));
        }
        if (this._defaultDateFormat) {
            DateFormat f = DateFormat.getDateTimeInstance(3, 3, locale);
            this.setDateFormat(f);
        }
    }

    public boolean isFocusTraversable() {
        return true;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._spinButton.setEnabled(enabled);
    }

    public void paintInterior(Graphics g) {
        EWTDateEditorUI ui = this._getEWTDateEditorUI();
        this._paintText(g, ui.getTextPainter(this));
        if (this._currentField != -1 && this.isEnabled()) {
            this._paintCurrentField(g);
        }
    }

    public void doLayout() {
        Dimension totalSize = this.getSize();
        Dimension prefSize = this._spinButton.getPreferredSize();
        EWTSpinnerUI ui = this._getEWTSpinnerUI();
        ImmInsets insets = this.getBorderInsets();
        ImmInsets spinInsets = ui.getSpinButtonInsets(this);
        int spinHeight = totalSize.height - (insets.top + insets.bottom) - (spinInsets.top + spinInsets.bottom);
        int spinWidth = this._spinButton.getPreferredSize().width - (spinInsets.left + spinInsets.right);
        int totalWidth = totalSize.width - (insets.left + insets.right);
        if (this.getActualReadingDirection() == 1) {
            this._spinButton.setBounds(totalWidth - prefSize.width + insets.left + spinInsets.left, spinInsets.top + insets.top, spinWidth, spinHeight);
            this._textXOffset = 2;
        } else {
            this._spinButton.setBounds(insets.left + spinInsets.left, spinInsets.top + insets.top, spinWidth, spinHeight);
            this._textXOffset = spinInsets.left + spinWidth + 2;
        }
    }

    protected StringBuffer getFieldPosition(Date date, StringBuffer buffer, Position position) {
        DateFormat df = this.getDateFormat();
        FieldPosition fp = new FieldPosition(position.field);
        if (!this._nullDate) {
            buffer = df.format(date, buffer, fp);
            position.beginIndex = fp.getBeginIndex();
            position.endIndex = fp.getEndIndex();
        } else {
            position.beginIndex = 0;
            position.endIndex = -1;
        }
        return buffer;
    }

    protected int getPreferredFieldSize(Position position) {
        int fieldSize = position.endIndex - position.beginIndex;
        if (fieldSize == 1) {
            ++fieldSize;
        }
        return fieldSize;
    }

    protected void rollField(int calendarField, boolean up) {
        Calendar c = this.getCalendar();
        AccessibleContext ac = this.accessibleContext;
        AccessibleContext childAC = ac == null ? null : ac.getAccessibleChild(this._currentField).getAccessibleContext();
        String oldName = childAC == null ? null : childAC.getAccessibleName();
        switch (calendarField) {
            case 9: {
                int hour = c.get(11);
                int minute = c.get(12);
                int year = c.get(1);
                int month = c.get(2);
                int day = c.get(5);
                hour = c.get(9) == 0 ? (hour += 12) : (hour -= 12);
                c.set(year, month, day, hour, minute);
                break;
            }
            case 15: {
                int i;
                String current = c.getTimeZone().getID();
                String[] zones = TimeZone.getAvailableIDs();
                int zoneCount = zones.length;
                for (i = 0; i < zoneCount && !current.equals(zones[i]); ++i) {
                }
                int index = i;
                index = index == 0 && up ? zoneCount - 1 : (index == zoneCount - 1 && !up ? 0 : (up ? --index : ++index));
                TimeZone next = TimeZone.getTimeZone(zones[index]);
                c.setTimeZone(next);
                break;
            }
            default: {
                c.roll(calendarField, up);
            }
        }
        Date old = this._date;
        this._date = c.getTime();
        this._nullDate = this._date == null;
        this._date = this._checkMinMax(this._date, false);
        this.firePropertyChange(PROPERTY_DATE, old, this._date);
        if (childAC != null) {
            childAC.firePropertyChange("AccessibleName", oldName, childAC.getAccessibleName());
        }
        this.repaint();
    }

    protected int getFieldValue(int calendarField) {
        return this.getCalendar().get(calendarField);
    }

    protected void setFieldValue(int calendarField, int newValue, int fieldSize) {
        Calendar cal = this.getCalendar();
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        int year = cal.get(1);
        int month = cal.get(2);
        int day = cal.get(5);
        switch (calendarField) {
            case 11: {
                if (this._fieldUsed(9)) {
                    if (cal.get(9) == 1) {
                        if (newValue == 12) {
                            newValue = 0;
                        }
                        newValue += 12;
                    } else if (newValue == 12) {
                        newValue = 0;
                    }
                }
                hour = newValue;
                break;
            }
            case 12: {
                minute = newValue;
                break;
            }
            case 1: {
                if (fieldSize == 2) {
                    int currentYear = this.getDate().getYear();
                    int currentCentury = 1900 + currentYear / 100 * 100;
                    int mod = currentYear % 100;
                    if (mod < 50) {
                        currentCentury -= 100;
                    }
                    newValue = newValue >= 50 ? currentCentury + newValue : currentCentury + 100 + newValue;
                }
                year = newValue;
                break;
            }
            case 2: {
                if (newValue != 0) {
                    month = newValue - 1;
                    break;
                }
                month = newValue;
                break;
            }
            case 5: {
                day = newValue;
                break;
            }
            case 13: {
                second = newValue;
            }
        }
        cal.set(year, month, day, hour, minute, second);
    }

    protected int getFieldMinimum(int calendarField) {
        return this.getCalendar().getMinimum(calendarField);
    }

    protected int getFieldMaximum(int calendarField) {
        return this.getCalendar().getMaximum(calendarField);
    }

    protected int getCurrentField() {
        return this._currentField == -1 ? -1 : this._fields[this._currentField];
    }

    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed() || !this.isEnabled()) {
            return;
        }
        if (e.getID() != 501 || !SwingUtilities.isLeftMouseButton(e)) {
            return;
        }
        this.requestFocus();
        int newField = this._getFieldAt(e.getX());
        if (newField != -1) {
            this._setCurrentField(newField);
            if (this.hasFocus()) {
                this.repaint();
            }
        }
    }

    protected void processComponentKeyEvent(KeyEvent e) {
        boolean modifier;
        super.processComponentKeyEvent(e);
        int id = e.getID();
        int code = e.getKeyCode();
        boolean bl = modifier = e.isAltDown() || e.isControlDown() || e.isMetaDown() || e.isShiftDown();
        if (id == 401 && (code != 38 && code != 40 || modifier)) {
            this._spinButton.setIncrementArmed(false);
            this._spinButton.setDecrementArmed(false);
        }
        if (e.isConsumed() || !this.isEnabled() || e.isAltDown() || modifier && id != 400) {
            return;
        }
        switch (id) {
            case 401: {
                this._processKeyPressed(e);
                break;
            }
            case 400: {
                this._processKeyTyped(e);
                break;
            }
            case 402: {
                this._processKeyReleased(e);
            }
        }
    }

    protected void processFocusEvent(FocusEvent e) {
        AccessibleContext ac;
        super.processFocusEvent(e);
        if (e.getID() == 1005) {
            this._spinButton.setIncrementArmed(false);
            this._spinButton.setDecrementArmed(false);
        }
        if ((ac = this.accessibleContext) != null) {
            ac.firePropertyChange("AccessibleState", this.hasFocus() ? AccessibleState.FOCUSED : null, this.hasFocus() ? null : AccessibleState.FOCUSED);
            if (this._currentField != -1) {
                ac.getAccessibleChild(this._currentField).getAccessibleContext().firePropertyChange("AccessibleState", this.hasFocus() ? AccessibleState.FOCUSED : null, this.hasFocus() ? null : AccessibleState.FOCUSED);
            }
        }
        if (this._nullDate) {
            this._resetDate();
        }
        if (this._currentField == -1) {
            this._setCurrentField(0);
        } else if (this._validateCurrentField) {
            this._date = this._checkMinMax(this._date, false);
        }
        if (e.getID() == 1004) {
            this._fireAccessibleName();
        }
        this.repaint();
    }

    protected Object getPaintData(Object key) {
        if ("GapX".equals(key)) {
            Rectangle bounds = this._spinButton.getBounds();
            if (this.getActualReadingDirection() == 1) {
                return new Integer(bounds.x - 1);
            }
            return new Integer(bounds.x + bounds.width);
        }
        if (key == PaintContext.LABEL_KEY) {
            return this.getDateString();
        }
        return super.getPaintData(key);
    }

    void rollCurrentField(boolean up) {
        if (!this._nullDate) {
            if (this._currentField == -1) {
                this._setCurrentField(0);
            }
            int field = this._fields[this._currentField];
            this.rollField(field, up);
        } else {
            this._resetDate();
        }
    }

    int getPreviousField(int oldField) {
        if (oldField == -1) {
            return 0;
        }
        if (oldField != 0) {
            return oldField - 1;
        }
        return oldField;
    }

    int getNextField(int oldField) {
        if (oldField == -1) {
            return 0;
        }
        if (oldField != this._fieldCount - 1) {
            return oldField + 1;
        }
        return oldField;
    }

    void _setCurrentField(int newValue) {
        if (this._validateCurrentField) {
            this._date = this._checkMinMax(this._date, false);
        }
        Calendar cal = this.getCalendar();
        int oldField = this._currentField;
        Integer oldValue = this._currentField == -1 ? null : new Integer(cal.get(this._fields[this._currentField]));
        this._currentField = newValue;
        Integer newNumber = null;
        if (this._currentField != -1) {
            int field = this._fields[this._currentField];
            int min = this.getFieldMinimum(field);
            int max = this.getFieldMaximum(field);
            SpinAccelerator accel = SpinAccelerator.createDefaultAccelerator(max - min + 1);
            this._spinButton.setAccelerator(accel);
            newNumber = new Integer(cal.get(field));
        }
        this._fireAccessibleSelection(oldField, this._currentField);
        this._fireAccessibleActive(oldField, this._currentField);
        this._fireAccessibleFocus(oldField, this._currentField);
        this._fireAccessibleCurrFieldName();
    }

    static String getDescription(int field, Locale l) {
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE_BUNDLE, l);
        String desc = null;
        switch (field) {
            case 9: {
                desc = b.getString(_AM_PM_KEY);
                break;
            }
            case 15: {
                desc = b.getString(_ZONE_OFFSET_KEY);
                break;
            }
            case 1: {
                desc = b.getString(_YEAR_KEY);
                break;
            }
            case 2: {
                desc = b.getString(_MONTH_KEY);
                break;
            }
            case 5: {
                desc = b.getString(_DAY_OF_MONTH_KEY);
                break;
            }
            case 11: {
                desc = b.getString(_HOUR_OF_DAY_KEY);
                break;
            }
            case 12: {
                desc = b.getString(_MINUTE_KEY);
                break;
            }
            case 13: {
                desc = b.getString(_SECOND_KEY);
                break;
            }
            case 14: {
                desc = b.getString(_MILLISECOND_KEY);
                break;
            }
            case 7: {
                desc = b.getString(_DAY_OF_WEEK_KEY);
            }
        }
        return desc;
    }

    private void _resetDate() {
        this.setDate(this.getDefaultDate());
    }

    protected Date getDefaultDate() {
        return new Date();
    }

    private EWTDateEditorUI _getEWTDateEditorUI() {
        return (EWTDateEditorUI)((Object)this.ui);
    }

    private EWTSpinnerUI _getEWTSpinnerUI() {
        return (EWTSpinnerUI)this.ui;
    }

    private void _paintText(Graphics g, Painter painter) {
        Dimension d = this.getSize();
        ImmInsets insets = this.getBorderInsets();
        EWTDateEditorUI ui = this._getEWTDateEditorUI();
        if (insets != null) {
            d.width -= insets.left + insets.right;
            d.height -= insets.top + insets.bottom;
        }
        PaintContext context = this.getPaintContext();
        d.width -= this._spinButton.getSize().width;
        Dimension prefSize = painter.getPreferredSize(context);
        int x = this.getActualReadingDirection() == 1 ? 0 : this._textXOffset;
        painter.paint(context, g, x, 0, d.width, d.height);
    }

    private int _getFieldAt(int x) {
        int offset = this.getSize().height / 2;
        for (int i = 0; i < this._fieldCount; ++i) {
            Rectangle rect = this._getFieldBounds(i);
            if (!rect.contains(x, offset + 1)) continue;
            return i;
        }
        return -1;
    }

    private StringBuffer _getProperlyFormatedDate(Position p) {
        StringBuffer sb = new StringBuffer();
        Position position = new Position(1);
        sb = this.getFieldPosition(this.getDate(), sb, position);
        StringBuffer temp = new StringBuffer(sb.toString());
        int diff = position.endIndex - position.beginIndex - this._getYearLength();
        if (diff > 0) {
            sb = sb.delete(position.beginIndex, position.beginIndex + diff);
        }
        diff = temp.length() - sb.length();
        if (position.beginIndex == p.beginIndex) {
            p.endIndex -= diff;
        } else if (position.beginIndex < p.beginIndex) {
            p.beginIndex -= diff;
            p.endIndex -= diff;
        }
        return sb;
    }

    private int _getYearLength() {
        SimpleDateFormat sdf = (SimpleDateFormat)this.getDateFormat();
        String pattern = sdf.toPattern();
        int i = pattern.indexOf(121);
        int j = pattern.lastIndexOf(121);
        if (i == -1 || j == -1) {
            return 0;
        }
        return j - i + 1;
    }

    Rectangle _getFieldBounds(int fieldIndex) {
        if (this._nullDate) {
            return new Rectangle(0, 0, 0, 0);
        }
        StringBuffer sb = new StringBuffer();
        Position position = new Position(this._formatFields[fieldIndex]);
        sb = this.getFieldPosition(this.getDate(), sb, position);
        sb = this._getProperlyFormatedDate(position);
        EWTDateEditorUI ui = this._getEWTDateEditorUI();
        PaintContext context = this.getPaintContext();
        String temp = sb.toString();
        temp = StringUtils.getDisplayString(temp, LocaleUtils.getDefaultableLocale((Component)this), 1);
        Font font = context.getPaintFont();
        FontMetrics fm = context.getFontMetrics(font);
        int beginIndex = position.beginIndex;
        int x = beginIndex != 0 ? fm.stringWidth(temp.substring(0, beginIndex)) : 0;
        int width = fm.stringWidth(temp.substring(beginIndex, position.endIndex));
        Painter painter = ui.getTextPainter(this);
        Dimension d = this.getSize();
        ImmInsets insets = this.getBorderInsets();
        Dimension prefSize = painter.getPreferredSize(context);
        if (insets != null) {
            d.width -= insets.left + insets.right;
            d.height -= insets.top + insets.bottom;
        }
        if (this.getActualReadingDirection() == 2) {
            x = d.width - (x + width);
        } else if (beginIndex != 0) {
            x += this._textXOffset;
        } else {
            width += this._textXOffset;
        }
        return new Rectangle(x, 0, width, d.height);
    }

    private void _paintCurrentField(Graphics g) {
        EWTDateEditorUI ui = this._getEWTDateEditorUI();
        Rectangle r = this._getFieldBounds(this._currentField);
        Shape oldClip = g.getClip();
        g.clipRect(r.x, r.y, r.width, r.height);
        Painter painter = ui.getSelectionTextPainter(this);
        this._paintText(g, painter);
        g.setClip(oldClip);
    }

    private void _processKeyPressed(KeyEvent ke) {
        int oldField;
        int newField = oldField = this._currentField;
        int code = ke.getKeyCode();
        if (this.getActualReadingDirection() == 2) {
            if (code == 37) {
                code = 39;
            } else if (code == 39) {
                code = 37;
            }
        }
        switch (code) {
            case 38: {
                if (!this._spinButton.isIncrementEnabled()) break;
                this._spinButton.setIncrementArmed(true);
                this.rollCurrentField(true);
                break;
            }
            case 40: {
                if (!this._spinButton.isDecrementEnabled()) break;
                this._spinButton.setDecrementArmed(true);
                this.rollCurrentField(false);
                break;
            }
            case 37: {
                newField = this.getPreviousField(oldField);
                break;
            }
            case 39: {
                newField = this.getNextField(oldField);
                break;
            }
            default: {
                return;
            }
        }
        if (newField != oldField) {
            this._setCurrentField(newField);
            this.repaint();
        }
        ke.consume();
    }

    private void _processKeyTyped(KeyEvent event) {
        int startPos;
        String temp;
        String newStringValue;
        int newValue;
        char c = event.getKeyChar();
        if (c < '0' || c > '9') {
            return;
        }
        if (this._nullDate) {
            this._resetDate();
            return;
        }
        if (this._currentField == -1) {
            this._setCurrentField(0);
        }
        if (!this._isIntegerField(this._currentField)) {
            return;
        }
        int field = this._fields[this._currentField];
        Calendar cal = this.getCalendar();
        int value = this.getFieldValue(field);
        int min = this.getFieldMinimum(field);
        int max = this.getFieldMaximum(field);
        Integer oldValue = new Integer(value);
        StringBuffer date = new StringBuffer();
        Position position = new Position(this._formatFields[this._currentField]);
        date = this.getFieldPosition(this.getDate(), date, position);
        int fieldSize = this.getPreferredFieldSize(position);
        if (field == 2) {
            if (min == 0) {
                ++min;
                ++max;
                ++value;
            }
        } else if (field == 11) {
            if (this._fieldUsed(9)) {
                if (cal.get(9) == 1 && value >= 12) {
                    value -= 12;
                }
                max = 12;
            } else {
                ++max;
            }
        } else if (field == 1 && fieldSize == 2) {
            min = 0;
        }
        String charString = String.valueOf(c);
        String oldStringValue = IntegerUtils.getString((int)value);
        int oldSize = oldStringValue.length();
        if (oldSize < fieldSize) {
            String s = "";
            int count = fieldSize - oldSize;
            for (int i = 0; i < count; ++i) {
                s = s + "0";
            }
            oldStringValue = s.concat(oldStringValue);
        }
        if ((newValue = this._checkString(newStringValue = (temp = oldStringValue.concat(charString)).substring(startPos = temp.length() - fieldSize), min, max)) == -1 && (newValue = this._checkString(charString, min, max)) == -1) {
            return;
        }
        Date old = this._date;
        this.setFieldValue(field, newValue, fieldSize);
        this._date = cal.getTime();
        this._nullDate = this._date == null;
        this._validateCurrentField = true;
        this.firePropertyChange(PROPERTY_DATE, old, this._date);
        Integer newNumber = new Integer(cal.get(field));
        this._fireAccessibleValue(oldValue, newNumber);
        this.repaint();
        event.consume();
    }

    private void _processKeyReleased(KeyEvent ke) {
        switch (ke.getKeyCode()) {
            case 38: {
                this._spinButton.setIncrementArmed(false);
                break;
            }
            case 40: {
                this._spinButton.setDecrementArmed(false);
                break;
            }
            default: {
                return;
            }
        }
        ke.consume();
    }

    private Date _checkMinMax(Date d, boolean set) {
        if (this._minimum != null && (d.before(this._minimum) || d.equals(this._minimum))) {
            d = this._minimum;
            set = true;
            this._spinButton.setDecrementEnabled(false);
        } else if (!this._spinButton.isDecrementEnabled()) {
            this._spinButton.setDecrementEnabled(true);
        }
        if (this._maximum != null && (d.after(this._maximum) || d.equals(this._maximum))) {
            d = this._maximum;
            set = true;
            this._spinButton.setIncrementEnabled(false);
        } else if (!this._spinButton.isIncrementEnabled()) {
            this._spinButton.setIncrementEnabled(true);
        }
        if (this._minimum != null && this._maximum != null && this._minimum.equals(this._maximum)) {
            d = this._minimum;
            set = true;
            this._spinButton.setDecrementEnabled(false);
            this._spinButton.setIncrementEnabled(false);
        }
        if (set) {
            this._calendar.setTime(d);
        }
        this._validateCurrentField = false;
        return d;
    }

    private int _checkString(String s, int min, int max) {
        int value = -1;
        try {
            value = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return -1;
        }
        if (value < min || value > max) {
            return -1;
        }
        return value;
    }

    private boolean _isIntegerField(int index) {
        StringBuffer sb = new StringBuffer();
        Position p = new Position(this._formatFields[index]);
        sb = this.getFieldPosition(this.getDate(), sb, p);
        String field = sb.toString().substring(p.beginIndex, p.endIndex);
        try {
            int dummy = Integer.parseInt(field);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private void _parseDateFormat() {
        int index = 0;
        SimpleDateFormat sdf = (SimpleDateFormat)this.getDateFormat();
        String pattern = sdf.toPattern();
        StringCharacterIterator iter = new StringCharacterIterator(pattern);
        for (int i = 0; i < this._fields.length; ++i) {
            this._fields[i] = -1;
            this._formatFields[i] = -1;
        }
        boolean year = false;
        boolean month = false;
        boolean day = false;
        boolean hour = false;
        boolean minute = false;
        boolean second = false;
        boolean millisecond = false;
        boolean ampm = false;
        boolean zone = false;
        boolean hour1 = false;
        boolean hour2 = false;
        boolean hour3 = false;
        boolean dayOfWeek = false;
        char c = iter.first();
        while (c != '\uffff') {
            switch (c) {
                case 'a': {
                    if (ampm) break;
                    this._fields[index] = 9;
                    this._formatFields[index] = DateEditor.getConstant(0);
                    ++index;
                    ampm = true;
                    break;
                }
                case 'z': {
                    if (zone) break;
                    this._fields[index] = 15;
                    this._formatFields[index] = DateEditor.getConstant(1);
                    ++index;
                    zone = true;
                    break;
                }
                case 'y': {
                    if (year) break;
                    this._fields[index] = 1;
                    this._formatFields[index] = DateEditor.getConstant(2);
                    ++index;
                    year = true;
                    break;
                }
                case 'M': {
                    if (month) break;
                    this._fields[index] = 2;
                    this._formatFields[index] = DateEditor.getConstant(3);
                    ++index;
                    month = true;
                    break;
                }
                case 'd': {
                    if (day) break;
                    this._fields[index] = 5;
                    this._formatFields[index] = DateEditor.getConstant(4);
                    ++index;
                    day = true;
                    break;
                }
                case 'h': {
                    if (hour) break;
                    this._fields[index] = 10;
                    this._formatFields[index] = DateEditor.getConstant(6);
                    ++index;
                    hour = true;
                    break;
                }
                case 'H': {
                    if (hour1) break;
                    this._fields[index] = 11;
                    this._formatFields[index] = DateEditor.getConstant(5);
                    ++index;
                    hour1 = true;
                    break;
                }
                case 'k': {
                    if (hour2) break;
                    this._fields[index] = 11;
                    this._formatFields[index] = DateEditor.getConstant(10);
                    ++index;
                    hour2 = true;
                    break;
                }
                case 'K': {
                    if (hour3) break;
                    this._fields[index] = 10;
                    this._formatFields[index] = DateEditor.getConstant(11);
                    ++index;
                    hour3 = true;
                    break;
                }
                case 'm': {
                    if (minute) break;
                    this._fields[index] = 12;
                    this._formatFields[index] = DateEditor.getConstant(7);
                    ++index;
                    minute = true;
                    break;
                }
                case 's': {
                    if (second) break;
                    this._fields[index] = 13;
                    this._formatFields[index] = DateEditor.getConstant(8);
                    ++index;
                    second = true;
                    break;
                }
                case 'S': {
                    if (millisecond) break;
                    this._fields[index] = 14;
                    this._formatFields[index] = DateEditor.getConstant(9);
                    ++index;
                    millisecond = true;
                    break;
                }
                case 'E': {
                    if (dayOfWeek) break;
                    this._fields[index] = 7;
                    this._formatFields[index] = DateEditor.getConstant(12);
                    ++index;
                    dayOfWeek = true;
                    break;
                }
                case '\'': {
                    while ((c = iter.next()) != '\'') {
                    }
                    break;
                }
            }
            c = iter.next();
        }
        this._fieldCount = index;
        this._createAccessibleChildren();
    }

    private boolean _fieldUsed(int field) {
        for (int i = 0; i < this._fieldCount; ++i) {
            if (this._fields[i] != field) continue;
            return true;
        }
        return false;
    }

    private void _fireAccessibleName() {
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleName", null, this.getDateString());
        }
    }

    private void _fireAccessibleCurrFieldName() {
        AccessibleContext childAC;
        AccessibleContext ac = this.accessibleContext;
        AccessibleContext accessibleContext = childAC = ac == null ? null : ac.getAccessibleChild(this._currentField).getAccessibleContext();
        if (childAC != null) {
            childAC.firePropertyChange("AccessibleName", null, childAC.getAccessibleName());
        }
    }

    private void _fireAccessibleSelection(int old, int newValue) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleSelection", old == -1 ? Boolean.FALSE : Boolean.TRUE, newValue == -1 ? Boolean.FALSE : Boolean.TRUE);
        }
    }

    private void _fireAccessibleActive(int old, int newValue) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            ac.firePropertyChange("AccessibleActiveDescendant", old == -1 ? null : ac.getAccessibleChild(old), newValue == -1 ? null : ac.getAccessibleChild(newValue));
        }
    }

    private void _fireAccessibleFocus(int oldField, int newField) {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null) {
            if (oldField != -1) {
                ac.getAccessibleChild(oldField).getAccessibleContext().firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
            if (newField != -1) {
                ac.getAccessibleChild(newField).getAccessibleContext().firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }
        }
    }

    private void _fireAccessibleValue(Number oldValue, Number newValue) {
        AccessibleContext ac;
        if (this._currentField != -1 && (ac = this.accessibleContext) != null) {
            ac.getAccessibleChild(this._currentField).getAccessibleContext().firePropertyChange("AccessibleValue", oldValue, newValue);
        }
    }

    private void _createAccessibleChildren() {
        AccessibleContext ac = this.accessibleContext;
        if (ac != null && ac instanceof AccessibleDateEditor) {
            AccessibleDateEditor ade = (AccessibleDateEditor)ac;
            ade.__createChildren();
        }
    }

    private static int getConstant(int index) {
        if (_constantArray == null) {
            SimpleDateFormat f = new SimpleDateFormat("h:mm a");
            Calendar c = Calendar.getInstance();
            FieldPosition pos = new FieldPosition(14);
            StringBuffer b = new StringBuffer();
            f.format(c.getTime(), b, pos);
            _constantArray = pos.getBeginIndex() == 0 ? _CALENDAR_ARRAY : _DATE_FORMAT_ARRAY;
        }
        return _constantArray[index];
    }

    static {
        _DATE_FORMAT_ARRAY = new int[]{14, 17, 1, 2, 3, 5, 15, 6, 7, 8, 4, 16, 9};
        _CALENDAR_ARRAY = new int[]{9, 15, 1, 2, 5, 11, 10, 12, 13, 14, 11, 10, 7};
    }

    private class UIListener
    implements SpinButtonListener {
        private UIListener() {
        }

        public void spinButtonSpinning(SpinButtonEvent e) {
            boolean up;
            boolean isNull = DateEditor.this._nullDate;
            if (!DateEditor.this.hasFocus()) {
                DateEditor.this.requestFocus();
            }
            if (isNull) {
                DateEditor.this._resetDate();
                return;
            }
            switch (e.getType()) {
                case 1: {
                    up = true;
                    break;
                }
                case 2: {
                    up = false;
                    break;
                }
                default: {
                    return;
                }
            }
            DateEditor.this.rollCurrentField(up);
        }
    }

    private class AccessibleDateField
    extends AccessibleContext
    implements Accessible,
    AccessibleAction,
    AccessibleValue,
    AccessibleComponent {
        private int _field;
        private int _index;

        public AccessibleDateField(int field, int index) {
            this._field = field;
            this._index = index;
        }

        public Accessible getAccessibleParent() {
            return DateEditor.this;
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            String name = super.getAccessibleName();
            if (name != null) {
                return name;
            }
            StringBuffer date = new StringBuffer();
            Position position = new Position(DateEditor.this._formatFields[this._index]);
            date = DateEditor.this.getFieldPosition(DateEditor.this.getDate(), date, position);
            date = DateEditor.this._getProperlyFormatedDate(position);
            name = date.toString();
            if (name == null || position.beginIndex == -1 || position.endIndex == -1) {
                return null;
            }
            return name.substring(position.beginIndex, position.endIndex);
        }

        public String getAccessibleDescription() {
            String desc = super.getAccessibleDescription();
            if (desc != null) {
                return desc;
            }
            return DateEditor.getDescription(this._field, LocaleUtils.getDefaultableLocale((Component)DateEditor.this));
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LABEL;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = this.getAccessibleParent().getAccessibleContext().getAccessibleStateSet();
            states.add(AccessibleState.SELECTABLE);
            if (this._field == DateEditor.this._currentField) {
                states.add(AccessibleState.SELECTED);
                if (DateEditor.this.hasFocus()) {
                    states.add(AccessibleState.FOCUSED);
                }
            } else if (states.contains(AccessibleState.FOCUSED)) {
                states.remove(AccessibleState.FOCUSED);
            }
            if (states.contains(AccessibleState.ENABLED)) {
                states.add(AccessibleState.EDITABLE);
            }
            states.add(AccessibleState.SINGLE_LINE);
            return states;
        }

        public int getAccessibleIndexInParent() {
            return this._index;
        }

        public int getAccessibleChildrenCount() {
            return 0;
        }

        public Accessible getAccessibleChild(int i) {
            return null;
        }

        public Locale getLocale() throws IllegalComponentStateException {
            return DateEditor.this.getLocale();
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 2;
        }

        public String getAccessibleActionDescription(int i) {
            Locale l = LocaleUtils.getDefaultableLocale((Component)DateEditor.this);
            ResourceBundle b = ResourceBundle.getBundle(DateEditor._RESOURCE_BUNDLE, l);
            switch (i) {
                case 0: {
                    return b.getString(DateEditor._INCREMENT_KEY);
                }
                case 1: {
                    return b.getString(DateEditor._DECREMENT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            switch (i) {
                case 0: {
                    if (!DateEditor.this._spinButton.isIncrementEnabled()) {
                        return false;
                    }
                    DateEditor.this._setCurrentField(this._index);
                    DateEditor.this.rollCurrentField(true);
                    break;
                }
                case 1: {
                    if (!DateEditor.this._spinButton.isDecrementEnabled()) {
                        return false;
                    }
                    DateEditor.this._setCurrentField(this._index);
                    DateEditor.this.rollCurrentField(false);
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public AccessibleValue getAccessibleValue() {
            if (!DateEditor.this._isIntegerField(this._index)) {
                return null;
            }
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(DateEditor.this.getCalendar().get(this._field));
        }

        public boolean setCurrentAccessibleValue(Number n) {
            DateEditor.this.getCalendar().set(this._field, n.intValue());
            DateEditor.this.repaint();
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(DateEditor.this.getFieldMinimum(this._field));
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(DateEditor.this.getFieldMaximum(this._field));
        }

        public Color getBackground() {
            return DateEditor.this.getBackground();
        }

        public void setBackground(Color c) {
            DateEditor.this.setBackground(c);
        }

        public Color getForeground() {
            return DateEditor.this.getForeground();
        }

        public void setForeground(Color c) {
            DateEditor.this.setForeground(c);
        }

        public Cursor getCursor() {
            return DateEditor.this.getCursor();
        }

        public void setCursor(Cursor cursor) {
            DateEditor.this.setCursor(cursor);
        }

        public Font getFont() {
            return DateEditor.this.getFont();
        }

        public void setFont(Font f) {
            DateEditor.this.setFont(f);
        }

        public FontMetrics getFontMetrics(Font f) {
            return DateEditor.this.getFontMetrics(f);
        }

        public boolean isEnabled() {
            return DateEditor.this.isEnabled();
        }

        public void setEnabled(boolean b) {
            DateEditor.this.setEnabled(b);
        }

        public boolean isVisible() {
            return DateEditor.this.isVisible();
        }

        public void setVisible(boolean b) {
            DateEditor.this.setVisible(b);
        }

        public boolean isShowing() {
            return DateEditor.this.isShowing();
        }

        public boolean contains(Point p) {
            return this.getBounds().contains(p);
        }

        public Point getLocationOnScreen() {
            Point p = DateEditor.this.getLocationOnScreen();
            if (p != null) {
                Point temp = this.getLocation();
                p.x += temp.x;
                p.y += temp.y;
            }
            return p;
        }

        public Point getLocation() {
            Rectangle r = this.getFieldBounds();
            return r.getLocation();
        }

        public void setLocation(Point p) {
        }

        public Rectangle getBounds() {
            return this.getFieldBounds();
        }

        public void setBounds(Rectangle r) {
        }

        public Dimension getSize() {
            Rectangle r = this.getFieldBounds();
            return r.getSize();
        }

        public void setSize(Dimension d) {
        }

        public Accessible getAccessibleAt(Point p) {
            return null;
        }

        public boolean isFocusTraversable() {
            return DateEditor.this.isFocusTraversable();
        }

        public void requestFocus() {
            DateEditor.this._setCurrentField(this._index);
        }

        public void addFocusListener(FocusListener l) {
            DateEditor.this.addFocusListener(l);
        }

        public void removeFocusListener(FocusListener l) {
            DateEditor.this.removeFocusListener(l);
        }

        private Rectangle getFieldBounds() {
            ImmInsets insets = DateEditor.this.getBorderInsets();
            Rectangle r = DateEditor.this._getFieldBounds(this._index);
            r.width += insets.left + insets.right;
            r.height += insets.top + insets.bottom;
            return r;
        }
    }

    protected class AccessibleDateEditor
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    AccessibleAction {
        private Accessible[] _children;

        public AccessibleDateEditor() {
            super(DateEditor.this);
            this.__createChildren();
        }

        public AccessibleRole getAccessibleRole() {
            return OracleAccessibleRole.DATE_EDITOR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (DateEditor.this.hasFocus()) {
                states.add(AccessibleState.FOCUSED);
            }
            if (states.contains(AccessibleState.ENABLED)) {
                states.add(AccessibleState.EDITABLE);
            }
            states.add(AccessibleState.SINGLE_LINE);
            return states;
        }

        public int getAccessibleChildrenCount() {
            return DateEditor.this._fieldCount;
        }

        public Accessible getAccessibleChild(int i) {
            if (i < 0 || i >= this.getAccessibleChildrenCount()) {
                return null;
            }
            return this._children[i];
        }

        public int getAccessibleSelectionCount() {
            return DateEditor.this._currentField == -1 ? 0 : 1;
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleSelection(int i) {
            if (i < 0 || i >= this.getAccessibleSelectionCount()) {
                return null;
            }
            return this._children[DateEditor.this._currentField];
        }

        public boolean isAccessibleChildSelected(int i) {
            return DateEditor.this._currentField == i;
        }

        public void addAccessibleSelection(int i) {
            DateEditor.this._setCurrentField(i);
        }

        public void removeAccessibleSelection(int i) {
            if (DateEditor.this._currentField == i) {
                DateEditor.this._setCurrentField(-1);
            }
        }

        public void clearAccessibleSelection() {
            DateEditor.this._setCurrentField(-1);
        }

        public void selectAllAccessibleSelection() {
        }

        public AccessibleAction getAccessibleAction() {
            return this;
        }

        public int getAccessibleActionCount() {
            return 4;
        }

        public String getAccessibleActionDescription(int i) {
            Locale l = LocaleUtils.getDefaultableLocale((Component)DateEditor.this);
            ResourceBundle b = ResourceBundle.getBundle(DateEditor._RESOURCE_BUNDLE, l);
            switch (i) {
                case 0: {
                    return b.getString(DateEditor._INCREMENT_KEY);
                }
                case 1: {
                    return b.getString(DateEditor._DECREMENT_KEY);
                }
                case 2: {
                    return b.getString(DateEditor._LEFT_KEY);
                }
                case 3: {
                    return b.getString(DateEditor._RIGHT_KEY);
                }
            }
            return null;
        }

        public boolean doAccessibleAction(int i) {
            switch (i) {
                case 0: {
                    if (!DateEditor.this._spinButton.isIncrementEnabled()) {
                        return false;
                    }
                    DateEditor.this.rollCurrentField(true);
                    break;
                }
                case 1: {
                    if (!DateEditor.this._spinButton.isDecrementEnabled()) {
                        return false;
                    }
                    DateEditor.this.rollCurrentField(false);
                    break;
                }
                case 2: {
                    DateEditor.this._setCurrentField(DateEditor.this.getPreviousField(DateEditor.this._currentField));
                    break;
                }
                case 3: {
                    DateEditor.this._setCurrentField(DateEditor.this.getNextField(DateEditor.this._currentField));
                    break;
                }
                default: {
                    return false;
                }
            }
            return true;
        }

        void __createChildren() {
            Accessible[] children = this._children;
            if (children != null && children.length != 0) {
                for (int i = 0; i < children.length; ++i) {
                    this.firePropertyChange("AccessibleChild", this._children[i], null);
                }
            }
            int count = DateEditor.this._fieldCount;
            this._children = new Accessible[count];
            for (int i = 0; i < count; ++i) {
                this._children[i] = new AccessibleDateField(DateEditor.this._fields[i], i);
                this.firePropertyChange("AccessibleChild", null, this._children[i]);
            }
        }
    }

    public class Position {
        public int field;
        public int beginIndex;
        public int endIndex;

        public Position(int field) {
            this.field = field;
        }
    }
}

