/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet.taglib.rt;

import java.text.ParseException;
import java.util.TimeZone;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.BodyTagSupport;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.servlet.taglib.rt.TagUtility;
import oracle.i18n.text.OraDateFormat;
import oracle.i18n.text.OraSimpleDateFormat;
import oracle.i18n.util.GDKMessage;

public class ParseDateTag
extends BodyTagSupport {
    private String m_value = null;
    private String m_type = "";
    private int m_dateStyle = 3;
    private String m_pattern = null;
    private TimeZone m_timezone = null;
    private String m_var = null;
    private int m_scope = -1;

    public void setValue(String string) {
        this.m_value = string;
    }

    public void setType(String string) {
        this.m_type = string;
    }

    public void setDateStyle(String string) {
        this.m_dateStyle = TagUtility.getDateFormatStyle(string);
    }

    public void setPattern(String string) {
        this.m_pattern = string;
    }

    public void setTimezone(String string) {
        this.m_timezone = TimeZone.getTimeZone(string);
    }

    public void setTimezone(TimeZone timeZone) {
        this.m_timezone = timeZone;
    }

    public void setVar(String string) {
        this.m_var = string;
    }

    public void setScope(String string) {
        this.m_scope = TagUtility.getScope(string);
    }

    public int doStartTag() throws JspException {
        if (this.m_scope != -1 && this.m_var == null) {
            throw new JspException(GDKMessage.getMessage(5216));
        }
        if (this.m_timezone == null) {
            this.m_timezone = (TimeZone)this.pageContext.getAttribute("oracle.i18n.servlet.taglib.timezone");
        }
        if (this.m_value != null) {
            if (!this.m_value.equals("")) {
                try {
                    TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getDateFormat().parse(this.m_value));
                }
                catch (ParseException parseException) {
                    throw new JspException(parseException.getMessage());
                }
            } else {
                TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
            }
            return 0;
        }
        return 2;
    }

    public int doAfterBody() throws JspException {
        this.m_value = this.getBodyContent().getString();
        if (this.m_value != null && !this.m_value.equals("")) {
            try {
                TagUtility.output(this.m_var, this.m_scope, this.pageContext, this.getDateFormat().parse(this.m_value));
            }
            catch (ParseException parseException) {
                throw new JspException(parseException.getMessage());
            }
        } else {
            TagUtility.removeValue(this.m_var, this.m_scope, this.pageContext);
        }
        return 0;
    }

    private OraDateFormat getDateFormat() throws JspException {
        LocaleSource localeSource = (LocaleSource)this.pageContext.findAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
        try {
            if (this.m_pattern != null && !this.m_pattern.equals("")) {
                OraSimpleDateFormat oraSimpleDateFormat = new OraSimpleDateFormat(this.m_pattern, localeSource.getLocale());
                if (this.m_timezone == null) {
                    return oraSimpleDateFormat;
                }
                oraSimpleDateFormat.setTimeZone(this.m_timezone);
                return oraSimpleDateFormat;
            }
            if (this.m_type.equals("time")) {
                if (this.m_timezone == null) {
                    return localeSource.getTimeFormat();
                }
                OraDateFormat oraDateFormat = (OraDateFormat)localeSource.getTimeFormat().clone();
                oraDateFormat.setTimeZone(this.m_timezone);
                return oraDateFormat;
            }
            if (this.m_type.equals("both")) {
                if (this.m_timezone == null) {
                    return localeSource.getDateTimeFormat(this.m_dateStyle);
                }
                OraDateFormat oraDateFormat = (OraDateFormat)localeSource.getDateTimeFormat(this.m_dateStyle).clone();
                oraDateFormat.setTimeZone(this.m_timezone);
                return oraDateFormat;
            }
            if (this.m_timezone == null) {
                return localeSource.getDateFormat(this.m_dateStyle);
            }
            OraDateFormat oraDateFormat = (OraDateFormat)localeSource.getDateFormat(this.m_dateStyle).clone();
            oraDateFormat.setTimeZone(this.m_timezone);
            return oraDateFormat;
        }
        catch (ParseException parseException) {
            throw new JspException(parseException.getMessage());
        }
    }

    public void release() {
        this.m_value = null;
        this.m_type = "";
        this.m_dateStyle = 3;
        this.m_pattern = null;
        this.m_timezone = null;
        this.m_var = null;
        this.m_scope = -1;
    }
}

