/*
 * Decompiled with CFR 0.152.
 */
package oracle.i18n.servlet;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import oracle.i18n.servlet.ApplicationContext;
import oracle.i18n.servlet.Localizer;
import oracle.i18n.servlet.filter.ServletRequestWrapper;
import oracle.i18n.servlet.localesource.LocaleSource;
import oracle.i18n.util.GDKMessage;

public class ServletHelper {
    private static final String M_C_USER_AGENT = "User-Agent";
    private static final Pattern m_matchAbsUrl;

    private ServletHelper() {
    }

    public static ApplicationContext getApplicationContextInstance(HttpServletRequest httpServletRequest) {
        ApplicationContext applicationContext = (ApplicationContext)httpServletRequest.getSession().getServletContext().getAttribute("oracle.i18n.servlet.ApplicationContext.contextkey");
        if (applicationContext != null) {
            return applicationContext;
        }
        try {
            ApplicationContext applicationContext2 = new ApplicationContext(httpServletRequest.getSession().getServletContext().getResourceAsStream("/WEB-INF/gdkapp.xml"));
            httpServletRequest.getSession().getServletContext().setAttribute("oracle.i18n.servlet.ApplicationContext.contextkey", (Object)applicationContext2);
            return applicationContext2;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("Class not found:" + classNotFoundException.getMessage());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException("Unsupported encoding" + unsupportedEncodingException.getMessage());
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException("Invalid regular expression" + patternSyntaxException.getMessage());
        }
    }

    public static LocaleSource getLocaleSourceInstance(HttpServletRequest httpServletRequest) {
        return (LocaleSource)httpServletRequest.getSession().getAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
    }

    public static Localizer getLocalizerInstance(HttpServletRequest httpServletRequest) {
        return new Localizer(ServletHelper.getLocaleSourceInstance(httpServletRequest), ServletHelper.getApplicationContextInstance(httpServletRequest), httpServletRequest.getHeader(M_C_USER_AGENT));
    }

    public static String rewriteURL(String string, HttpServletRequest httpServletRequest) {
        return ServletHelper.rewriteURL(string, "default", httpServletRequest);
    }

    public static String rewriteURL(String string, String string2, HttpServletRequest httpServletRequest) {
        int n;
        Object object;
        ServletContext servletContext = httpServletRequest.getSession().getServletContext();
        String string3 = httpServletRequest.getContextPath().endsWith("/") ? httpServletRequest.getContextPath() : httpServletRequest.getContextPath() + "/";
        ApplicationContext applicationContext = ServletHelper.getApplicationContextInstance(httpServletRequest);
        Object[] objectArray = applicationContext.getRewritingRule(string2);
        if (objectArray == null) {
            throw new IllegalArgumentException(GDKMessage.getMessage(5209, (Object)string2));
        }
        if (!m_matchAbsUrl.matcher(string).find() && (object = httpServletRequest.getServletPath()) != null && (n = ((String)object).lastIndexOf(47)) > 0) {
            string = ((String)object).substring(0, n + 1) + string;
        }
        object = applicationContext.getApplicationDefaultLocaleSource().getLocale();
        Locale locale = httpServletRequest.getLocale();
        Pattern pattern = (Pattern)objectArray[0];
        ApplicationContext.RewriteURLVariable[] rewriteURLVariableArray = (ApplicationContext.RewriteURLVariable[])objectArray[1];
        boolean bl = (Boolean)objectArray[2];
        Matcher matcher = pattern.matcher(string);
        if (!matcher.find()) {
            return string3 + string;
        }
        for (int i = 0; i < 10; ++i) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int j = 0; j < rewriteURLVariableArray.length; ++j) {
                stringBuffer.append(rewriteURLVariableArray[j].getResult(matcher, locale));
            }
            String string4 = stringBuffer.toString();
            if (!bl || m_matchAbsUrl.matcher(string4).find()) {
                return string3 + string4;
            }
            if (servletContext.getResourceAsStream("/" + string4) != null) {
                return string3 + string4;
            }
            String string5 = locale.getLanguage();
            String string6 = locale.getCountry();
            String string7 = locale.getVariant();
            if (!"".equals(string7)) {
                locale = new Locale(string5, string6);
                continue;
            }
            if (!"".equals(string6)) {
                if ("zh".equals(string5)) {
                    if ("MO".equals(string6) || "HK".equals(string6)) {
                        locale = new Locale("zh", "TW");
                        continue;
                    }
                    if (!"CN".equals(string6)) {
                        locale = new Locale("zh", "CN");
                        continue;
                    }
                    locale = new Locale("zh", "");
                    continue;
                }
                locale = new Locale(string5, "");
                continue;
            }
            if (i != 0 || !"zh".equals(string5)) break;
            locale = new Locale("zh", "CN");
        }
        return string3 + string;
    }

    public static void refreshLocales(HttpServletRequest httpServletRequest) {
        if (!(httpServletRequest instanceof ServletRequestWrapper)) {
            return;
        }
        ServletRequestWrapper servletRequestWrapper = (ServletRequestWrapper)httpServletRequest;
        servletRequestWrapper.refresh();
        try {
            Class<?> clazz = Class.forName("org.apache.struts.action.Action", true, Thread.currentThread().getContextClassLoader());
            Field field = clazz.getField("LOCALE_KEY");
            if (field != null) {
                String string = (String)field.get(null);
                LocaleSource localeSource = (LocaleSource)httpServletRequest.getSession().getAttribute("oracle.i18n.servlet.localesource.LocaleSource.sessionkey");
                httpServletRequest.getSession().setAttribute(string, (Object)localeSource.getLocale());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            m_matchAbsUrl = Pattern.compile("^(http|https|ftp)://");
        }
        catch (PatternSyntaxException patternSyntaxException) {
            throw new IllegalArgumentException(patternSyntaxException.getMessage());
        }
    }
}

