/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.runner;

import java.util.EventObject;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JTree;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.explorer.TNode;
import oracle.ide.help.HelpInfo;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.runner.RunProcess;
import oracle.ideimpl.resource.RunMgrArb;
import oracle.ideimpl.runner.RunManager;
import oracle.ideri.navigator.DefaultNavigatorWindow;

public final class RunManagerWindow
extends DefaultNavigatorWindow {
    private RunManager runManager;
    static final String RUN_MANAGER_WINDOW_ID = "RunManagerWindow";
    private static Icon runManagerTabIcon = null;

    RunManagerWindow(Context context, RunManager runManager) {
        super(context, RUN_MANAGER_WINDOW_ID);
        this.runManager = runManager;
        this.setTitle(RunMgrArb.getString((int)5));
        this.getGUI();
    }

    private void setProjectInContext(Context context) {
        Element[] sel = context.getSelection();
        Element e = sel != null && sel.length > 0 ? sel[sel.length - 1] : null;
        if (e instanceof RunProcess) {
            RunProcess runProcess = (RunProcess)e;
            Context runProcessContext = runProcess.getContext();
            Workspace workspace = runProcessContext.getWorkspace();
            Project project = runProcessContext.getProject();
            Workspaces workspaces = Ide.getWorkspaces();
            List list = workspaces.getListOfChildren();
            if (list != null && list.contains(workspace)) {
                context.setWorkspace(workspace);
                if (workspace.containsChild((Element)project)) {
                    context.setProject(project);
                }
            }
        } else {
            context.setWorkspace(Ide.getActiveWorkspace());
            context.setProject(Ide.getActiveProject());
        }
    }

    public HelpInfo getHelpInfo() {
        return new HelpInfo("f1_runmanagerwindow_html");
    }

    public Context getContext(EventObject event) {
        Context c = super.getContext(event);
        this.setProjectInContext(c);
        return c;
    }

    public Icon getTabIcon() {
        if (runManagerTabIcon == null) {
            runManagerTabIcon = RunMgrArb.getIcon((int)4);
        }
        return runManagerTabIcon;
    }

    protected boolean coalesceTreeExplorerUpdates() {
        return false;
    }

    boolean selectProcess(RunProcess runProcess) {
        TNode processesTNode = this.findProcessesTNode();
        for (int i = processesTNode.getChildCount() - 1; i >= 0; --i) {
            TNode tnode = (TNode)processesTNode.getChildAt(i);
            if (tnode.getData() != runProcess) continue;
            this.setSelected(tnode);
            return true;
        }
        return false;
    }

    private TNode findProcessesTNode() {
        JTree tree = this.getTree();
        TNode rootTNode = (TNode)tree.getModel().getRoot();
        Element data = rootTNode.getData();
        if (data == this.runManager) {
            Folder processes = RunManager.runner.getProcessesFolder();
            for (int i = rootTNode.getChildCount() - 1; i >= 0; --i) {
                TNode tnode = (TNode)rootTNode.getChildAt(i);
                if (tnode.getData() != processes) continue;
                return tnode;
            }
        }
        return null;
    }
}

