/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import oracle.xml.parser.schema.XMLSchema;
import oracle.xml.parser.schema.XSDBuilder;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.sql.dml.OracleXMLSave;
import oracle.xml.transx.ConnectionHelper;
import oracle.xml.transx.DLFValidator;
import oracle.xml.transx.DefaultDoc;
import oracle.xml.transx.DuplicateException;
import oracle.xml.transx.Options;
import oracle.xml.transx.TransX;
import oracle.xml.transx.TxuErrMsg;
import oracle.xml.transx.Unloader;
import oracle.xml.transx.XMLEntityResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;

class TransXImpl
implements TransX {
    XMLSchema m_schema;
    String m_tablename;
    String m_temp_tablename;
    Connection m_con = null;
    DefaultDoc m_doc;
    String m_datasrc;
    Options m_options;

    public TransXImpl() {
        this.m_options = new Options();
    }

    public TransXImpl(Options options) {
        this.m_options = options;
    }

    public void open(String string, String string2, String string3) throws SQLException {
        if (this.m_con == null) {
            this.m_con = ConnectionHelper.getConnection(string, string2, string3);
        }
    }

    public void open(Connection connection) {
        if (this.m_con == null) {
            this.m_con = connection;
        }
    }

    public void close() throws SQLException {
        if (this.m_con != null) {
            this.m_con.close();
            this.m_con = null;
        }
    }

    public Reader unload(String string, String[] stringArray) throws Exception {
        if (string == null) {
            String string2 = TxuErrMsg.getMessage(306);
            throw new IllegalArgumentException(string2);
        }
        if (this.m_con == null) {
            String string3 = TxuErrMsg.getMessage(305, "unload", string);
            throw new RuntimeException(string3);
        }
        Unloader unloader = new Unloader(this.m_con);
        unloader.setQuery(string, stringArray);
        unloader.unload();
        return unloader.getReader();
    }

    public void unload(String string, String[] stringArray, Writer writer) throws Exception {
        if (string == null) {
            String string2 = TxuErrMsg.getMessage(306);
            throw new IllegalArgumentException(string2);
        }
        if (this.m_con == null) {
            String string3 = TxuErrMsg.getMessage(305, "unload", string);
            throw new RuntimeException(string3);
        }
        Unloader unloader = new Unloader(this.m_con);
        unloader.setQuery(string, stringArray);
        unloader.unload();
        unloader.writeTo(writer);
        writer.flush();
    }

    public int load(String string) throws Exception {
        return this.load2(string, null);
    }

    public int load2(String string, String string2) throws Exception {
        if (this.m_con == null) {
            String string3 = TxuErrMsg.getMessage(305, "load", string);
            throw new RuntimeException(string3);
        }
        this.m_temp_tablename = string2;
        return this.load(string, null);
    }

    public int load(InputStream inputStream) throws Exception {
        if (this.m_con == null) {
            String string = TxuErrMsg.getMessage(305, "load", "InputStream");
            throw new RuntimeException(string);
        }
        boolean bl = this.m_options.get(5);
        XMLDocument xMLDocument = this.parse(inputStream, bl);
        return this.load(xMLDocument, bl);
    }

    public int load(Reader reader) throws Exception {
        if (this.m_con == null) {
            String string = TxuErrMsg.getMessage(305, "load", "ReaderInputStream");
            throw new RuntimeException(string);
        }
        boolean bl = this.m_options.get(5);
        XMLDocument xMLDocument = this.parse(reader, bl);
        return this.load(xMLDocument, bl);
    }

    public int load(String string, URL uRL) throws Exception {
        boolean bl;
        XMLDocument xMLDocument;
        block4: {
            xMLDocument = null;
            bl = this.m_options.get(5);
            try {
                if (string != null) {
                    xMLDocument = this.parse(string, bl);
                    break block4;
                }
                if (uRL != null) {
                    xMLDocument = this.parse(uRL, bl);
                    break block4;
                }
                throw new RuntimeException("Datasource not found.");
            }
            catch (XMLParseException xMLParseException) {
                throw new RuntimeException(this.formatParseError(xMLParseException));
            }
        }
        return this.load(xMLDocument, bl);
    }

    int load(XMLDocument xMLDocument, boolean bl) throws Exception {
        boolean bl2;
        DefaultDoc defaultDoc;
        block10: {
            String string;
            NodeList nodeList;
            Node node = xMLDocument.selectSingleNode("/table[@space=\"preserve\"]");
            if (node != null) {
                this.m_options.set(5, true);
                bl = true;
            }
            if ((nodeList = xMLDocument.selectNodes(string = "/table/dataset/row")).getLength() == 0) {
                return 0;
            }
            defaultDoc = new DefaultDoc(xMLDocument);
            if (this.m_options.get(2)) {
                defaultDoc.printSourceDoc(System.out);
            }
            int n = this.m_options.getLangTagStyle();
            defaultDoc.doLanguage(n);
            defaultDoc.transform(bl);
            defaultDoc.doConstant();
            defaultDoc.doQuery(this.m_con, bl);
            bl2 = this.m_options.getLoadingMode() == 1;
            boolean bl3 = this.m_options.getLoadingMode() == 2;
            try {
                if (this.m_temp_tablename == null) {
                    defaultDoc.evaluateDuplicates(this.m_con, bl3);
                }
            }
            catch (DuplicateException duplicateException) {
                if (!bl3) break block10;
                throw duplicateException;
            }
        }
        defaultDoc.doSequence(this.m_con, (XMLDocument)defaultDoc.getInsertDoc());
        if (bl2) {
            defaultDoc.doSequence(this.m_con, (XMLDocument)defaultDoc.getUpdateDoc());
        }
        if (this.m_options.get(0)) {
            defaultDoc.printInsertDoc(System.out);
        }
        if (this.m_options.get(1)) {
            defaultDoc.printUpdateDoc(System.out);
        }
        int n = 0;
        n += this.insert(defaultDoc.getInsertDoc());
        if (bl2) {
            n += this.update(defaultDoc.getUpdateDoc(), defaultDoc.getKeyColumns(), defaultDoc.getUpdateColumns());
        }
        return n;
    }

    public int load(URL uRL) throws Exception {
        if (this.m_con == null) {
            String string = TxuErrMsg.getMessage(305, "load", uRL.toString());
            throw new RuntimeException(string);
        }
        return this.load(null, uRL);
    }

    public void setPreserveWhitespace(boolean bl) {
        this.m_options.set(5, bl);
    }

    public void setLoadingMode(int n) {
        this.m_options.setLoadingMode(n);
    }

    public void setNormalizeLangTag(int n) {
        this.m_options.setLangTagStyle(n);
    }

    public void setValidationMode(boolean bl) {
        this.m_options.set(3, bl);
    }

    public void transform() throws XSLException, SQLException {
    }

    int insert(Document document) {
        if (document == null || !this.hasXSURows(document)) {
            return 0;
        }
        OracleXMLSave oracleXMLSave = new OracleXMLSave(this.m_con, this.m_tablename);
        oracleXMLSave.setDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss");
        oracleXMLSave.setIgnoreCase(true);
        int n = 0;
        n = oracleXMLSave.insertXML(document);
        oracleXMLSave.close();
        return n;
    }

    int update(Document document, String[] stringArray, String[] stringArray2) {
        if (document == null || !this.hasXSURows(document) || stringArray2.length == 0) {
            return 0;
        }
        OracleXMLSave oracleXMLSave = new OracleXMLSave(this.m_con, this.m_tablename);
        oracleXMLSave.setDateFormat("yyyy'-'MM'-'dd'T'HH:mm:ss");
        oracleXMLSave.setIgnoreCase(true);
        int n = 0;
        oracleXMLSave.setKeyColumnList(stringArray);
        oracleXMLSave.setUpdateColumnList(stringArray2);
        n = oracleXMLSave.updateXML(document);
        oracleXMLSave.close();
        return n;
    }

    public boolean validate(String string) throws Exception {
        File file = new File(string);
        if (!file.canRead()) {
            String string2 = TxuErrMsg.getMessage(301, string);
            throw new RuntimeException(string2);
        }
        this.setSchema();
        return this.parse(file) != null;
    }

    public boolean validate(URL uRL) throws Exception {
        this.setSchema();
        return this.parse(uRL) != null;
    }

    InputStream getArchiveEntry(String string, String string2) throws Exception {
        ZipFile zipFile = new ZipFile(string);
        if (zipFile == null) {
            String string3 = TxuErrMsg.getMessage(302, string);
            throw new RuntimeException(string3);
        }
        ZipEntry zipEntry = zipFile.getEntry(string2);
        if (zipEntry == null) {
            return null;
        }
        InputStream inputStream = zipFile.getInputStream(zipEntry);
        return inputStream;
    }

    void setSchema() {
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        File file = new File("../src/oracle/xml/transx/dlf.xsd");
        if (file.canRead()) {
            try {
                inputStream = new FileInputStream(file);
            }
            catch (Exception exception) {
                String string = TxuErrMsg.getMessage(404, exception.getMessage());
                throw new RuntimeException(string);
            }
            return;
        }
        String string = "transx.zip";
        String string2 = TransXImpl.getArchivePath(string);
        if (string2 == null) {
            String string3 = TxuErrMsg.getMessage(304, string);
            throw new RuntimeException(string3);
        }
        if (inputStream == null) {
            try {
                inputStream = this.getArchiveEntry(string2, "oracle/xml/transx/dlf.xsd");
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                String string4 = TxuErrMsg.getMessage(404, exception.getMessage());
                throw new RuntimeException(string4);
            }
            if (inputStream == null) {
                String string5 = TxuErrMsg.getMessage(303, "oracle/xml/transx/dlf.xsd", string2);
                throw new RuntimeException(string5);
            }
        }
        try {
            inputStream2 = this.getArchiveEntry(string2, "oracle/xml/transx/xml.xsd");
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string6 = TxuErrMsg.getMessage(404, exception.getMessage());
            throw new RuntimeException(string6);
        }
        if (inputStream2 == null) {
            String string7 = TxuErrMsg.getMessage(303, "oracle/xml/transx/xml.xsd", string2);
            throw new RuntimeException(string7);
        }
        XMLEntityResolver xMLEntityResolver = new XMLEntityResolver(inputStream2);
        try {
            this.setSchema(inputStream, xMLEntityResolver);
        }
        catch (Exception exception) {
            String string8 = TxuErrMsg.getMessage(404, exception.getMessage());
            throw new RuntimeException(string8);
        }
    }

    static String getArchivePath(String string) {
        String string2 = System.getProperty("java.class.path");
        String string3 = System.getProperty("path.separator");
        StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!string4.endsWith(string)) continue;
            return string4;
        }
        return null;
    }

    void setSchema(InputStream inputStream, EntityResolver entityResolver) throws Exception {
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        XSDBuilder xSDBuilder = new XSDBuilder();
        xSDBuilder.setEntityResolver(entityResolver);
        URL uRL = new URL("http://www.oracle.com/xml/transx/dlf");
        this.m_schema = xSDBuilder.build((InputStream)bufferedInputStream, uRL);
    }

    XMLDocument parse(String string) throws Exception {
        File file = new File(string);
        return this.parse(file);
    }

    XMLDocument parse(String string, boolean bl) throws Exception {
        File file = new File(string);
        return this.parse(file, bl);
    }

    XMLDocument parse(URL uRL) throws Exception {
        return this.parse(uRL, false);
    }

    XMLDocument parse(URL uRL, boolean bl) throws Exception {
        if (this.m_doc != null) {
            String string = TxuErrMsg.getMessage(403, "parsing twice");
            throw new RuntimeException(string);
        }
        URLConnection uRLConnection = uRL.openConnection();
        this.m_datasrc = uRL.toString();
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(bl);
        XMLDocument xMLDocument = null;
        InputStream inputStream = uRLConnection.getInputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
        if (this.m_options.get(3) || this.m_options.get(4)) {
            this.setSchema();
            dOMParser.setValidationMode(3);
            dOMParser.setXMLSchema((Object)this.m_schema);
        } else {
            dOMParser.setValidationMode(0);
        }
        dOMParser.parse((InputStream)bufferedInputStream);
        xMLDocument = dOMParser.getDocument();
        Element element = (Element)xMLDocument.selectSingleNode("/table");
        this.m_tablename = this.m_temp_tablename != null ? this.m_temp_tablename : element.getAttribute("name");
        return xMLDocument;
    }

    XMLDocument parse(File file) throws Exception {
        return this.parse(file, false);
    }

    XMLDocument parse(File file, boolean bl) throws Exception {
        this.m_datasrc = file.getAbsolutePath();
        if (!file.canRead()) {
            String string = "File \"" + this.m_datasrc + "\" could not be read.";
            throw new RuntimeException(string);
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return this.parse(bufferedInputStream, bl);
    }

    XMLDocument parse(InputStream inputStream, boolean bl) throws Exception {
        if (this.m_doc != null) {
            String string = TxuErrMsg.getMessage(403, "parsing twice");
            throw new RuntimeException(string);
        }
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(bl);
        XMLDocument xMLDocument = null;
        if (this.m_options.get(3) || this.m_options.get(4)) {
            this.setSchema();
            dOMParser.setValidationMode(3);
            dOMParser.setXMLSchema((Object)this.m_schema);
        } else {
            dOMParser.setValidationMode(0);
        }
        dOMParser.parse(inputStream);
        xMLDocument = dOMParser.getDocument();
        Element element = (Element)xMLDocument.selectSingleNode("/table");
        this.m_tablename = this.m_temp_tablename != null ? this.m_temp_tablename : element.getAttribute("name");
        DLFValidator dLFValidator = new DLFValidator(xMLDocument);
        dLFValidator.validate();
        return xMLDocument;
    }

    XMLDocument parse(Reader reader, boolean bl) throws Exception {
        if (this.m_doc != null) {
            String string = TxuErrMsg.getMessage(403, "parsing twice");
            throw new RuntimeException(string);
        }
        DOMParser dOMParser = new DOMParser();
        dOMParser.setPreserveWhitespace(bl);
        XMLDocument xMLDocument = null;
        if (this.m_options.get(3) || this.m_options.get(4)) {
            this.setSchema();
            dOMParser.setValidationMode(3);
            dOMParser.setXMLSchema((Object)this.m_schema);
        } else {
            dOMParser.setValidationMode(0);
        }
        dOMParser.parse(reader);
        xMLDocument = dOMParser.getDocument();
        Element element = (Element)xMLDocument.selectSingleNode("/table");
        this.m_tablename = element.getAttribute("name");
        DLFValidator dLFValidator = new DLFValidator(xMLDocument);
        dLFValidator.validate();
        return xMLDocument;
    }

    static String removeReadabilityWhitespace(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block4: for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': 
                case '\r': {
                    if (!bl) continue block4;
                    stringBuffer.append(' ');
                    bl = false;
                    continue block4;
                }
                case '\t': 
                case ' ': {
                    if (!bl) continue block4;
                    stringBuffer.append(c);
                    bl = false;
                    continue block4;
                }
                default: {
                    stringBuffer.append(c);
                    bl = true;
                }
            }
        }
        return stringBuffer.toString();
    }

    private String formatParseError(XMLParseException xMLParseException) {
        String string = xMLParseException.getSystemId();
        String string2 = new Integer(xMLParseException.getLineNumber()).toString();
        String string3 = new Integer(xMLParseException.getColumnNumber()).toString();
        String string4 = xMLParseException.getMessage();
        if (string == null) {
            string = this.m_datasrc;
        }
        String string5 = TxuErrMsg.getMessage(114, string4, string2, string3, string);
        return string5;
    }

    private boolean hasXSURows(Document document) {
        Node node = null;
        try {
            node = ((XMLNode)document).selectSingleNode("/rowset/row/*");
        }
        catch (XSLException xSLException) {
            String string = TxuErrMsg.getMessage(404, xSLException.getMessage());
            throw new RuntimeException(string);
        }
        return node != null;
    }
}

