/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.jaxb;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import oracle.xml.jaxb.JaxbDatatypeConverter;
import oracle.xml.jaxb.JaxbListImpl;
import oracle.xml.jaxb.JaxbUtil;
import oracle.xml.parser.schema.XSDTypeConstants;
import oracle.xml.parser.v2.XMLAttr;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XMLPrintDriver;
import oracle.xml.parser.v2.XMLText;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.ContentHandler;

public class JaxbNode
implements XSDTypeConstants,
Externalizable {
    XMLElement theElement;
    Object[] nodeArray = null;
    boolean inUse = false;
    String constr_name = null;
    String constr_namespace = null;
    XMLDocument constr_ownerDoc = null;

    protected JaxbNode() {
        this.initNodeArray();
    }

    protected JaxbNode(String string, String string2, XMLDocument xMLDocument) {
        this.constr_name = string;
        this.constr_namespace = string2;
        this.constr_ownerDoc = xMLDocument;
        this.initNodeArray();
    }

    protected JaxbNode(XMLElement xMLElement) {
        this.theElement = xMLElement;
        this.initNodeArray();
        this.populateNodeArray((XMLNode)xMLElement);
    }

    private void initNodeArray() {
        Object[] objectArray = this.getSchemaObject();
        this.nodeArray = new Object[objectArray.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLDocument getOwnerDocument() {
        if (this.theElement == null) {
            XMLDocument xMLDocument = this.constr_ownerDoc;
            synchronized (xMLDocument) {
                if (this.theElement == null) {
                    this.theElement = (XMLElement)this.constr_ownerDoc.createElementNS(this.constr_namespace, this.constr_name);
                }
            }
            this.constr_name = null;
            this.constr_namespace = null;
            this.constr_ownerDoc = null;
        }
        return (XMLDocument)this.theElement.getOwnerDocument();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLElement getDOMNode() {
        if (this.theElement == null) {
            XMLDocument xMLDocument = this.constr_ownerDoc;
            synchronized (xMLDocument) {
                if (this.theElement == null) {
                    this.theElement = (XMLElement)this.constr_ownerDoc.createElementNS(this.constr_namespace, this.constr_name);
                }
            }
            this.constr_name = null;
            this.constr_namespace = null;
            this.constr_ownerDoc = null;
        }
        return this.theElement;
    }

    void setInUse(boolean bl) {
        this.inUse = bl;
    }

    boolean isInUse() {
        return this.inUse;
    }

    boolean isListImpl(int n) {
        Object[] objectArray = this.getSchemaObject();
        if (n < objectArray.length) {
            return objectArray[n] instanceof Object[];
        }
        return false;
    }

    void clearNodeArray() {
        for (int i = 0; i < this.nodeArray.length; ++i) {
            this.nodeArray[i] = null;
        }
    }

    protected void setElement(String string, String string2, JaxbNode jaxbNode, int n) {
        if (this.isListImpl(n)) {
            return;
        }
        Object object = this.nodeArray[n];
        if (jaxbNode == null) {
            if (object != null) {
                if (object instanceof JaxbNode) {
                    this.getDOMNode().removeChild((Node)((JaxbNode)object).getDOMNode());
                } else {
                    this.getDOMNode().removeChild((Node)((XMLNode)object));
                }
                this.nodeArray[n] = null;
            }
            return;
        }
        this.syncOwnerDocument(jaxbNode);
        XMLElement xMLElement = jaxbNode.getDOMNode();
        this.resetTypeName((XMLNode)xMLElement, string, string2);
        if (object != null) {
            if (object instanceof JaxbNode) {
                object = ((JaxbNode)object).getDOMNode();
            }
            if (object != xMLElement) {
                this.getDOMNode().replaceChild((Node)xMLElement, (Node)((XMLNode)object));
            }
        } else {
            XMLNode xMLNode = this.getNextNode(n);
            this.getDOMNode().insertBefore((Node)xMLElement, (Node)xMLNode);
        }
        this.nodeArray[n] = jaxbNode;
        jaxbNode.setInUse(true);
    }

    protected void setElement(String string, String string2, JaxbNode jaxbNode) {
        XMLElement xMLElement;
        this.syncOwnerDocument(jaxbNode);
        this.theElement = xMLElement = jaxbNode.getDOMNode();
        this.resetTypeName((XMLNode)xMLElement, string, string2);
    }

    protected JaxbNode getElement(JaxbNode jaxbNode) {
        this.syncOwnerDocument(jaxbNode);
        jaxbNode.theElement = this.getDOMNode();
        jaxbNode.clearNodeArray();
        jaxbNode.populateNodeArray((XMLNode)jaxbNode.theElement);
        return jaxbNode;
    }

    protected JaxbNode getElement(String string, String string2, JaxbNode jaxbNode, int n) {
        Object object = this.nodeArray[n];
        if (object != null) {
            if (object instanceof JaxbNode) {
                return (JaxbNode)object;
            }
            if (jaxbNode.theElement != null) {
                this.syncOwnerDocument(jaxbNode);
            }
            jaxbNode.theElement = (XMLElement)object;
            jaxbNode.clearNodeArray();
            jaxbNode.populateNodeArray((XMLNode)object);
            this.nodeArray[n] = jaxbNode;
            return jaxbNode;
        }
        return null;
    }

    protected void setNodeArrayValue(int n, XMLNode xMLNode) {
        this.nodeArray[n] = xMLNode;
    }

    protected void setNodeVectorValue(int n, XMLNode xMLNode) {
        this.setNodeVectorValue("", "", this, n, xMLNode);
    }

    protected void setNodeVectorValue(String string, String string2, JaxbNode jaxbNode, int n, XMLNode xMLNode) {
        if (!this.isListImpl(n)) {
            return;
        }
        JaxbListImpl jaxbListImpl = (JaxbListImpl)this.nodeArray[n];
        if (jaxbListImpl == null) {
            jaxbListImpl = new JaxbListImpl(string, string2, null, jaxbNode, n);
            this.nodeArray[n] = jaxbListImpl;
        }
        jaxbListImpl.add2List(xMLNode);
    }

    public void setAnyType() {
        JaxbListImpl jaxbListImpl = (JaxbListImpl)this.getList("Content", "", this, 0);
        jaxbListImpl.setAnyType(true);
    }

    protected void populateAnyType(String string, XMLNode xMLNode) {
        this.populateAnyType(string, this.getClass().getClassLoader(), xMLNode);
    }

    protected void populateAnyType(String string, ClassLoader classLoader, XMLNode xMLNode) {
        JAXBContext jAXBContext = null;
        Unmarshaller unmarshaller = null;
        if (xMLNode == null) {
            return;
        }
        try {
            jAXBContext = JAXBContext.newInstance(string, classLoader);
            unmarshaller = jAXBContext.createUnmarshaller();
        }
        catch (Exception exception) {
            return;
        }
        JaxbListImpl jaxbListImpl = (JaxbListImpl)this.getList("Content", "", this, 0);
        jaxbListImpl.clear();
        jaxbListImpl.setAnyType(true);
        XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
        boolean bl = false;
        while (xMLNode2 != null) {
            try {
                Object object = unmarshaller.unmarshal((Node)xMLNode2);
                if (object != null) {
                    Class<?> clazz = object.getClass();
                    jaxbListImpl.add2List((JaxbNode)object);
                    xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            jaxbListImpl.add2List(xMLNode2);
            xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
        }
    }

    protected void populateNodeArray(XMLNode xMLNode) {
        if (this.getDOMNode() == (XMLElement)xMLNode) {
            return;
        }
        NamedNodeMap namedNodeMap = xMLNode.getAttributes();
        if (namedNodeMap != null) {
            XMLDocument xMLDocument = (XMLDocument)this.theElement.getOwnerDocument();
            XMLAttr xMLAttr = null;
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                XMLAttr xMLAttr2 = (XMLAttr)namedNodeMap.item(i);
                xMLAttr = (XMLAttr)xMLDocument.createAttributeNS(xMLAttr2.getNamespaceURI(), xMLAttr2.getLocalName());
                xMLAttr.setValue(xMLAttr2.getValue());
                this.theElement.setAttributeNode((Attr)xMLAttr);
            }
        }
    }

    protected Object[] getSchemaObject() {
        return null;
    }

    protected List getList(String string, String string2, JaxbNode jaxbNode, int n) {
        if (!this.isListImpl(n)) {
            return null;
        }
        JaxbListImpl jaxbListImpl = (JaxbListImpl)this.nodeArray[n];
        if (jaxbListImpl == null) {
            jaxbListImpl = new JaxbListImpl(string, string2, null, jaxbNode, n);
            this.nodeArray[n] = jaxbListImpl;
        } else {
            jaxbListImpl.setName(string);
            jaxbListImpl.setNamespace(string2);
            jaxbListImpl.setOwner(jaxbNode);
        }
        return jaxbListImpl;
    }

    protected Object createJaxbNode(XMLNode xMLNode) {
        return null;
    }

    protected Object createSimpleType(String string, String string2) {
        string = string.intern();
        string2 = string2.trim();
        if (string == "java.lang.String") {
            return new String(string2);
        }
        if (string == "BigInteger" || string == "java.math.BigInteger") {
            return new BigInteger(string2);
        }
        if (string == "int") {
            return new Integer(string2);
        }
        if (string == "long") {
            return new Long(string2);
        }
        if (string == "short") {
            return new Short(string2);
        }
        if (string == "BigDecimal" || string == "java.math.BigDecimal") {
            return new BigDecimal(string2);
        }
        if (string == "float") {
            return new Float(string2);
        }
        if (string == "double") {
            return new Double(string2);
        }
        if (string == "boolean") {
            return new Boolean(string2);
        }
        if (string == "byte") {
            return new Byte(string2);
        }
        return null;
    }

    void resetTypeName(XMLNode xMLNode, String string, String string2) {
        String string3 = xMLNode.getLocalName();
        String string4 = xMLNode.getNamespaceURI();
        if (string4 == null) {
            string4 = "";
        }
        if (string2 == null) {
            string2 = "";
        }
        if (string3 == null || !string3.equals(string) || !string4.equals(string2)) {
            ((XMLElement)xMLNode).setTagName(string2, string);
        }
    }

    void syncOwnerDocument(JaxbNode jaxbNode) {
        XMLElement xMLElement = jaxbNode.getDOMNode();
        XMLDocument xMLDocument = this.getOwnerDocument();
        if (xMLDocument != xMLElement.getOwnerDocument()) {
            jaxbNode.theElement = xMLElement = (XMLElement)xMLDocument.adoptNode((Node)xMLElement);
            jaxbNode.clearNodeArray();
            jaxbNode.populateNodeArray((XMLNode)xMLElement);
        }
    }

    protected void setJaxbElement(String string, String string2, String string3, int n) {
        if (this.isListImpl(n)) {
            return;
        }
        XMLNode xMLNode = (XMLNode)this.nodeArray[n];
        if (xMLNode != null) {
            if (string3 == null) {
                this.getDOMNode().removeChild((Node)xMLNode);
                this.nodeArray[n] = null;
                return;
            }
            XMLText xMLText = this.getTextChild(xMLNode);
            if (xMLText != null) {
                xMLText.setNodeValue(string3);
            } else {
                xMLText = (XMLText)this.getOwnerDocument().createTextNode(string3);
                xMLNode.appendChild((Node)xMLText);
            }
            return;
        }
        if (string3 == null) {
            return;
        }
        XMLDocument xMLDocument = this.getOwnerDocument();
        XMLText xMLText = (XMLText)xMLDocument.createTextNode(string3);
        xMLNode = (XMLNode)xMLDocument.createElementNS(string2, string);
        xMLNode.appendChild((Node)xMLText);
        XMLNode xMLNode2 = this.getNextNode(n);
        this.getDOMNode().insertBefore((Node)xMLNode, (Node)xMLNode2);
        this.nodeArray[n] = xMLNode;
    }

    private XMLText getTextChild(XMLNode xMLNode) {
        XMLNode xMLNode2;
        for (xMLNode2 = (XMLNode)xMLNode.getFirstChild(); xMLNode2 != null && !(xMLNode2 instanceof XMLText); xMLNode2 = (XMLNode)xMLNode2.getNextSibling()) {
        }
        return (XMLText)xMLNode2;
    }

    XMLNode getNextNode(int n) {
        for (int i = n + 1; i < this.nodeArray.length; ++i) {
            Object object = this.nodeArray[i];
            if (object == null) continue;
            if (object instanceof JaxbListImpl) {
                ArrayList arrayList = ((JaxbListImpl)object).nodeList;
                int n2 = arrayList.size();
                if (n2 == 0) continue;
                object = arrayList.get(0);
            }
            if (object instanceof JaxbNode) {
                return ((JaxbNode)object).getDOMNode();
            }
            return (XMLNode)object;
        }
        return null;
    }

    protected void setJaxbElementStringValue(String string, String string2, String string3, int n) {
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementBigIntegerValue(String string, String string2, BigInteger bigInteger, int n) {
        String string3 = null;
        if (bigInteger != null) {
            string3 = bigInteger.toString();
        }
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementIntValue(String string, String string2, int n, int n2) {
        String string3 = new Integer(n).toString();
        this.setJaxbElement(string, string2, string3, n2);
    }

    protected void setJaxbElementLongValue(String string, String string2, long l, int n) {
        String string3 = new Long(l).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementShortValue(String string, String string2, short s, int n) {
        String string3 = new Short(s).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementBigDecimalValue(String string, String string2, BigDecimal bigDecimal, int n) {
        String string3 = null;
        if (bigDecimal != null) {
            string3 = bigDecimal.toString();
        }
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementFloatValue(String string, String string2, float f, int n) {
        String string3 = new Float(f).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementDoubleValue(String string, String string2, double d, int n) {
        String string3 = new Double(d).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementBooleanValue(String string, String string2, boolean bl, int n) {
        String string3 = new Boolean(bl).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementByteValue(String string, String string2, byte by, int n) {
        String string3 = new Byte(by).toString();
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementQNameValue(String string, String string2, QName qName, int n) {
        this.setJaxbElement(string, string2, qName.toString(), n);
    }

    protected void setJaxbElementCalendarValue(String string, String string2, Calendar calendar, int n) {
        this.setJaxbElement(string, string2, JaxbDatatypeConverter.convertCalendarToString(calendar), n);
    }

    protected void setJaxbElementByteArrayValue(String string, String string2, byte[] byArray, int n) {
        String string3 = null;
        if (byArray != null) {
            string3 = new String(byArray);
        }
        this.setJaxbElement(string, string2, string3, n);
    }

    protected void setJaxbElementObjectValue(Object object, int n) {
        if (this.isListImpl(n)) {
            return;
        }
        XMLNode xMLNode = (XMLNode)this.nodeArray[n];
        if (xMLNode != null) {
            if (object == null) {
                this.getDOMNode().removeChild((Node)xMLNode);
                this.nodeArray[n] = null;
                return;
            }
        } else if (object == null) {
            return;
        }
        XMLNode xMLNode2 = (XMLNode)object;
        XMLDocument xMLDocument = this.getOwnerDocument();
        xMLNode2 = (XMLNode)xMLDocument.adoptNode((Node)xMLNode2);
        XMLNode xMLNode3 = this.getNextNode(n);
        this.getDOMNode().insertBefore((Node)xMLNode2, (Node)xMLNode3);
        this.nodeArray[n] = xMLNode2;
    }

    protected String getJaxbElement(String string, String string2, int n) {
        if (this.isListImpl(n)) {
            return null;
        }
        XMLNode xMLNode = (XMLNode)this.nodeArray[n];
        if (xMLNode != null) {
            String string3 = xMLNode.getLocalName();
            String string4 = xMLNode.getNamespaceURI();
            if (string4 == null) {
                string4 = "";
            }
            if (string.equals(string3) && string2.equals(string4)) {
                return xMLNode.getText().trim();
            }
        }
        return null;
    }

    protected String getJaxbElementStringValue(String string, String string2, int n) {
        return this.getJaxbElement(string, string2, n);
    }

    protected BigInteger getJaxbElementBigIntegerValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new BigInteger(string3);
        }
        return null;
    }

    protected int getJaxbElementIntValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Integer(string3);
        }
        return 0;
    }

    protected long getJaxbElementLongValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Long(string3);
        }
        return 0L;
    }

    protected short getJaxbElementShortValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Short(string3);
        }
        return 0;
    }

    protected BigDecimal getJaxbElementBigDecimalValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new BigDecimal(string3);
        }
        return null;
    }

    protected float getJaxbElementFloatValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Float(string3).floatValue();
        }
        return 0.0f;
    }

    protected double getJaxbElementDoubleValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Double(string3);
        }
        return 0.0;
    }

    protected boolean getJaxbElementBooleanValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        return string3 != null && string3.equals("true");
    }

    protected byte getJaxbElementByteValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return new Byte(string3);
        }
        return 0;
    }

    protected QName getJaxbElementQNameValue(int n) {
        if (this.isListImpl(n)) {
            return null;
        }
        XMLNode xMLNode = (XMLNode)this.nodeArray[n];
        if (xMLNode != null) {
            return new QName(xMLNode.getNamespaceURI(), xMLNode.getLocalName());
        }
        return null;
    }

    protected Calendar getJaxbElementCalendarValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        if (string3 != null) {
            return JaxbDatatypeConverter.convertStringToCalendar(string3);
        }
        return null;
    }

    protected byte[] getJaxbElementByteArrayValue(String string, String string2, int n) {
        String string3 = this.getJaxbElement(string, string2, n);
        return null;
    }

    protected Object getJaxbElementObjectValue(int n) {
        if (this.isListImpl(n)) {
            return null;
        }
        XMLNode xMLNode = (XMLNode)this.nodeArray[n];
        return xMLNode;
    }

    protected void setJaxbAttr(String string, String string2, String string3) {
        if (string3 == null) {
            this.getDOMNode().removeAttributeNS(string2, string);
            return;
        }
        Attr attr = this.getDOMNode().getAttributeNodeNS(string2, string);
        if (attr == null) {
            attr = this.getOwnerDocument().createAttributeNS(string2, string);
        }
        attr.setValue(string3);
        this.getDOMNode().setAttributeNode(attr);
    }

    protected void setJaxbAttrStringValue(String string, String string2, String string3) {
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrBigIntegerValue(String string, String string2, BigInteger bigInteger) {
        String string3 = null;
        if (bigInteger != null) {
            string3 = bigInteger.toString();
        }
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrIntValue(String string, String string2, int n) {
        String string3 = new Integer(n).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrLongValue(String string, String string2, long l) {
        String string3 = new Long(l).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrShortValue(String string, String string2, short s) {
        String string3 = new Short(s).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrBigDecimalValue(String string, String string2, BigDecimal bigDecimal) {
        String string3 = null;
        if (bigDecimal != null) {
            string3 = bigDecimal.toString();
        }
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrFloatValue(String string, String string2, float f) {
        String string3 = new Float(f).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrDoubleValue(String string, String string2, double d) {
        String string3 = new Double(d).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrBooleanValue(String string, String string2, boolean bl) {
        String string3 = new Boolean(bl).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrByteValue(String string, String string2, byte by) {
        String string3 = new Byte(by).toString();
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrQNameValue(String string, String string2, QName qName) {
        this.setJaxbAttr(string, string2, qName.toString());
    }

    protected void setJaxbAttrCalendarValue(String string, String string2, Calendar calendar) {
        this.setJaxbAttr(string, string2, JaxbDatatypeConverter.convertCalendarToString(calendar));
    }

    protected void setJaxbAttrByteArrayValue(String string, String string2, byte[] byArray) {
        String string3 = null;
        if (byArray != null) {
            string3 = new String(byArray);
        }
        this.setJaxbAttr(string, string2, string3);
    }

    protected void setJaxbAttrObjectValue(String string, String string2, Object object) {
        String string3 = null;
        if (object != null) {
            string3 = object.toString();
        }
        this.setJaxbAttr(string, string2, string3);
    }

    protected String getJaxbAttr(String string, String string2) {
        Attr attr = this.getDOMNode().getAttributeNodeNS(string2, string);
        return attr == null ? null : attr.getValue().trim();
    }

    protected String getJaxbAttrStringValue(String string, String string2) {
        return this.getJaxbAttr(string, string2);
    }

    protected BigInteger getJaxbAttrBigIntegerValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? null : new BigInteger(string3);
    }

    protected int getJaxbAttrIntValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? 0 : new Integer(string3);
    }

    protected long getJaxbAttrLongValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? 0L : new Long(string3);
    }

    protected short getJaxbAttrShortValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? (short)0 : new Short(string3);
    }

    protected BigDecimal getJaxbAttrBigDecimalValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? null : new BigDecimal(string3);
    }

    protected float getJaxbAttrFloatValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? 0.0f : new Float(string3).floatValue();
    }

    protected double getJaxbAttrDoubleValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? 0.0 : new Double(string3);
    }

    protected boolean getJaxbAttrBooleanValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 != null && string3.equalsIgnoreCase("true");
    }

    protected byte getJaxbAttrByteValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? (byte)0 : new Byte(string3);
    }

    protected QName getJaxbAttrQNameValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return QName.valueOf(string3);
    }

    protected Calendar getJaxbAttrCalendarValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? null : JaxbDatatypeConverter.convertStringToCalendar(string3);
    }

    protected byte[] getJaxbAttrByteArrayValue(String string, String string2) {
        String string3 = this.getJaxbAttr(string, string2);
        return string3 == null ? null : string3.getBytes();
    }

    protected Object getJaxbAttrObjectValue(Object object, String string) {
        return this.getJaxbAttr(object.toString(), string);
    }

    public void setJaxbValue(String string) {
        Text text = (Text)this.getDOMNode().getFirstChild();
        if (string == null) {
            if (text != null) {
                this.theElement.removeChild((Node)text);
            }
            return;
        }
        if (text != null) {
            String string2 = text.getNodeValue();
            if (!string.equals(string2)) {
                text.setNodeValue(string);
            }
            Node node = text;
            while (node != null && (node = node.getNextSibling()) != null) {
                if (node.getNodeType() != 3) continue;
                Node node2 = node.getNextSibling();
                this.theElement.removeChild(node);
                node = node2;
            }
        } else {
            text = this.getOwnerDocument().createTextNode(string);
            this.theElement.appendChild((Node)text);
        }
    }

    protected void setJaxbStringValue(String string) {
        this.setJaxbValue(string);
    }

    protected void setJaxbBigIntegerValue(BigInteger bigInteger) {
        this.setJaxbValue(bigInteger.toString());
    }

    protected void setJaxbIntValue(int n) {
        this.setJaxbValue(new Integer(n).toString());
    }

    protected void setJaxbLongValue(long l) {
        this.setJaxbValue(new Long(l).toString());
    }

    protected void setJaxbShortValue(short s) {
        this.setJaxbValue(new Short(s).toString());
    }

    protected void setJaxbBigDecimalValue(BigDecimal bigDecimal) {
        String string = null;
        if (bigDecimal != null) {
            string = bigDecimal.toString();
        }
        this.setJaxbValue(string);
    }

    protected void setJaxbFloatValue(float f) {
        this.setJaxbValue(new Float(f).toString());
    }

    protected void setJaxbDoubleValue(double d) {
        this.setJaxbValue(new Double(d).toString());
    }

    protected void setJaxbBooleanValue(boolean bl) {
        this.setJaxbValue(new Boolean(bl).toString());
    }

    protected void setJaxbByteValue(byte by) {
        this.setJaxbValue(new Byte(by).toString());
    }

    protected void setJaxbQNameValue(QName qName) {
        this.setJaxbValue(qName.toString());
    }

    protected void setJaxbCalendarValue(Calendar calendar) {
        this.setJaxbValue(JaxbDatatypeConverter.convertCalendarToString(calendar));
    }

    protected void setJaxbByteArrayValue(byte[] byArray) {
        this.setJaxbValue(new String(byArray));
    }

    protected void setJaxbObjectValue(Object object) {
        this.setJaxbValue(object.toString());
    }

    protected String getJaxbValue() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        for (XMLNode xMLNode = (XMLNode)this.getDOMNode().getFirstChild(); xMLNode != null; xMLNode = (XMLNode)xMLNode.getNextSibling()) {
            if (xMLNode.getNodeType() != 3) continue;
            string = xMLNode.getNodeValue();
            stringBuffer.append(string);
        }
        string = stringBuffer.toString();
        if (string.equals("")) {
            return null;
        }
        return string;
    }

    protected String getJaxbStringValue() {
        return this.getJaxbValue();
    }

    protected BigInteger getJaxbBigIntegerValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new BigInteger(string.trim());
        }
        return null;
    }

    protected int getJaxbIntValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Integer(string.trim());
        }
        return 0;
    }

    protected List getJaxbListValue() {
        String string = this.getJaxbValue();
        return JaxbDatatypeConverter.parseList(string.trim());
    }

    protected long getJaxbLongValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Long(string.trim());
        }
        return 0L;
    }

    protected short getJaxbShortValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Short(string.trim());
        }
        return 0;
    }

    protected BigDecimal getJaxbBigDecimalValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new BigDecimal(string.trim());
        }
        return null;
    }

    protected float getJaxbFloatValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Float(string.trim()).floatValue();
        }
        return 0.0f;
    }

    protected double getJaxbDoubleValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Double(string.trim());
        }
        return 0.0;
    }

    protected boolean getJaxbBooleanValue() {
        String string = this.getJaxbValue().trim();
        return string != null && string.equals("true");
    }

    protected byte getJaxbByteValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return new Byte(string.trim());
        }
        return 0;
    }

    protected QName getJaxbQNameValue() {
        String string = this.getJaxbValue();
        return QName.valueOf(string);
    }

    protected Calendar getJaxbCalendarValue() {
        String string = this.getJaxbValue();
        if (string != null) {
            return JaxbDatatypeConverter.convertStringToCalendar(string.trim());
        }
        return null;
    }

    protected byte[] getJaxbByteArrayValue() {
        String string = this.getJaxbValue();
        return null;
    }

    protected Object getJaxbObjectValue() {
        return this.getJaxbValue();
    }

    public void marshal(OutputStream outputStream, HashMap hashMap, XMLError xMLError) throws MarshalException {
        XMLDocument xMLDocument = this.getOwnerDocument();
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(outputStream);
        xMLDocument.setVersion("1.0");
        try {
            for (String string : hashMap.keySet()) {
                Object v = hashMap.get(string);
                if (string.equals("jaxb.encoding")) {
                    xMLDocument.setEncoding((String)v);
                    xMLPrintDriver.setEncoding((String)v);
                    continue;
                }
                if (!string.equals("jaxb.formatted.output")) continue;
                xMLPrintDriver.setFormatPrettyPrint(((Boolean)v).booleanValue());
            }
            xMLPrintDriver.printXMLDecl(xMLDocument);
            xMLPrintDriver.printElement(this.getDOMNode(), true);
            xMLPrintDriver.flush();
        }
        catch (Exception exception) {
            throw new MarshalException(xMLError.getMessage0(32103));
        }
    }

    public void marshal(Writer writer, HashMap hashMap, XMLError xMLError) throws MarshalException {
        XMLDocument xMLDocument = this.getOwnerDocument();
        XMLPrintDriver xMLPrintDriver = new XMLPrintDriver(writer);
        xMLDocument.setVersion("1.0");
        try {
            for (String string : hashMap.keySet()) {
                Object v = hashMap.get(string);
                if (string.equals("jaxb.encoding")) {
                    xMLDocument.setEncoding((String)v);
                    xMLPrintDriver.setEncoding((String)v);
                    continue;
                }
                if (!string.equals("jaxb.formatted.output")) continue;
                xMLPrintDriver.setFormatPrettyPrint(((Boolean)v).booleanValue());
            }
            xMLPrintDriver.printXMLDecl(xMLDocument);
            xMLPrintDriver.printElement(this.getDOMNode(), true);
            xMLPrintDriver.flush();
        }
        catch (Exception exception) {
            throw new MarshalException(xMLError.getMessage0(32103));
        }
    }

    public void marshal(ContentHandler contentHandler, HashMap hashMap, XMLError xMLError) throws MarshalException {
        try {
            this.getDOMNode().reportSAXEvents(contentHandler);
        }
        catch (Exception exception) {
            throw new MarshalException(xMLError.getMessage0(32103));
        }
    }

    public void marshal(Node node, HashMap hashMap, XMLError xMLError) throws MarshalException {
        try {
            Node node2 = this.getDOMNode().cloneNode(true);
            node2 = node instanceof XMLDocument ? ((XMLDocument)node).adoptNode(node2) : ((XMLDocument)node.getOwnerDocument()).adoptNode(node2);
            node.appendChild(node2);
        }
        catch (Exception exception) {
            throw new MarshalException(xMLError.getMessage0(32103));
        }
    }

    private void dumpNodeArray(String string) {
        System.out.println(string);
        try {
            for (int i = 0; i < this.nodeArray.length; ++i) {
                ArrayList arrayList;
                if (this.nodeArray[i] instanceof JaxbListImpl) {
                    System.out.print("[");
                    arrayList = ((JaxbListImpl)this.nodeArray[i]).nodeList;
                    for (int j = 0; j < arrayList.size(); ++j) {
                        if (arrayList.get(j) instanceof XMLNode) {
                            ((XMLNode)arrayList.get(j)).print((OutputStream)System.out);
                            continue;
                        }
                        System.out.println(arrayList.toString());
                    }
                    System.out.print("]");
                    continue;
                }
                if (this.nodeArray[i] == null) continue;
                arrayList = null;
                arrayList = this.nodeArray[i] instanceof JaxbNode ? ((JaxbNode)this.nodeArray[i]).getDOMNode() : (XMLNode)this.nodeArray[i];
                arrayList.print(System.out);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        this.writeExternal(objectOutput, -1);
    }

    protected void writeExternal(ObjectOutput objectOutput, int n) throws IOException {
        Object object;
        if (n < 0) {
            objectOutput.writeLong(1L);
            object = (XMLDocument)this.getDOMNode().getOwnerDocument();
            XMLElement xMLElement = (XMLElement)object.getDocumentElement();
            if (xMLElement == this.theElement) {
                objectOutput.writeShort(0);
                object.writeExternal(objectOutput);
            } else {
                objectOutput.writeShort(1);
                this.getDOMNode().writeExternal(objectOutput);
            }
        } else {
            objectOutput.writeInt(n);
        }
        objectOutput.writeBoolean(this.inUse);
        objectOutput.writeInt(this.nodeArray.length);
        object = null;
        int n2 = 0;
        XMLNode xMLNode = (XMLNode)this.getDOMNode().getFirstChild();
        XMLElement xMLElement = null;
        for (int i = 0; i < this.nodeArray.length; ++i) {
            object = this.nodeArray[i];
            if (object == null) {
                objectOutput.write(0);
                continue;
            }
            xMLElement = null;
            if (object instanceof JaxbNode) {
                xMLElement = ((JaxbNode)object).getDOMNode();
            } else if (object instanceof XMLNode) {
                xMLElement = (XMLNode)object;
            }
            if (xMLElement != null) {
                while (xMLNode != xMLElement) {
                    if (xMLNode == null) {
                        throw new IOException();
                    }
                    ++n2;
                    xMLNode = (XMLNode)xMLNode.getNextSibling();
                }
            }
            JaxbUtil.writeExternal(objectOutput, object, n2);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.readExternal(objectInput, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readExternal(ObjectInput objectInput, XMLNode xMLNode) throws IOException, ClassNotFoundException {
        int n;
        if (xMLNode == null) {
            long l = objectInput.readLong();
            if (l != 1L) {
                throw new IOException();
            }
            n = objectInput.readShort();
            XMLDocument xMLDocument = new XMLDocument();
            if (n == 0) {
                xMLDocument.readExternal(objectInput);
                this.theElement = (XMLElement)xMLDocument.getDocumentElement();
            } else {
                if (n != 1) throw new IOException();
                this.theElement = (XMLElement)xMLDocument.createElementNS(null, "jaxb");
                this.theElement.readExternal(objectInput);
            }
        } else {
            XMLNode xMLNode2 = (XMLNode)xMLNode.getFirstChild();
            for (int i = objectInput.readInt(); i > 0; --i) {
                xMLNode2 = (XMLNode)xMLNode2.getNextSibling();
            }
            this.theElement = (XMLElement)xMLNode2;
        }
        this.inUse = objectInput.readBoolean();
        int n2 = objectInput.readInt();
        this.nodeArray = new Object[n2];
        block12: for (int i = 0; i < n2; ++i) {
            n = objectInput.read();
            switch (n) {
                case 0: {
                    this.nodeArray[i] = null;
                    continue block12;
                }
                case 1: {
                    JaxbNode jaxbNode;
                    String string = objectInput.readUTF();
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                    try {
                        jaxbNode = (JaxbNode)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new ClassNotFoundException(string, exception);
                    }
                    jaxbNode.readExternal(objectInput, (XMLNode)this.theElement);
                    this.nodeArray[i] = jaxbNode;
                    continue block12;
                }
                case 2: {
                    JaxbListImpl jaxbListImpl;
                    String string = objectInput.readUTF();
                    Class<?> clazz = this.getClass().getClassLoader().loadClass(string);
                    try {
                        jaxbListImpl = (JaxbListImpl)clazz.newInstance();
                    }
                    catch (Exception exception) {
                        throw new ClassNotFoundException(string, exception);
                    }
                    jaxbListImpl.readExternal(objectInput, this);
                    this.nodeArray[i] = jaxbListImpl;
                    continue block12;
                }
                case 3: {
                    XMLNode xMLNode3 = (XMLNode)this.theElement.getFirstChild();
                    for (int j = objectInput.readInt(); j > 0; --j) {
                        xMLNode3 = (XMLNode)xMLNode3.getNextSibling();
                    }
                    this.nodeArray[i] = xMLNode3;
                    continue block12;
                }
                case 4: {
                    this.nodeArray[i] = objectInput.readUTF();
                    continue block12;
                }
                default: {
                    throw new IOException();
                }
            }
        }
    }
}

