/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.differ.AbsOffset;
import oracle.xml.differ.Offset;

final class BranchOffset
extends AbsOffset {
    private Vector suboffsets;
    private Object userObject;

    BranchOffset() {
        this(null);
    }

    BranchOffset(Object object) {
        this.userObject = object;
    }

    void addSuboffset(AbsOffset absOffset) {
        if (this.suboffsets == null) {
            this.suboffsets = new Vector();
        }
        this.suboffsets.addElement(absOffset);
    }

    public int getEndOffset() {
        if (this.suboffsets == null) {
            return 0;
        }
        Offset offset = (Offset)this.suboffsets.lastElement();
        return offset.getEndOffset();
    }

    public int getStartOffset() {
        if (this.suboffsets == null) {
            return 0;
        }
        Offset offset = (Offset)this.suboffsets.firstElement();
        return offset.getStartOffset();
    }

    BranchOffset getSubBranchOffsetAt(int n) {
        if (this.contains(n)) {
            if (this.suboffsets != null) {
                for (int i = 0; i < this.suboffsets.size(); ++i) {
                    Offset offset = (Offset)this.suboffsets.elementAt(i);
                    if (!offset.contains(n)) continue;
                    if (offset instanceof BranchOffset) {
                        return ((BranchOffset)offset).getSubBranchOffsetAt(n);
                    }
                    return this;
                }
            }
            return this;
        }
        return null;
    }

    Object getUserObject() {
        return this.userObject;
    }

    Enumeration suboffsets() {
        if (this.suboffsets != null) {
            return this.suboffsets.elements();
        }
        return null;
    }

    public String toString() {
        return "BranchOffset[" + this.getStartOffset() + "," + this.getEndOffset() + "]";
    }
}

