/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.ext;

import antlr.CommonAST;
import antlr.Token;
import antlr.collections.AST;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import oracle.dbtools.migration.parser.ext.ExtToken;
import oracle.dbtools.migration.parser.filter.comments.Comment;
import oracle.dbtools.migration.translation.api.components.Block;
import org.antlr.stringtemplate.StringTemplate;

public class ExtAST
extends CommonAST {
    public static final String AST_TAG_FORMAT = "/*AST[%hashcode%]{%text%}*/";
    public static final String AST_TAG_REGEXP = "/\\*AST\\[(\\-|\\+)?([0-9])+\\]\\{([^}])*\\}\\*/";
    private static final long serialVersionUID = 0L;
    protected boolean m_tagRendered;
    protected Hashtable keyvalues = new Hashtable();
    protected List<Comment> m_prefixComments;
    protected List<Comment> m_suffixComments;
    protected ExtAST m_parent = null;
    protected Block m_block;
    protected int m_index;
    protected int m_line;
    protected int m_column;
    protected int m_charPosition;
    protected String m_templateID = null;
    protected ArrayList<StringTemplate> stList = null;
    public static final String ORIGTEXT = "ORIGTEXT";

    public ExtAST() {
        this.m_line = -1;
        this.m_column = -1;
        this.sourceStartLine = -1;
        this.sourceStartCol = -1;
        this.sourceEndLine = -1;
        this.sourceEndCol = -1;
        this.stList = new ArrayList();
        this.m_prefixComments = new ArrayList<Comment>();
        this.m_suffixComments = new ArrayList<Comment>();
    }

    public void setText(String string) {
        if (!this.keyvalues.contains(ORIGTEXT) && this.getText() != null) {
            this.keyvalues.put(ORIGTEXT, this.getText());
        }
        super.setText(string);
    }

    public ExtAST(Token token) {
        super(token);
    }

    public void setParent(ExtAST extAST) {
        this.addExtraInfo("PARENT", (Object)extAST);
    }

    public ExtAST getParent() {
        return (ExtAST)((Object)this.getExtraInfo("PARENT"));
    }

    public int getIndex() {
        return this.m_index;
    }

    public void setIndex(int n) {
        this.m_index = n;
    }

    public int getLine() {
        return this.m_line;
    }

    public void setLine(int n) {
        this.m_line = n;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void setColumn(int n) {
        this.m_column = n;
    }

    public int getCharPosition() {
        return this.m_charPosition;
    }

    public void setCharPosition(int n) {
        this.m_charPosition = n;
    }

    public Block getBlock() {
        return this.m_block;
    }

    public void setBlock(Block block) {
        this.m_block = block;
    }

    public Block getStatementBlock() {
        return this.getStmtBlock(this.m_block);
    }

    private Block getStmtBlock(Block block) {
        if (block != null) {
            if (block.getBlockType().equals("STMTBLOCK") || block.getBlockType().equals("BEGINBLOCK")) {
                return block;
            }
            return this.getStmtBlock(block.getParent());
        }
        return null;
    }

    public void setTagRendered(boolean bl) {
        this.m_tagRendered = bl;
    }

    public boolean isTagRendered() {
        return this.m_tagRendered;
    }

    public void initialize(int n, String string) {
        super.initialize(n, string);
    }

    public void initialize(AST aST) {
        super.initialize(aST);
        this.m_index = ((ExtAST)aST).getIndex();
        this.setSourceStartLine(aST.getSourceStartLine());
        this.setSourceStartCol(aST.getSourceStartCol());
        this.setSourceEndLine(aST.getSourceEndLine());
        this.setSourceEndCol(aST.getSourceEndCol());
        this.setNoTemplate(aST.isNoTemplate());
        this.setStatement(aST.isStatement());
        this.setLine(aST.getLine());
        this.setColumn(aST.getColumn());
        this.setCharPosition(((ExtAST)aST).getCharPosition());
        this.setKeyValues(((ExtAST)aST).getKeyValues());
        if (aST instanceof ExtAST) {
            this.setBlock(((ExtAST)aST).getBlock());
        }
    }

    public void initialize(Token token) {
        super.initialize(token);
        this.m_index = ((ExtToken)token).getIndex();
        this.setLine(token.getLine());
        this.setColumn(token.getColumn());
        this.setCharPosition(((ExtToken)token).getCharPosition());
        this.sourceStartLine = -1;
        this.sourceStartCol = -1;
        this.sourceEndLine = -1;
        this.sourceEndCol = -1;
    }

    public String getText() {
        return super.getText();
    }

    public String getUpperCaseText() {
        return super.getText().toUpperCase();
    }

    public void addPrefixComment(Comment comment) {
        this.m_prefixComments.add(comment);
    }

    public void addSuffixComment(Comment comment) {
        this.m_suffixComments.add(comment);
    }

    public String getPrefixComment() {
        String string = "";
        boolean bl = false;
        int n = this.m_prefixComments.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                Comment comment = this.m_prefixComments.get(i);
                bl = comment.getType().equals((Object)Comment.Type.SINGLE_LINE_SEPARATE_LINE) || comment.getType().equals((Object)Comment.Type.SINGLE_LINE_SEPARATE_LINE);
                string = string + (bl ? "\n" : "") + comment.getText() + "\n";
            }
        }
        return string;
    }

    public String getSuffixComment() {
        String string = "";
        Comment comment = null;
        Comment comment2 = null;
        boolean bl = false;
        boolean bl2 = false;
        int n = this.m_suffixComments.size();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                comment = this.m_suffixComments.get(i);
                bl = comment.getType().equals((Object)Comment.Type.SINGLE_LINE_SEPARATE_LINE);
                if (comment2 != null && comment2.isSingleLineComment()) {
                    bl = false;
                }
                string = string + (bl ? "\n" : "") + comment.getText() + (comment.isSingleLineComment() ? "\n" : "");
                comment2 = comment;
                bl2 = bl;
            }
        }
        return string;
    }

    public String toString() {
        String string = null;
        if (this.m_tagRendered) {
            string = AST_TAG_FORMAT.replace("%hashcode%", String.valueOf(((Object)((Object)this)).hashCode())).replace("%text%", super.getText());
        }
        return string != null ? string : this.getPrefixComment() + super.getText() + this.getSuffixComment();
    }

    public String getInputString() {
        int n;
        int n2;
        ExtAST extAST;
        ExtAST extAST2 = this;
        String string = "";
        if (this.getColumn() != -1) {
            string = string + this.getText();
        }
        if (extAST2.getFirstChild() != null) {
            extAST = (ExtAST)extAST2.getFirstChild();
            if (this.getColumn() != -1) {
                n2 = extAST.getCharPosition() - this.getCharPosition() + this.getText().length();
                for (n = 0; n < n2; ++n) {
                    string = string + " ";
                }
            } else {
                string = string + " ";
            }
            string = string + extAST.getInputString();
        }
        if (extAST2.getNextSibling() != null) {
            extAST = (ExtAST)extAST2.getNextSibling();
            if (this.getColumn() != -1) {
                n2 = extAST.getCharPosition() - (this.getCharPosition() + this.getText().length());
                for (n = 0; n < n2; ++n) {
                    string = string + " ";
                }
            } else {
                string = string + " ";
            }
            string = string + extAST.getInputString();
        }
        return string;
    }

    public AST getSourceAST(AST aST, int n, int n2) {
        if (aST.getSt().getStartIndex() > n || aST.getSt().getEndIndex() < n2) {
            return null;
        }
        if (aST.getNumberOfChildren() > 0) {
            AST aST2 = aST.getFirstChild();
            AST aST3 = this.getSourceAST(aST2, n, n2);
            if (aST3 != null) {
                return aST3;
            }
            while (aST2.getNextSibling() != null) {
                aST3 = this.getSourceAST(aST2 = aST2.getNextSibling(), n, n2);
                if (aST3 == null) continue;
                return aST3;
            }
            return aST;
        }
        return aST;
    }

    public ExtAST getOutputAST(int n, int n2, int n3, int n4) {
        ExtAST extAST = null;
        ExtAST[] extASTArray = new ExtAST[1];
        this.getOutputAST(this, n, n2, n3, n4, extASTArray);
        extAST = extASTArray[0];
        if (extAST == null) {
            extAST = this;
        }
        return extAST;
    }

    void getOutputAST(ExtAST extAST, int n, int n2, int n3, int n4, ExtAST[] extASTArray) {
        ExtAST extAST2;
        if (extAST.containsRange(n, n2, n3, n4) && ((extAST2 = extASTArray[0]) == null || extAST2.contains((AST)extAST))) {
            extASTArray[0] = extAST;
        }
        if (extAST.getNumberOfChildren() > 0) {
            extAST2 = (ExtAST)extAST.getFirstChild();
            this.getOutputAST(extAST2, n, n2, n3, n4, extASTArray);
            while (extAST2.getNextSibling() != null) {
                extAST2 = (ExtAST)extAST2.getNextSibling();
                this.getOutputAST(extAST2, n, n2, n3, n4, extASTArray);
            }
        }
    }

    public boolean contains(AST aST) {
        int n = aST.getSourceStartLine();
        int n2 = aST.getSourceStartCol();
        int n3 = aST.getSourceEndLine();
        int n4 = aST.getSourceEndCol();
        return this.containsRange(n, n2, n3, n4);
    }

    public boolean containsRange(int n, int n2, int n3, int n4) {
        if (n == 0 && n2 == 0 && n3 == 0 && n4 == 0) {
            return false;
        }
        if (this.getSourceEndCol() == 0 && this.getSourceEndLine() == 0 && this.getSourceStartCol() == 0 && this.getSourceStartLine() == 0) {
            return false;
        }
        return n >= this.getSourceStartLine() && (n != this.getSourceStartLine() || n2 >= this.getSourceStartCol()) && n3 <= this.getSourceEndLine() && (n3 != this.getSourceEndLine() || n4 <= this.getSourceEndCol());
    }

    public void addExtraInfo(Object object, Object object2) {
        this.keyvalues.put(object, object2);
    }

    public Object getExtraInfo(Object object) {
        if (object == null) {
            return null;
        }
        return this.keyvalues.get(object);
    }

    public Hashtable getKeyValues() {
        return this.keyvalues;
    }

    public void setKeyValues(Hashtable hashtable) {
        this.keyvalues = hashtable;
    }

    public void setStatement(boolean bl) {
        super.setStatement(bl);
    }

    public StringTemplate[] getAllStringTemplates() {
        return this.stList.toArray(new StringTemplate[this.stList.size()]);
    }

    public void setSt(StringTemplate stringTemplate) {
        if (this.st == null) {
            this.st = stringTemplate;
        }
        this.stList.add(stringTemplate);
    }

    public AST getLastChild() {
        AST aST = this.getFirstChild();
        if (aST == null) {
            return aST;
        }
        for (int i = 1; i < this.getNumberOfChildren(); ++i) {
            if (aST == null) continue;
            aST = aST.getNextSibling();
        }
        return aST;
    }

    public static AST findParentAST(AST aST, AST aST2) {
        AST aST3 = null;
        if (aST == null) {
            return null;
        }
        AST aST4 = aST.getFirstChild();
        if (aST4 == null) {
            return null;
        }
        do {
            if (!aST4.getText().equalsIgnoreCase(aST2.getText())) continue;
            aST3 = aST;
            break;
        } while ((aST3 = ExtAST.findParentAST(aST4, aST2)) == null && (aST4 = aST4.getNextSibling()) != null);
        return aST3;
    }
}

