/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser.analysis.action;

import antlr.collections.AST;
import oracle.dbtools.migration.parser.analysis.action.TreeParserAction;
import oracle.dbtools.migration.parser.ext.ExtAST;
import oracle.dbtools.migration.parser.ext.ExtTreeParser;
import oracle.dbtools.migration.parser.grammar.TSQLVocabTokenTypes;
import oracle.dbtools.migration.translation.api.TranslationLimitation;
import oracle.dbtools.migration.translation.api.components.Block;

public class TSQLLimitationAnalysisAction
extends TreeParserAction
implements TSQLVocabTokenTypes {
    public TSQLLimitationAnalysisAction(ExtTreeParser extTreeParser) {
        super(extTreeParser);
    }

    public void clauseLimitation(AST aST) {
        this.getHelper().getLimitationManager().handleLimitation(aST, TranslationLimitation.Type.CLAUSE);
    }

    public void statementLimitation(AST aST, boolean bl) {
        if (!bl) {
            AST aST2;
            Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
            if (block != null && (aST2 = block.getAST()) != null) {
                this.getHelper().getLimitationManager().handleLimitation(aST2, TranslationLimitation.Type.STATEMENT);
            }
        } else {
            this.getHelper().getLimitationManager().handleLimitation(aST, TranslationLimitation.Type.STATEMENT);
        }
    }

    public void roleStatementLimitation(AST aST, AST aST2) {
        AST aST3 = null;
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "STMTBLOCK");
        if (block != null) {
            aST3 = block.getAST();
        }
        if (aST3 != null && (aST2 != null || block != null && block.getBlockName().equalsIgnoreCase("ALTER"))) {
            this.getHelper().getLimitationManager().handleLimitation(aST3, TranslationLimitation.Type.STATEMENT);
        }
    }

    public void insertExecuteStatementLimitation(AST aST) {
        Block block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST, "BEGINBLOCK");
        if (block == null) {
            this.statementLimitation(aST, true);
        }
    }

    public void applyJoinClauseLimitation(AST aST, AST aST2) {
        String string = aST2.getText() + " " + aST.getText();
        this.getHelper().getLimitationManager().handleLimitation(string, aST, TranslationLimitation.Type.CLAUSE);
    }

    public void functionLimitation(AST aST, boolean bl, boolean bl2) {
        Block block;
        if (aST == null) {
            return;
        }
        AST aST2 = aST;
        if (bl2 && ((ExtAST)aST2).getBlock() == null && (block = this.getHelper().getCodeBlockManager().findEnclosingBlock(aST2, "OPERATIONBLOCK")) != null) {
            aST2 = block.getAST();
        }
        if (bl) {
            this.getHelper().getLimitationManager().handleLimitation("::" + aST2.getText(), aST2, TranslationLimitation.Type.FUNCTION);
        } else {
            this.getHelper().getLimitationManager().handleLimitation(aST2, TranslationLimitation.Type.FUNCTION);
        }
    }

    public void aggregateFunctionLimitation(AST aST) {
        int n = aST.getType();
        if (n == 279 || n == 309 || n == 310) {
            this.functionLimitation(aST, false, true);
        }
    }

    public void xmlFunctionLimitation(AST aST, AST aST2) {
        AST aST3;
        String string = "";
        AST aST4 = aST3 = aST;
        while (aST4.getNextSibling() != null) {
            aST4 = aST4.getNextSibling();
        }
        string = string + aST4.getText();
        this.getHelper().getLimitationManager().handleLimitation(string, aST3, aST2, TranslationLimitation.Type.FUNCTION);
    }
}

