/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.migration.parser;

import java.util.Hashtable;
import oracle.dbtools.migration.translation.api.ITranslator;

public class ParserFactory {
    public static final String TSQL_PARSER = "oracle.dbtools.migration.parser.tsql.TSQLParserMain";
    public static final String MSACCESS_PARSER = "oracle.dbtools.migration.parser.msaccess.MSAccessParserMain";
    public static final String MYSQL_PARSER = "oracle.dbtools.migration.parser.mysql.MySQLParserMain";
    public static final String SYBASE_PARSER = "oracle.dbtools.migration.parser.sybase.SybaseParserMain";
    public static final String DB2_PARSER = "oracle.dbtools.migration.parser.db2.Db2ParserMain";
    public static final String TERADATA_PARSER = "oracle.dbtools.migration.teradata.parser.TeradataParserMain";
    private static ParserFactory m_factory;
    private Hashtable<String, Class> m_parserMainMap = new Hashtable();

    private ParserFactory() {
    }

    public static synchronized ParserFactory getInstance() {
        if (m_factory == null) {
            m_factory = new ParserFactory();
        }
        return m_factory;
    }

    private ITranslator newParser(String string) {
        ITranslator iTranslator = null;
        try {
            if (!this.m_parserMainMap.contains(string)) {
                Class<?> clazz = Class.forName(string);
                iTranslator = (ITranslator)clazz.newInstance();
                this.m_parserMainMap.put(string, clazz);
            } else {
                iTranslator = (ITranslator)this.m_parserMainMap.get(string).newInstance();
            }
        }
        catch (Exception exception) {
            iTranslator = null;
        }
        return iTranslator;
    }

    public static ITranslator getParser(String string) {
        return ParserFactory.getInstance().newParser(string);
    }

    public static String getParserString(String string) {
        if (string.toLowerCase().equals("sybase")) {
            return SYBASE_PARSER;
        }
        if (string.toLowerCase().equals("teradata")) {
            return TERADATA_PARSER;
        }
        if (string.toLowerCase().equals("teradata")) {
            return TERADATA_PARSER;
        }
        if (string.toLowerCase().equals("db2")) {
            return DB2_PARSER;
        }
        if (string.toLowerCase().equals("sqlserver")) {
            return TSQL_PARSER;
        }
        if (string.toLowerCase().equals("mysql")) {
            return MYSQL_PARSER;
        }
        if (string.toLowerCase().equals("access")) {
            return MSACCESS_PARSER;
        }
        return "";
    }
}

