/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.logging.Level;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.DatabaseDescriptor;
import oracle.javatools.db.DatabaseFactory;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.sql.NonDeclarativeSQLQuery;
import oracle.javatools.db.sql.SQLParseException;
import oracle.javatools.db.sql.SQLQuery;
import oracle.javatools.db.sql.SQLQueryBuilder;
import oracle.javatools.db.sql.SQLQueryClauseException;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.db.sql.SQLQueryOwner;

public abstract class SQLQueryBuilderFactory {
    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider provider) {
        return this.createBuilderImpl(provider, SQLQueryBuilderFactory.checkDefaultSchema(provider, null));
    }

    public final SQLQueryBuilder createSQLQueryBuilder(DBObjectProvider provider, Schema defaultSchema) {
        defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, defaultSchema);
        return this.createBuilderImpl(provider, defaultSchema);
    }

    protected abstract SQLQueryBuilder createBuilderImpl(DBObjectProvider var1, Schema var2);

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider) {
        return SQLQueryBuilderFactory.createBuilder(provider, (Schema)null);
    }

    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema schema) {
        DatabaseDescriptor dd = provider.getDescriptor();
        SQLQueryBuilderFactory f = dd.getSQLQueryBuilderFactory();
        if (f != null) {
            return f.createSQLQueryBuilder(provider, schema);
        }
        return null;
    }

    private static SQLQueryBuilderFactory getDefaultFactory() {
        try {
            return DatabaseFactory.getDatabaseDescriptor(Class.forName("oracle.javatools.db.ora.Oracle11g")).getSQLQueryBuilderFactory();
        }
        catch (Throwable t) {
            DBLog.getLogger().log(Level.SEVERE, "Couldn't get default SQLQueryBuilderFactory", t);
            return null;
        }
    }

    @Deprecated
    public static SQLQuery createQuery(DBObjectProvider provider, Schema defaultSchema, String sqlText) throws SQLParseException {
        try {
            SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, defaultSchema);
            try {
                builder.buildQuery(sqlText);
            }
            catch (SQLQueryClauseException ce) {
                // empty catch block
            }
            return builder.getSQLQuery();
        }
        catch (SQLQueryException e) {
            if (e instanceof SQLParseException) {
                throw (SQLParseException)e;
            }
            DBLog.log("SQLQueryBuilderFactory cannot build SQL: " + e.getMessage(), new Object[0]);
            return new NonDeclarativeSQLQuery(sqlText);
        }
    }

    @Deprecated
    public static SQLQuery createQuery(DBObjectProvider provider, SQLQueryOwner owner, String sqlText) throws SQLParseException {
        try {
            SQLQueryBuilder builder = SQLQueryBuilderFactory.createBuilder(provider, owner instanceof SchemaObject ? ((SchemaObject)((Object)owner)).getSchema() : null);
            try {
                builder.buildQuery(sqlText, owner);
            }
            catch (SQLQueryClauseException ce) {
                // empty catch block
            }
            return builder.getSQLQuery();
        }
        catch (SQLQueryException e) {
            if (e instanceof SQLParseException) {
                throw (SQLParseException)e;
            }
            DBLog.log("SQLQueryBuilderFactory cannot build SQL: " + e.getMessage(), new Object[0]);
            return new NonDeclarativeSQLQuery(sqlText);
        }
    }

    @Deprecated
    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, SQLQuery query) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(provider, null, query);
    }

    @Deprecated
    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema defaultSchema, SQLQuery query) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromQuery(provider, defaultSchema, query);
    }

    @Deprecated
    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, null, sqlText);
    }

    @Deprecated
    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, Schema defaultSchema, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, defaultSchema, sqlText);
    }

    @Deprecated
    public static SQLQueryBuilder createBuilder(DBObjectProvider provider, SQLQueryOwner owner, String sqlText) throws SQLQueryException {
        return SQLQueryBuilderFactory.createBuilderFromText(provider, owner, sqlText);
    }

    private static SQLQueryBuilder createBuilderFromText(DBObjectProvider provider, DBObject parent, String sqlText) throws SQLQueryException {
        Schema defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, parent);
        SQLQueryOwner owner = parent instanceof SQLQueryOwner ? (SQLQueryOwner)parent : null;
        SQLQueryBuilder builder = SQLQueryBuilderFactory.getDefaultFactory().createSQLQueryBuilder(provider, defaultSchema);
        builder.buildQuery(sqlText, owner);
        return builder;
    }

    private static SQLQueryBuilder createBuilderFromQuery(DBObjectProvider provider, Schema defaultSchema, SQLQuery query) throws SQLQueryException {
        defaultSchema = SQLQueryBuilderFactory.checkDefaultSchema(provider, defaultSchema);
        SQLQueryBuilder builder = SQLQueryBuilderFactory.getDefaultFactory().createSQLQueryBuilder(provider, defaultSchema);
        builder.buildQuery(query);
        return builder;
    }

    private static Schema checkDefaultSchema(DBObjectProvider provider, DBObject parent) {
        Schema defaultSchema = null;
        defaultSchema = parent instanceof Schema ? (Schema)parent : DBUtil.getSchema(parent);
        if (defaultSchema == null && provider != null) {
            try {
                defaultSchema = provider.getDefaultSchema();
            }
            catch (DBException dbe) {
                DBLog.getLogger().log(DBLog.getTraceLogLevel(), "cannot get default schema for sql query building", dbe);
            }
        }
        return defaultSchema;
    }
}

