/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.sql.InvalidSQLException;
import oracle.javatools.parser.plsql.data.PlsqlError;

public class SQLParseException
extends InvalidSQLException {
    protected final String NEWLINE = "\n";
    protected final String SPACE = " ";
    protected final String INDICATOR = DBArb.getString(22);
    private String m_message;
    private PlsqlError[] m_errors;

    public SQLParseException(PlsqlError[] errors) {
        this(errors, null);
    }

    public SQLParseException(PlsqlError[] errors, String query) {
        super(query, (String)null);
        this.m_errors = errors;
    }

    private void createMessage() {
        if (this.m_errors != null && this.m_errors.length > 0) {
            StringBuilder messages = new StringBuilder();
            messages.append(DBArb.getString(21));
            for (int i = 0; i < this.m_errors.length; ++i) {
                messages.append("\n");
                String message = this.m_errors[i].getErrorMessage();
                int offset = this.m_errors[i].getStartOffset();
                String query = this.getSQL();
                if (query != null) {
                    messages.append(DBArb.format(23, message));
                    messages.append("\n");
                    StringBuilder sb = new StringBuilder(query);
                    if (offset > query.length()) {
                        sb.append(this.INDICATOR);
                    } else {
                        sb.insert(offset, this.INDICATOR);
                    }
                    int startOfLine = 0;
                    if (offset > 0) {
                        startOfLine = query.substring(0, offset - 1).lastIndexOf("\n");
                    }
                    int endOfLine = query.indexOf("\n", offset);
                    if (startOfLine < 0) {
                        startOfLine = 0;
                    }
                    if (endOfLine < 0) {
                        endOfLine = query.length();
                    }
                    messages.append(sb.toString().substring(startOfLine, endOfLine += this.INDICATOR.length()).trim());
                    continue;
                }
                messages.append(message);
            }
            this.m_message = messages.toString();
        }
    }

    public String getMessage() {
        if (this.m_message == null) {
            this.createMessage();
        }
        return this.m_message;
    }

    public Integer getOffset() {
        Integer offset = null;
        if (this.m_errors != null && this.m_errors.length > 0 && this.m_errors[0] != null) {
            offset = this.m_errors[0].getStartOffset();
        }
        return offset;
    }
}

