/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class Comparison
extends Operation {
    public static final int GREATER = 1;
    public static final int LESS = 2;
    public static final int GREATER_EQUAL = 3;
    public static final int LESS_EQUAL = 4;
    public static final int EQUAL = 5;
    public static final int NOT_EQUAL = 6;
    public static final int NULL = 43;
    public static final int NOT_NULL = 44;
    public static final int LIKE = 26;
    public static final int NOT_LIKE = 27;
    public static final int EXISTS = 10004;
    public static final int NOT_EXISTS = 10005;
    private static Map s_operators = new HashMap();

    public Comparison() {
        this(null, 5);
    }

    public Comparison(SQLFragment left, int comparator) {
        this(left, comparator, null);
    }

    public Comparison(SQLFragment left, int comparator, SQLFragment right) {
        this.setFunctionFormat(false);
        this.setLeftExpression(left);
        this.setRightExpression(right);
        this.setComparator(comparator);
    }

    public int getComparator() {
        return (Integer)this.getProperty("comparator", 5);
    }

    public String getOperatorText() {
        return Comparison.getComparatorText(this.getComparator());
    }

    public void setComparator(int comparator) {
        if (Comparison.getComparatorText(comparator) == null) {
            throw new IllegalArgumentException(DBArb.format(18, String.valueOf(comparator)));
        }
        this.setProperty("comparator", comparator);
    }

    public SQLFragment getLeftExpression() {
        return (SQLFragment)this.getProperty("leftExpression");
    }

    public void setLeftExpression(SQLFragment leftExpression) {
        this.setProperty("leftExpression", leftExpression);
    }

    public SQLFragment getRightExpression() {
        return (SQLFragment)this.getProperty("rightExpression");
    }

    public void setRightExpression(SQLFragment rightExpression) {
        this.setProperty("rightExpression", rightExpression);
    }

    protected void checkNewSize(int proposedSize) {
        if (proposedSize != 2 && proposedSize != 1) {
            throw new IllegalArgumentException(DBArb.getString(17));
        }
    }

    public String getSQLText() {
        int comp = this.getComparator();
        if (comp == 43 || comp == 44) {
            return this.getTextOrNull(this.getArguments()[0]) + " " + Comparison.getComparatorText(comp);
        }
        if (comp == 10004 || comp == 10005) {
            return Comparison.getComparatorText(comp) + " " + this.getTextOrNull(this.getArguments()[0], true);
        }
        return super.getSQLText();
    }

    public void addArgument(int index, SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public void addArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public void addArguments(SQLFragment[] expressions) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public int getArgumentCount() {
        return this.getRightExpression() == null ? 1 : 2;
    }

    @Transient
    public void setArguments(SQLFragment[] arguments) {
        if (arguments != null && arguments.length > 0) {
            this.setLeftExpression(arguments[0]);
            if (arguments.length > 1) {
                this.setRightExpression(arguments[1]);
            }
        }
    }

    public boolean removeArgument(SQLFragment expression) {
        throw new UnsupportedOperationException("Comparison: use left/right expression");
    }

    public SQLFragment[] getArguments() {
        return new SQLFragment[]{this.getLeftExpression(), this.getRightExpression()};
    }

    public static boolean isComparator(int op) {
        return s_operators.containsKey(new Integer(op));
    }

    public static String getComparatorText(int op) {
        return (String)s_operators.get(new Integer(op));
    }

    static {
        s_operators.put(new Integer(1), ">");
        s_operators.put(new Integer(2), "<");
        s_operators.put(new Integer(3), ">=");
        s_operators.put(new Integer(4), "<=");
        s_operators.put(new Integer(5), "=");
        s_operators.put(new Integer(6), "!=");
        s_operators.put(new Integer(43), "IS NULL");
        s_operators.put(new Integer(44), "IS NOT NULL");
        s_operators.put(new Integer(26), "LIKE");
        s_operators.put(new Integer(27), "NOT LIKE");
        s_operators.put(new Integer(10004), "EXISTS");
        s_operators.put(new Integer(10005), "NOT EXISTS");
    }
}

