/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractDBObjectUsage;
import oracle.javatools.db.sql.FromObject;

public class ColumnUsage
extends AbstractDBObjectUsage {
    private boolean m_alwaysQuote;

    public ColumnUsage() {
        this((DBObjectID)null, (FromObject)null);
    }

    public ColumnUsage(DBObjectID colID) {
        this(colID, (FromObject)null);
    }

    public ColumnUsage(DBObjectID colID, FromObject from) {
        super(colID, from != null ? from.getID() : null);
        this.setOuterJoin(false);
    }

    @Deprecated
    public void setColumnID(DBObjectID colID) {
        if (colID != null) {
            this.setObjectID(colID);
        }
    }

    public String[] getAttributes() {
        return this.getChildSupport("attributes").getChildArray(String.class);
    }

    public void setAttributes(String[] attrs) {
        this.getChildSupport("attributes").setChildArray(attrs);
    }

    public void setOuterJoin(boolean oj) {
        this.setProperty("outerJoin", oj);
    }

    public boolean isOuterJoin() {
        return (Boolean)this.getProperty("outerJoin", false);
    }

    public String getSQLText() {
        StringBuilder buff = this.getSQLTextImpl();
        if (this.m_alwaysQuote && !buff.toString().startsWith("\"")) {
            buff = buff.insert(0, "\"");
            buff = buff.append("\"");
        }
        for (String attr : this.getAttributes()) {
            buff.append(".").append(attr);
        }
        if (this.isOuterJoin()) {
            buff.append("(+)");
        }
        return buff.toString();
    }

    @Transient
    public void setAlwaysQuote(boolean boo) {
        this.m_alwaysQuote = boo;
    }
}

