/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.sql.Operation;
import oracle.javatools.db.sql.SQLFragment;

public class ArithmeticOperation
extends Operation {
    public static final int ADD = 10;
    public static final int SUBTRACT = 11;
    public static final int MULTIPLY = 12;
    public static final int DIVIDE = 13;
    public static final int NEGATE = 14;
    private static Map s_arithmetic = new HashMap();
    private static HashMap<Integer, Integer> s_operatorPrecedence;

    public ArithmeticOperation() {
        this(10, null);
    }

    public ArithmeticOperation(int operator, SQLFragment[] args) {
        this.setArguments(args);
        this.setOperator(operator);
        this.setFunctionFormat(false);
    }

    public int getOperator() {
        return (Integer)this.getProperty("operator", 10);
    }

    public void setOperator(int operator) {
        if (!ArithmeticOperation.isArithmeticOperation(operator)) {
            throw new IllegalArgumentException(DBArb.format(16, String.valueOf(operator)));
        }
        this.setProperty("operator", operator);
        this.setCommutative(operator == 10 || operator == 12);
    }

    public String getSQLText() {
        if (14 == this.getOperator()) {
            return this.getOperatorText() + this.getArguments()[0].getSQLText();
        }
        int op = this.getOperator();
        StringBuilder retval = new StringBuilder();
        SQLFragment[] args = this.getArguments();
        Integer precedence = s_operatorPrecedence.get(op);
        if (precedence == null) {
            precedence = 0;
        }
        for (int i = 0; i < args.length; ++i) {
            boolean addBrackets = false;
            if (args[i] instanceof ArithmeticOperation) {
                int subOp = ((ArithmeticOperation)args[i]).getOperator();
                Integer subExprPrec = s_operatorPrecedence.get(subOp);
                if (subExprPrec == null) {
                    subExprPrec = 1000;
                }
                if (subExprPrec < precedence || i > 0 && subExprPrec == precedence && op != subOp && (op == 11 || op == 13)) {
                    addBrackets = true;
                }
            }
            String argText = this.getTextOrNull(args[i]);
            if (addBrackets) {
                argText = this.surroundWithBrackets(argText, true);
            }
            retval.append(argText);
            if (i >= args.length - 1) continue;
            retval.append(" ");
            retval.append(this.getOperatorText());
            retval.append(" ");
        }
        return retval.toString();
    }

    public String getOperatorText() {
        return ArithmeticOperation.getArithmeticOperation(this.getOperator());
    }

    protected boolean equalsImpl(AbstractDBObject target) {
        ArithmeticOperation other = (ArithmeticOperation)target;
        boolean reallyEqual = super.equalsImpl(other);
        if (reallyEqual) {
            return true;
        }
        int op = this.getOperator();
        if (other.getOperator() == op && this.getArgumentCount() == 2 && other.getArgumentCount() == 2 && (op == 10 || op == 12)) {
            return this.getArguments()[0].equals(other.getArguments()[1]) && this.getArguments()[1].equals(other.getArguments()[0]);
        }
        return false;
    }

    public static boolean isArithmeticOperation(int operandType) {
        return s_arithmetic.containsKey(new Integer(operandType));
    }

    public static String getArithmeticOperation(int operandType) {
        return (String)s_arithmetic.get(new Integer(operandType));
    }

    static {
        s_arithmetic.put(new Integer(10), "+");
        s_arithmetic.put(new Integer(11), "-");
        s_arithmetic.put(new Integer(12), "*");
        s_arithmetic.put(new Integer(13), "/");
        s_arithmetic.put(new Integer(14), "-");
        s_operatorPrecedence = new HashMap();
        s_operatorPrecedence.put(11, 1);
        s_operatorPrecedence.put(10, 1);
        s_operatorPrecedence.put(12, 2);
        s_operatorPrecedence.put(13, 2);
        s_operatorPrecedence.put(14, 3);
    }
}

