/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.sql;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.property.Transient;
import oracle.javatools.db.sql.AbstractSQLFragment;
import oracle.javatools.db.sql.AliasFragment;
import oracle.javatools.db.sql.SQLFragment;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.util.ModelUtil;

public abstract class AbstractAliasFragment
extends AbstractSQLFragment
implements AliasFragment {
    protected AbstractAliasFragment() {
    }

    protected AbstractAliasFragment(SQLFragment exp, String alias) {
        this.setExpression(exp);
        this.setAlias(alias);
    }

    public String getAlias() {
        return (String)this.getProperty("alias");
    }

    public void setAlias(String alias) {
        if (this.canHaveAlias()) {
            this.setProperty("alias", alias);
        } else if (ModelUtil.hasLength((String)alias)) {
            DBLog.logStackTrace(new SQLQueryException(DBArb.format(52, this.getExpression().getSQLText())));
        }
    }

    public boolean canHaveAlias() {
        return true;
    }

    public SQLFragment getExpression() {
        return (SQLFragment)this.getProperty("expression");
    }

    public void setExpression(SQLFragment expression) {
        this.setProperty("expression", expression);
        if (!this.canHaveAlias()) {
            this.setAlias(null);
        }
    }

    public String getSQLText() {
        SQLFragment expression = this.getExpression();
        String alias = this.getAlias();
        StringBuilder sql = new StringBuilder();
        sql.append(this.getTextOrNull(expression));
        if (ModelUtil.hasLength((String)alias)) {
            if (this.useAsBeforeAlias()) {
                sql.append(" AS");
            }
            sql.append(" ").append(alias);
        }
        return sql.toString();
    }

    protected boolean useAsBeforeAlias() {
        return false;
    }

    @Deprecated
    public String getUsableAlias() {
        return this.getName();
    }

    @Transient
    public String getName() {
        String alias = this.getAlias();
        if (ModelUtil.hasLength((String)alias)) {
            return alias;
        }
        SQLFragment expression = this.getExpression();
        return expression == null ? null : expression.getSQLText();
    }

    @Transient
    public void setName(String name) {
    }

    protected boolean canUseAsAlias(String exp) {
        return exp.indexOf(" ") <= -1 && exp.indexOf(".") <= -1;
    }

    public String toString() {
        String retval;
        SQLFragment expression = this.getExpression();
        String alias = this.getAlias();
        String string = retval = expression == null ? null : expression.toString();
        if (ModelUtil.hasLength((String)alias)) {
            retval = alias + " " + "(" + retval + ")";
        }
        return retval;
    }
}

