/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.MetadataImpl;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.Transient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyIterator {
    private Class m_objClass;
    private Class<? extends DBObjectProvider> m_proClass;

    public PropertyIterator(Class objClass, Class<? extends DBObjectProvider> proClass) {
        if (objClass == null) {
            throw new IllegalArgumentException("object class cannot be null");
        }
        this.m_objClass = objClass;
        this.m_proClass = proClass;
    }

    public Iterator<PropertyInfo> getPropertyIterator() {
        return this.getPropertyIterator(true, true, true);
    }

    public Iterator<PropertyInfo> getPropertyIterator(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        Map<String, PropertyInfo> infos = this.getPropertyInfos(excludeTransientGet, excludeTransientSet, beanOnly);
        TreeSet<PropertyInfo> propertyDescs = new TreeSet<PropertyInfo>();
        if (infos != null) {
            propertyDescs.addAll(infos.values());
        }
        return propertyDescs.iterator();
    }

    public Map<String, PropertyInfo> getPropertyInfos() {
        return this.getPropertyInfos(true, true, true);
    }

    public Map<String, PropertyInfo> getPropertyInfos(boolean excludeTransientGet, boolean excludeTransientSet, boolean beanOnly) {
        HashMap<String, PropertyInfo> props = new HashMap<String, PropertyInfo>();
        Metadata m = Metadata.getInstance();
        Collection<String> beanProps = m.getMetadata().getProperties(this.m_objClass);
        if (beanProps == null) {
            BeanInfo bi = MetadataImpl.getBeanInfo(this.m_objClass);
            if (bi != null) {
                for (PropertyDescriptor desc : bi.getPropertyDescriptors()) {
                    this.addPropIfMatches(desc, props, excludeTransientGet, excludeTransientSet);
                }
            }
        } else {
            for (String propName : beanProps) {
                try {
                    PropertyDescriptor desc = new PropertyDescriptor(propName, this.m_objClass);
                    this.addPropIfMatches(desc, props, excludeTransientGet, excludeTransientSet);
                }
                catch (IntrospectionException ie) {
                    DBLog.getLogger(this).log(Level.WARNING, "Bad or missing bean property {0} on {1}", new Object[]{propName, this.m_objClass.getName()});
                }
            }
        }
        if (!beanOnly) {
            Map<String, PropertyDefinition> extraProps = m.getMetadata().getExtraProps();
            for (Map.Entry<String, PropertyDefinition> entry : extraProps.entrySet()) {
                PropertyDefinition def = entry.getValue();
                if (!def.matches(this.m_proClass, this.m_objClass)) continue;
                String name = entry.getKey();
                if (!props.containsKey(name)) {
                    props.put(name, def);
                    continue;
                }
                boolean i = false;
            }
        }
        return props;
    }

    private void addPropIfMatches(PropertyDescriptor desc, Map<String, PropertyInfo> props, boolean excludeTransientGet, boolean excludeTransientSet) {
        if (this.isBeanalicious(desc, excludeTransientGet, excludeTransientSet)) {
            props.put(desc.getName(), new PropertyInfo.DescriptorInfo(desc));
        }
    }

    private boolean isBeanalicious(PropertyDescriptor prop, boolean excludeTransientGet, boolean excludeTransientSet) {
        return this.isBeanalicious(prop.getReadMethod(), excludeTransientGet) && this.isBeanalicious(prop.getWriteMethod(), excludeTransientSet);
    }

    private boolean isBeanalicious(Method method, boolean excludeTransient) {
        if (method != null) {
            try {
                if (method.isAnnotationPresent(Transient.class)) {
                    boolean debug = false;
                }
                return !method.isAnnotationPresent(Transient.class) || !excludeTransient;
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Object bean) {
        return PropertyIterator.getPropertyInfos(bean.getClass());
    }

    public static Map<String, PropertyInfo> getPropertyInfos(Class beanClass) {
        PropertyIterator iter = new PropertyIterator(beanClass, null);
        return iter.getPropertyInfos();
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Object bean) {
        return PropertyIterator.getPropertyIterator(bean.getClass());
    }

    public static Iterator<PropertyInfo> getPropertyIterator(Class beanClz) {
        PropertyIterator iter = new PropertyIterator(beanClz, null);
        return iter.getPropertyIterator();
    }
}

