/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.property.After;
import oracle.javatools.db.property.References;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

public abstract class PropertyInfo
implements Comparable {
    public static final String ID = "ID";
    public static final String NAME = "name";

    public abstract String getPropertyName();

    public abstract String getPropertyPath();

    public abstract Class getPropertyClass();

    public abstract Object getPropertyValue(Object var1);

    public abstract void setPropertyValue(Object var1, Object var2) throws Exception;

    public Class getReferencedClass() {
        Class<?> clz = this.getPropertyClass();
        if (clz.isArray()) {
            clz = clz.getComponentType();
        }
        if (DBObjectID.class.isAssignableFrom(clz)) {
            return DBObject.class;
        }
        return null;
    }

    public boolean isInternalReference() {
        return false;
    }

    public abstract boolean isGetTransient();

    public abstract boolean isSetTransient();

    public boolean isTransient() {
        return this.isGetTransient() || this.isSetTransient();
    }

    protected abstract boolean isAfter();

    public int compareTo(Object o) {
        boolean thatAfter;
        if (o == null) {
            return 1;
        }
        PropertyInfo info = (PropertyInfo)o;
        if (this.equalsImpl(info)) {
            return 0;
        }
        String name = this.getPropertyName();
        String otherName = info.getPropertyName();
        if (name.equals(ID) && !otherName.equals(ID)) {
            return -100;
        }
        if (otherName.equals(ID)) {
            return 100;
        }
        if (name.equals(NAME) && !otherName.equals(NAME)) {
            return -50;
        }
        if (otherName.equals(NAME)) {
            return 50;
        }
        boolean thisAfter = this.isAfter();
        if (thisAfter == (thatAfter = info.isAfter())) {
            return name.compareTo(otherName);
        }
        return thisAfter ? 100 : -100;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((PropertyInfo)o);
    }

    protected abstract boolean equalsImpl(PropertyInfo var1);

    public boolean isStaticReference() {
        return false;
    }

    static boolean hasAnnotation(Method method, Class annotation) {
        if (method != null) {
            try {
                return method.isAnnotationPresent(annotation);
            }
            catch (Error e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    static class DescriptorInfo
    extends PropertyInfo {
        private final PropertyDescriptor m_desc;
        private Boolean m_isAfter;
        private Boolean m_isGetTransient;
        private Boolean m_isSetTransient;

        DescriptorInfo(PropertyDescriptor desc) {
            this.m_desc = desc;
        }

        public String getPropertyName() {
            return this.m_desc.getName();
        }

        public String getPropertyPath() {
            return this.getPropertyName();
        }

        public Class getPropertyClass() {
            return this.m_desc.getPropertyType();
        }

        public boolean isGetTransient() {
            if (this.m_isGetTransient == null) {
                this.m_isGetTransient = DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), Transient.class);
            }
            return this.m_isGetTransient;
        }

        public boolean isSetTransient() {
            if (this.m_isSetTransient == null) {
                this.m_isSetTransient = DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), Transient.class);
            }
            return this.m_isSetTransient;
        }

        public boolean isAfter() {
            if (this.m_isAfter == null) {
                this.m_isAfter = this.hasAnnotation(After.class);
            }
            return this.m_isAfter;
        }

        public Object getPropertyValue(Object owningObject) {
            try {
                return this.m_desc.getReadMethod().invoke(owningObject, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }

        public void setPropertyValue(Object owningObject, Object value) throws Exception {
            Object[] args = new Object[]{value};
            this.m_desc.getWriteMethod().invoke(owningObject, args);
        }

        protected boolean equalsImpl(PropertyInfo info) {
            return info instanceof DescriptorInfo && ModelUtil.areEqual((Object)this.m_desc, (Object)((DescriptorInfo)info).m_desc);
        }

        private boolean hasAnnotation(Class annotation) {
            return DescriptorInfo.hasAnnotation(this.m_desc.getReadMethod(), annotation) || DescriptorInfo.hasAnnotation(this.m_desc.getWriteMethod(), annotation);
        }

        public boolean isInternalReference() {
            References refInfo = this.m_desc.getReadMethod().getAnnotation(References.class);
            if (refInfo == null) {
                return super.isInternalReference();
            }
            return refInfo.internal();
        }

        public Class getReferencedClass() {
            References refInfo = this.m_desc.getReadMethod().getAnnotation(References.class);
            if (refInfo == null) {
                return super.getReferencedClass();
            }
            return refInfo.value();
        }
    }
}

