/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyDefinition;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MetadataImpl {
    static final String LIST_FILE_NAME = "beans.bin";
    static final String PROPS_FILE_NAME = "props.bin";
    private Collection<Class<? extends Copyable>> m_beans;
    private Map<String, Class<? extends DBObject>> m_typeMap;
    private MultiMap<Class<? extends DBObject>, Class<? extends DBObject>> m_implementations;
    private Map<String, Collection<Class<? extends Copyable>>> m_props;
    private Map<Class<? extends Copyable>, Collection<String>> m_beanProps;
    private Map<String, PropertyDefinition> m_extraProps;

    MetadataImpl() {
        Class[] beans = null;
        Object obj = this.openFile(LIST_FILE_NAME);
        if (obj instanceof Class[]) {
            beans = (Class[])obj;
        }
        if (beans == null) {
            DBLog.getLogger().severe("Could not open DBObject list file.");
            beans = new Class[]{};
        }
        this.m_beans = new ArrayList<Class<? extends Copyable>>();
        for (Class clz : beans) {
            this.m_beans.add(clz);
        }
        Object obj2 = this.openFile(PROPS_FILE_NAME);
        if (obj2 instanceof Map) {
            this.m_extraProps = (Map)obj2;
        }
        if (this.m_extraProps == null) {
            DBLog.getLogger().severe("Could not open property definitions file.");
            this.m_extraProps = new HashMap<String, PropertyDefinition>();
        }
    }

    MetadataImpl(Collection<Class<? extends Copyable>> beans) {
        this.m_beans = beans;
    }

    private Object openFile(String fileName) {
        InputStream is = this.getClass().getResourceAsStream(fileName);
        if (is != null) {
            try {
                ObjectInputStream ois = new ObjectInputStream(is);
                return ois.readObject();
            }
            catch (IOException ioe) {
                DBLog.getLogger().log(Level.SEVERE, "Error opening " + fileName, ioe);
            }
            catch (ClassNotFoundException cnfe) {
                DBLog.getLogger().log(Level.SEVERE, "Error opening " + fileName, cnfe);
            }
        }
        return null;
    }

    public Collection<Class<? extends Copyable>> getBeans() {
        return this.m_beans;
    }

    public Map<String, PropertyDefinition> getExtraProps() {
        return this.m_extraProps;
    }

    public Map<String, Class<? extends DBObject>> getTypeMap() {
        this.initProps();
        return this.m_typeMap;
    }

    public Collection<Class<? extends DBObject>> getImpementations(Class<? extends DBObject> clz) {
        this.initProps();
        return this.m_implementations.get(clz);
    }

    public Collection<Class<? extends Copyable>> getBeans(String prop) {
        this.initProps();
        return this.m_props.get(prop);
    }

    public Collection<String> getProperties(Class<? extends Copyable> clz) {
        this.initProps();
        return this.m_beanProps.get(clz);
    }

    public Collection<String> getAllProperties() {
        this.initProps();
        return Collections.unmodifiableCollection(this.m_props.keySet());
    }

    private synchronized void initProps() {
        if (this.m_props == null) {
            this.m_props = new TreeMap<String, Collection<Class<? extends Copyable>>>();
            this.m_beanProps = new HashMap<Class<? extends Copyable>, Collection<String>>();
            this.m_typeMap = new TreeMap<String, Class<? extends DBObject>>();
            this.m_implementations = new MultiMap();
            for (Class<? extends Copyable> clz : this.getBeans()) {
                this.registerClassProperties(clz);
            }
        }
    }

    void registerClass(Class<? extends Copyable> clz) {
        this.initProps();
        this.m_beans.add(clz);
        this.registerClassProperties(clz);
    }

    private void registerClassProperties(Class<? extends Copyable> clz) {
        if (DBObject.class.isAssignableFrom(clz)) {
            String type = Metadata.getType(clz);
            String declaredType = null;
            try {
                Field f = clz.getDeclaredField("TYPE");
                if (f != null) {
                    declaredType = (String)f.get(null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (ModelUtil.hasLength((String)type)) {
                if (ModelUtil.hasLength(declaredType)) {
                    if (this.m_typeMap.containsKey(type)) {
                        DBLog.getLogger(this).log(Level.WARNING, "Type \"{0}\" is already registered to \"{1}\"", new Object[]{type, this.m_typeMap.get(type)});
                    } else {
                        this.m_typeMap.put(type, clz);
                    }
                } else {
                    DBLog.getLogger(this).log(Level.FINE, "Type \"{0}\" is not declared on {1}", new Object[]{type, clz});
                }
            }
            for (Class<? extends Copyable> bean : this.getBeans()) {
                if (!bean.isAssignableFrom(clz) || !DBObject.class.isAssignableFrom(bean)) continue;
                this.m_implementations.add(bean, clz);
            }
        }
        if (Metadata.isRealBean(clz)) {
            BeanInfo bi = MetadataImpl.getBeanInfo(clz);
            if (bi == null) {
                System.err.println("Error getting bean info for: " + clz.getName());
            } else {
                ArrayList<String> beanPropsForObj = new ArrayList<String>();
                for (PropertyDescriptor desc : bi.getPropertyDescriptors()) {
                    Method mr = desc.getReadMethod();
                    Method mw = desc.getWriteMethod();
                    if (mr == null || mw == null) continue;
                    String name = desc.getName();
                    beanPropsForObj.add(name);
                    Collection<Class<? extends Copyable>> clzs = this.m_props.get(name);
                    if (clzs == null) {
                        clzs = new ArrayList<Class<? extends Copyable>>();
                        this.m_props.put(name, clzs);
                    }
                    clzs.add(clz);
                }
                this.m_beanProps.put(clz, beanPropsForObj);
            }
        } else if (DBObject.class.isAssignableFrom(clz)) {
            for (Class<? extends Copyable> bean : this.getBeans()) {
                if (clz == bean || !clz.isAssignableFrom(bean)) continue;
                this.m_implementations.add(clz, bean);
            }
        }
    }

    static BeanInfo getBeanInfo(Class beanClass) {
        if (beanClass != null) {
            try {
                return Introspector.getBeanInfo(beanClass, 3);
            }
            catch (IntrospectionException e) {
                e.printStackTrace();
            }
        }
        return null;
    }
}

