/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.property;

import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.diff.DiffEngine;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.Metadata;
import oracle.javatools.db.property.PropertyAction;
import oracle.javatools.db.property.PropertyHelper;
import oracle.javatools.db.property.PropertyManager;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyManager
implements PropertyManager {
    private DBObjectProvider m_pro;
    private Metadata m_meta = Metadata.getInstance();

    protected AbstractPropertyManager(DBObjectProvider pro) {
        this.m_pro = pro;
    }

    protected Logger getLogger() {
        return DBLog.getLogger(this);
    }

    protected DBObjectProvider getProvider() {
        return this.m_pro;
    }

    protected Class<? extends DBObjectProvider> getProviderClass() {
        DBObjectProvider pro = this.getProvider();
        return pro == null ? null : pro.getClass();
    }

    @Override
    public boolean supportsProperty(String type, String prop) {
        return this.supportsProperty(type, prop, this.getProviderClass()) && this.canCreate(type, prop);
    }

    protected boolean supportsProperty(String type, String prop, Class<? extends DBObjectProvider> proClz) {
        return PropertyHelper.findPropertyInfo(type, prop, proClz) != null;
    }

    @Override
    public final boolean canAlterProperty(DBObject original, DBObject update, String prop) {
        boolean retval = false;
        PropertyAction action = this.canChangeProperty(original, update, prop);
        if (action != null) {
            retval = action.getType() == PropertyAction.Type.ALTER;
        }
        return retval;
    }

    @Override
    public final PropertyAction canChangeProperty(DBObject original, DBObject update, String prop) {
        if (this.supportsProperty(update.getType(), prop)) {
            if (original == null) {
                if (this.canCreate(update, prop)) {
                    return new PropertyAction(PropertyAction.Type.CREATE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for CREATE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            } else {
                if (this.canChangeWithAlter(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: can ALTER on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return new PropertyAction(PropertyAction.Type.ALTER);
                }
                if (this.canChangeWithReplace(original, update, prop)) {
                    this.getLogger().log(Level.FINEST, "Property {0}: cannot ALTER but can REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
                    return new PropertyAction(PropertyAction.Type.REPLACE);
                }
                this.getLogger().log(Level.FINEST, "Property {0}: not supported for ALTER or REPLACE on {1} {2}", new Object[]{prop, update.getType(), update.getName()});
            }
        }
        return null;
    }

    protected boolean canCreate(DBObject newObj, String prop) {
        return this.canCreate(newObj.getType(), prop);
    }

    protected boolean canCreate(String type, String prop) {
        return true;
    }

    protected boolean canChangeWithAlter(DBObject orig, DBObject update, String prop) {
        return false;
    }

    protected boolean canChangeWithReplace(DBObject orig, DBObject update, String prop) {
        String type = update.getType();
        return (this.supportsAction(type, PropertyAction.Type.REPLACE) || this.supportsAction(type, PropertyAction.Type.DELETE)) && this.canCreate(update, prop);
    }

    @Override
    public final PropertyAction canUpdateObject(DBObject orig, DBObject update) {
        DiffEngine de;
        PropertyAction retval = null;
        DBObjectProvider pro = this.getProvider();
        if (pro != null && (de = this.getProvider().getDiffEngine()) != null) {
            ResultSet rs = de.diff(orig, update).getResult();
            retval = this.canUpdateObject(rs);
        }
        return retval;
    }

    @Override
    public final PropertyAction canUpdateObject(Difference rs) {
        DBObject orig = (DBObject)rs.getOriginalObject();
        DBObject update = (DBObject)rs.getUpdatedObject();
        PropertyAction retval = new PropertyAction(orig == null ? PropertyAction.Type.CREATE : PropertyAction.Type.ALTER);
        if (rs.isModified()) {
            Collection<? extends Difference> diffs = rs.getChildren();
            retval = this.processDiffs(orig, update, diffs, null, retval);
        }
        return retval;
    }

    private PropertyAction processDiffs(DBObject orig, DBObject update, Collection<? extends Difference> diffs, String parentPropPath, PropertyAction retval) {
        for (Difference difference : diffs) {
            String fullPropPath;
            if (difference.isSame()) continue;
            if (retval == null) break;
            if (difference.isSame()) continue;
            String propName = difference.getPropertyName();
            String string = fullPropPath = ModelUtil.hasLength((String)parentPropPath) ? parentPropPath + "/" + propName : propName;
            if (difference.isMap()) {
                retval = this.processDiffs(orig, update, difference.getChildren(), fullPropPath, retval);
                continue;
            }
            PropertyAction action = this.canChangeProperty(orig, update, fullPropPath);
            if (action == null) {
                this.getLogger().log(Level.WARNING, "Unsupported property: " + fullPropPath);
                retval = null;
                continue;
            }
            if (retval.getType() != action.getType() && retval.getType() == PropertyAction.Type.ALTER) {
                retval = action;
            }
            if (retval.getType() != action.getType()) continue;
            retval.addProperty(fullPropPath);
        }
        return retval;
    }
}

