/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.plsql;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Relation;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SourceObject;
import oracle.javatools.db.TemporaryObjectID;
import oracle.javatools.db.Trigger;
import oracle.javatools.db.ValidationException;
import oracle.javatools.db.plsql.PlSqlDeclarator;
import oracle.javatools.db.plsql.PlSqlFragment;
import oracle.javatools.db.plsql.PlSqlInterrogator;
import oracle.javatools.db.plsql.PlSqlToken;
import oracle.javatools.util.ModelUtil;

public class TriggerDeclarator
extends PlSqlDeclarator {
    public TriggerDeclarator(DBObjectProvider pr) {
        super(pr);
    }

    public void loadDeclarativeInfo(SourceObject obj) {
        super.loadDeclarativeInfo(obj);
        Trigger trigger = (Trigger)obj;
        String code = null;
        ArrayList<String> events = new ArrayList<String>();
        String refOldAs = null;
        String refNewAs = null;
        Trigger.Timing timing = null;
        String whenClause = null;
        boolean statementLevel = true;
        PlSqlInterrogator pi = trigger.getSourceInterrogator();
        if (pi == null) {
            DBLog.getLogger().log(DBLog.getTraceLogLevel(), "BUG6189001 TriggerDeclarator.loadDeclarativeInfo pi == null");
        }
        String name = pi.getName();
        String schemaName = this.m_prv.getInternalName(pi.getSchemaName());
        if (schemaName != null) {
            Schema schema = null;
            try {
                schema = this.m_prv.getSchema(schemaName);
            }
            catch (DBException e) {
                // empty catch block
            }
            if (schema == null) {
                schema = new Schema(schemaName);
            }
            trigger.setSchema(schema);
        }
        trigger.setName(this.m_prv.getInternalName(name));
        try {
            this.extractReferences(trigger, extractMode.DECLARATOR);
        }
        catch (ValidationException e) {
            // empty catch block
        }
        ArrayList frags = this.getFragList(pi.getRoot());
        block12: for (int i = 0; i < frags.size(); ++i) {
            PlSqlFragment frag = (PlSqlFragment)frags.get(i);
            switch (frag.getFramentType()) {
                case TRIGGER_TIMING: {
                    if (frag.getFirstToken().matches("BEFORE")) {
                        timing = Trigger.Timing.BEFORE;
                        continue block12;
                    }
                    if (frag.getFirstToken().matches("AFTER")) {
                        timing = Trigger.Timing.AFTER;
                        continue block12;
                    }
                    if (!frag.getFirstToken().matches("INSTEAD")) continue block12;
                    timing = Trigger.Timing.INSTEAD_OF;
                    continue block12;
                }
                case TRIGGER_EVENTS: {
                    PlSqlToken tk;
                    String eventName = "";
                    for (tk = frag.getFirstToken(); tk != null && tk.getStart() <= frag.getLastToken().getStart(); tk = tk.getNextCodeToken()) {
                        if (tk.matches("UPDATE") && tk.getNextCodeToken().matches("OF")) {
                            eventName = tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                            while (tk != frag.getLastToken() && !tk.getNextCodeToken().matches("OR")) {
                                tk = tk.getNextCodeToken();
                            }
                            continue;
                        }
                        if (tk == frag.getLastToken() || tk.getNextCodeToken().matches("OR")) {
                            eventName = eventName + tk.getSource().toUpperCase();
                            events.add(eventName);
                            eventName = "";
                            continue;
                        }
                        if (tk.matches("OR")) continue;
                        eventName = eventName + tk.getSource().toUpperCase() + " ";
                    }
                    continue block12;
                }
                case TRIGGER_REFERENCING: {
                    PlSqlToken tk = frag.getFirstToken();
                    while (tk.getStart() <= frag.getLastToken().getStart() && tk.getNextCodeToken(2) != null) {
                        if (tk.matches("OLD") && tk.getNextCodeToken().matches("AS")) {
                            tk = tk.getNextCodeToken().getNextCodeToken();
                            refOldAs = tk.getSource();
                        } else if (tk.matches("NEW") && tk.getNextCodeToken().matches("AS")) {
                            tk = tk.getNextCodeToken().getNextCodeToken();
                            refNewAs = tk.getSource();
                        }
                        tk = tk.getNextCodeToken();
                    }
                    continue block12;
                }
                case TRIGGER_ROW_LEVEL: {
                    statementLevel = false;
                    continue block12;
                }
                case TRIGGER_WHEN: {
                    PlSqlFragment whenFrag = new PlSqlFragment(pi);
                    whenFrag.setFirstToken(frag.getFirstToken().getNextToken());
                    whenFrag.setLastToken(frag.getLastToken().getPrevToken());
                    whenClause = whenFrag.getSource();
                    continue block12;
                }
                case PLSQL_BLOCK: {
                    code = trigger.getSource().substring(frag.getFirstToken().getStart());
                }
            }
        }
        trigger.setCode(code);
        trigger.setEvents(events.toArray(new String[events.size()]));
        trigger.setReferencingOldAs(refOldAs);
        trigger.setReferencingNewAs(refNewAs);
        trigger.setStatementLevel(statementLevel);
        trigger.setTiming(timing);
        trigger.setWhenClause(whenClause);
    }

    private void extractReferences(Trigger trigger, extractMode mode) throws ValidationException {
        PlSqlToken tk;
        PlSqlFragment frag;
        int i;
        PlSqlInterrogator pi = trigger.getSourceInterrogator();
        Trigger.BaseType baseType = null;
        Schema baseSchema = null;
        DBObjectID tableID = null;
        ArrayList<DBObjectID> columnIDs = new ArrayList<DBObjectID>();
        String errors = "";
        ArrayList frags = this.getFragList(pi.getRoot());
        String tableName = null;
        Relation rel = null;
        for (i = 0; i < frags.size(); ++i) {
            Column c;
            frag = (PlSqlFragment)frags.get(i);
            if (frag.getFramentType() != PlSqlFragment.Type.TRIGGER_TABLE) continue;
            String nestedTableToCheck = null;
            baseType = null;
            tk = frag.getFirstToken();
            if (tk.matches("NESTED")) {
                tk = tk.getNextCodeToken(2);
                nestedTableToCheck = this.m_prv.getInternalName(tk.getSource());
                tk = tk.getNextCodeToken(2);
            }
            if (tk.getNextCodeToken() != null && tk.getNextCodeToken().matches(".")) {
                try {
                    baseSchema = this.m_prv.getSchema(this.m_prv.getInternalName(tk.getSource()));
                }
                catch (DBException e) {
                    baseSchema = trigger.getSchema();
                }
                tk = tk.getNextCodeToken(2);
            } else {
                baseSchema = trigger.getSchema();
            }
            if (tk.matches("SCHEMA")) {
                baseType = Trigger.BaseType.SCHEMA;
                continue;
            }
            if (tk.matches("DATABASE")) {
                baseType = Trigger.BaseType.DATABASE;
                continue;
            }
            tableName = this.m_prv.getInternalName(tk.getSource());
            try {
                rel = (Relation)this.m_prv.getObject("TABLE", baseSchema, tableName);
                if (rel != null) {
                    baseType = Trigger.BaseType.TABLE;
                    tableID = rel.getID();
                } else {
                    rel = (Relation)this.m_prv.getObject("VIEW", baseSchema, tableName);
                    if (rel != null) {
                        baseType = Trigger.BaseType.VIEW;
                        tableID = rel.getID();
                    } else {
                        tableID = null;
                    }
                }
            }
            catch (DBException e) {
                try {
                    rel = (Relation)this.m_prv.getObject("VIEW", baseSchema, tableName);
                    baseType = Trigger.BaseType.VIEW;
                    tableID = rel.getID();
                }
                catch (DBException e2) {
                    tableID = null;
                }
            }
            if (tableID == null && trigger.getTableID() instanceof TemporaryObjectID) {
                tableID = trigger.getTableID();
                DBObject obj = null;
                try {
                    obj = tableID.resolveID();
                }
                catch (DBException e) {
                    obj = null;
                }
                if (obj != null && obj.getName().equals(tableName) && ("TABLE".equals(obj.getType()) || "VIEW".equals(obj.getType()))) {
                    rel = (Relation)obj;
                } else {
                    tableID = null;
                }
            }
            if (tableID == null) {
                errors = errors + "\n" + MessageFormat.format(DBArb.getString(344), tableName);
                continue;
            }
            if (nestedTableToCheck == null || (c = rel.getColumn(nestedTableToCheck)) != null) continue;
            errors = errors + "\n" + MessageFormat.format(DBArb.getString(351), nestedTableToCheck, tableName);
        }
        for (i = 0; i < frags.size(); ++i) {
            frag = (PlSqlFragment)frags.get(i);
            if (frag.getFramentType() != PlSqlFragment.Type.TRIGGER_COLUMNS || tableID == null) continue;
            String lastColToken = ",";
            tk = frag.getFirstToken();
            while (tk.getStart() <= frag.getLastToken().getStart()) {
                String tkStr = tk.getSource();
                if (lastColToken.equals(",")) {
                    Column col = rel.getColumn(this.m_prv.getInternalName(tk.getSource()));
                    if (col != null) {
                        columnIDs.add(col.getID());
                    } else {
                        errors = errors + "\n" + MessageFormat.format(DBArb.getString(351), tkStr, tableName);
                    }
                }
                lastColToken = tk.getSource();
                tk = tk.getNextCodeToken();
            }
        }
        if (mode == extractMode.VALIDATOR && !errors.equals("")) {
            throw new ValidationException((DBObject)trigger, errors.substring("\n".length()));
        }
        if (mode == extractMode.DECLARATOR) {
            trigger.setBaseType(baseType);
            if (baseType == Trigger.BaseType.SCHEMA) {
                trigger.setBaseSchema(baseSchema);
            }
            trigger.setTableID(tableID);
            trigger.setColumnIDs(columnIDs.toArray(new DBObjectID[columnIDs.size()]));
        }
    }

    public void validateReferences(Trigger trg) throws ValidationException {
        this.extractReferences(trg, extractMode.VALIDATOR);
    }

    private ArrayList getFragList(PlSqlFragment frg) {
        ArrayList<Object> retVal = new ArrayList<Object>();
        if (frg != null) {
            retVal.add(frg);
            if (frg.getFramentType() != PlSqlFragment.Type.PLSQL_BLOCK) {
                for (int i = 0; i < frg.getChildren().length; ++i) {
                    ArrayList children = this.getFragList(frg.getChildren()[i]);
                    for (int j = 0; j < children.size(); ++j) {
                        retVal.add(children.get(j));
                    }
                }
            }
        }
        return retVal;
    }

    public static void updateSourceFromRefs(Trigger trig, DBObjectProvider pro) {
        PlSqlInterrogator pi = null;
        StringBuilder builder = new StringBuilder();
        String storedBaseSchema = trig.getBaseSchemaName();
        DBObjectID storedTableID = trig.getTableID();
        Object[] storedColumnIDs = trig.getColumnIDs();
        Trigger copy = DBUtil.makeTemporaryCopy(trig);
        new TriggerDeclarator(pro).loadDeclarativeInfo(copy);
        String derivedBaseSchema = copy.getBaseSchemaName();
        DBObjectID derivedTableID = copy.getTableID();
        Object[] derivedColumnIDs = copy.getColumnIDs();
        if (ModelUtil.areDifferent((Object)storedBaseSchema, (Object)derivedBaseSchema) || ModelUtil.areDifferent((Object)storedTableID, (Object)derivedTableID) || !Arrays.equals(storedColumnIDs, derivedColumnIDs)) {
            pi = trig.getSourceInterrogator();
            PlSqlFragment baseItemFrag = TriggerDeclarator.getFragment(pi.getRoot(), PlSqlFragment.Type.TRIGGER_TABLE);
            Trigger.BaseType baseType = trig.getBaseType();
            if (baseType == Trigger.BaseType.SCHEMA && ModelUtil.areDifferent((Object)storedBaseSchema, (Object)derivedBaseSchema)) {
                builder.append(trig.getSource().substring(0, baseItemFrag.getStartOffset()));
                builder.append(pro.getExternalName(storedBaseSchema));
                builder.append(".SCHEMA");
                builder.append(trig.getSource().substring(baseItemFrag.getEndOffset() + 1));
                trig.setSource(builder.toString());
            } else if (baseType == Trigger.BaseType.TABLE || baseType == Trigger.BaseType.VIEW) {
                PlSqlFragment columnListFrag = null;
                Relation storedTable = null;
                if (baseType == Trigger.BaseType.TABLE && ModelUtil.areDifferent((Object)storedColumnIDs, (Object)derivedColumnIDs)) {
                    columnListFrag = TriggerDeclarator.getFragment(pi.getRoot(), PlSqlFragment.Type.TRIGGER_COLUMNS);
                }
                if (columnListFrag != null) {
                    builder.append(trig.getSource().substring(0, columnListFrag.getStartOffset()));
                    int colNum = 0;
                    for (Object colID : storedColumnIDs) {
                        if (colNum++ > 0) {
                            builder.append(",");
                        }
                        Column c = null;
                        try {
                            c = (Column)colID.resolveID();
                        }
                        catch (DBException e) {
                            // empty catch block
                        }
                        if (c == null) continue;
                        builder.append(pro.getExternalName(c.getName()));
                    }
                    builder.append(trig.getSource().substring(columnListFrag.getEndOffset() + 1, baseItemFrag.getStartOffset()));
                } else {
                    builder.append(trig.getSource().substring(0, baseItemFrag.getStartOffset()));
                }
                String tableName = null;
                if (storedTableID != null) {
                    try {
                        storedTable = (Relation)storedTableID.resolveID();
                    }
                    catch (DBException e) {
                        storedTable = null;
                    }
                    if (storedTable != null) {
                        tableName = storedTable.getName();
                        Schema schema = storedTable.getSchema();
                        if (schema != null) {
                            storedBaseSchema = schema.getName();
                        }
                    }
                }
                if (tableName != null && (ModelUtil.areDifferent((Object)storedBaseSchema, (Object)derivedBaseSchema) || ModelUtil.areDifferent((Object)storedTableID, (Object)derivedTableID))) {
                    String trigSchemaName;
                    Schema trigSchema = trig.getSchema();
                    String string = trigSchemaName = trigSchema == null ? null : trigSchema.getName();
                    if (!storedBaseSchema.equals(trigSchemaName)) {
                        builder.append(pro.getExternalName(storedBaseSchema));
                        builder.append(".");
                    }
                    builder.append(pro.getExternalName(tableName));
                    builder.append(trig.getSource().substring(baseItemFrag.getEndOffset() + 1));
                } else {
                    builder.append(trig.getSource().substring(baseItemFrag.getStartOffset()));
                }
                trig.setSource(builder.toString());
            }
        }
    }

    private static PlSqlFragment getFragment(PlSqlFragment root, PlSqlFragment.Type fragType) {
        for (PlSqlFragment frag : root.getChildren()) {
            if (frag.getFramentType() != fragType) continue;
            return frag;
        }
        for (PlSqlFragment frag : root.getChildren()) {
            PlSqlFragment childFrag = TriggerDeclarator.getFragment(frag, fragType);
            if (childFrag == null) continue;
            return childFrag;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum extractMode {
        DECLARATOR,
        VALIDATOR;

    }
}

