/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora.ddl;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ora.ddl.OracleStatementType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDDLType
extends DDLType<OracleDDLType> {
    private static Map<OracleStatementType, OracleDDLType> s_types = new HashMap<OracleStatementType, OracleDDLType>();
    private static String[] s_promptActions = new String[]{"CREATE OR REPLACE", "CREATE", "DROP", "ALTER", "UNDELETE"};
    private static final String PROMPT = "PROMPT";
    private static final String PROMPT_SIMPLE = "PROMPT {0} {1} ''{2}''";
    private static final String PROMPT_WITH_PAR = "PROMPT ON ''{3}'' ''{4}''";
    private final OracleStatementType m_type;

    private OracleDDLType(OracleStatementType type) {
        this.m_type = type;
    }

    @Override
    public String getTerminator() {
        return this.m_type.getTerminator();
    }

    @Override
    public boolean ensureUnique() {
        switch (this.m_type) {
            case SPOOLON: 
            case SPOOLOFF: {
                return true;
            }
        }
        return false;
    }

    private String getPromptAction(String s) {
        for (String action : s_promptActions) {
            if (!s.trim().toLowerCase().startsWith(action.toLowerCase())) continue;
            return action;
        }
        return null;
    }

    @Override
    public String createPrompt(DBObject obj, String stmt) {
        String promptAction;
        if (!stmt.trim().startsWith(PROMPT) && (promptAction = this.getPromptAction(stmt)) != null) {
            if (obj instanceof SchemaObject) {
                return this.getPrompt(promptAction, obj, null);
            }
            if (obj != null) {
                return this.getPrompt(promptAction, obj, DBUtil.getSchemaObject(obj));
            }
        }
        return null;
    }

    private String getPrompt(String promptAction, DBObject obj, SchemaObject par) {
        if (par == null) {
            return MessageFormat.format(PROMPT_SIMPLE, promptAction.toLowerCase(), obj.getType().toLowerCase(), obj.getName());
        }
        return MessageFormat.format(PROMPT_WITH_PAR, promptAction.toLowerCase(), obj.getType().toLowerCase(), obj.getName(), par.getType().toLowerCase(), par.getName());
    }

    @Override
    public int compareTo(OracleDDLType o) {
        return this.m_type.compareTo(o.m_type);
    }

    public static OracleDDLType getDDLType(String type) {
        return OracleDDLType.getDDLType(OracleStatementType.valueOf(type));
    }

    public static OracleDDLType getDDLType(OracleStatementType type) {
        if (type == null) {
            throw new NullPointerException("must have a valid type");
        }
        OracleDDLType retval = s_types.get((Object)type);
        if (retval == null) {
            retval = new OracleDDLType(type);
            s_types.put(type, retval);
        }
        return retval;
    }
}

