/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.References;

public class OracleTablePartitions
extends AbstractChildDBObject {
    @PropertyKey(value=OracleTablePartitions.class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleTablePartitions";
    public static final String TYPE = "PARTITION MODEL";

    public OracleTablePartitions() {
    }

    public OracleTablePartitions(PartitionType partitionType, ObjectType objectType) {
        this.setPartitionType(partitionType);
        this.setObjectType(objectType);
    }

    public String getType() {
        return TYPE;
    }

    public void setPartitionType(PartitionType partitionType) {
        this.setProperty("partitionType", (Object)partitionType);
    }

    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public void setObjectType(ObjectType objectType) {
        this.setProperty("objectType", (Object)objectType);
    }

    public ObjectType getObjectType() {
        return (ObjectType)((Object)this.getProperty("objectType"));
    }

    public void setSubpartitionModel(OracleTablePartitions subpartitionModel) {
        this.setProperty("subpartitionModel", subpartitionModel);
    }

    public OracleTablePartitions getSubpartitionModel() {
        return (OracleTablePartitions)this.getProperty("subpartitionModel");
    }

    public void setPartitionColumns(DBObjectID[] partitionColumns) {
        this.getChildSupport("partitionColumns").setChildArray(partitionColumns);
    }

    @References(value=Column.class, internal=true)
    public DBObjectID[] getPartitionColumns() {
        return this.getChildSupport("partitionColumns").getChildArray(DBObjectID.class);
    }

    public void addPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.getChildSupport("partitionColumns").addChild(partitionColumn);
        }
    }

    public void addPartitionColumn(DBObjectID partitionColumn, int atIndex) {
        if (partitionColumn != null) {
            this.getChildSupport("partitionColumns").addChild(atIndex, (Object)partitionColumn);
        }
    }

    public void removePartitionColumn(DBObjectID partitionColumn) {
        this.getChildSupport("partitionColumns").removeChild(partitionColumn);
    }

    public void setHashQuantity(Integer hashQuantity) {
        this.setProperty("hashQuantity", hashQuantity);
    }

    public Integer getHashQuantity() {
        return (Integer)this.getProperty("hashQuantity");
    }

    public void setHashQuantityTablespaces(String[] tablespaceNames) {
        this.getChildSupport("hashQuantityTablespaces").setChildArray(tablespaceNames);
    }

    public void addHashQuantityTablespace(String tablespaceName) {
        if (tablespaceName != null) {
            this.getChildSupport("hashQuantityTablespaces").addChild(tablespaceName);
        }
    }

    public void removeHashQuantityTablespace(String tablespaceName) {
        this.getChildSupport("hashQuantityTablespaces").removeChild(tablespaceName);
    }

    public String[] getHashQuantityTablespaces() {
        return this.getChildSupport("hashQuantityTablespaces").getChildArray(String.class);
    }

    public void setPartitions(TablePartition[] partitions) {
        this.getChildSupport("partitions").setChildArray(partitions);
    }

    public TablePartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(TablePartition.class);
    }

    public void addPartition(TablePartition partition) {
        this.getChildSupport("partitions").addChild(partition);
    }

    public void removePartition(TablePartition partition) {
        this.getChildSupport("partitions").removeChild(partition);
    }

    public TablePartition createPartition(String name) {
        TablePartition partition = new TablePartition(name, this.getPartitionType(), this.getObjectType());
        this.addPartition(partition);
        return partition;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ObjectType {
        PARTITION,
        SUBPARTITION,
        SUBPARTITION_TEMPLATE,
        PARTITION_LEVEL_SUBPARTITION;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartitionType {
        RANGE,
        HASH,
        LIST;

    }
}

