/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.NumericDataType;
import oracle.javatools.db.datatypes.PredefinedDataTypeUsage;
import oracle.javatools.util.ModelUtil;

public class OracleNumberDataType
extends NumericDataType {
    private static final Long LONG_1 = new Long(1L);
    private static final Long LONG_38 = new Long(38L);
    private static final Long LONG__84 = new Long(-84L);
    private static final Long LONG_127 = new Long(127L);
    private static DataTypeAttribute PRECISION = new DataTypeAttribute("precision", 158, null, null, true, false);
    private static DataTypeAttribute SCALE = new DataTypeAttribute("scale", 159, -84L, LONG_127, new Long(0L), false);
    private static final NumericDataType.MinMaxValue MIN_MAX_FLOAT = new NumericDataType.MinMaxValue("1.0e-130", "9.9999999999999999999999999999999999999e+125", 2);

    public OracleNumberDataType() {
    }

    public OracleNumberDataType(int domain) {
        super(domain, "NUMBER", "NUMBER[(<precision>[, <scale>])]", new DataTypeAttribute[]{PRECISION, SCALE}, MIN_MAX_FLOAT);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        Long scale;
        String precision = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        if (ModelUtil.hasLength((String)precision) && !precision.trim().equals("*")) {
            int value = 0;
            try {
                value = Long.valueOf(precision).intValue();
            }
            catch (NumberFormatException x) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.getString(198));
            }
            if (value < 1) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(194, DataTypeHelper.getNameFromLabel(158), LONG_1));
            }
            if (value > 38) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(195, DataTypeHelper.getNameFromLabel(158), LONG_38));
            }
        }
        if ((scale = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"))) != null) {
            if (scale.compareTo(LONG__84) < 0) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(194, DataTypeHelper.getNameFromLabel(159), LONG__84));
            }
            if (scale.compareTo(LONG_127) > 0) {
                throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(195, DataTypeHelper.getNameFromLabel(159), LONG_127));
            }
        }
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        String precision = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        Long scale = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"));
        PredefinedDataTypeUsage usage = new PredefinedDataTypeUsage();
        dataTypeUsage.copyTo(usage);
        if (precision != null) {
            if (precision.trim().equals("*")) {
                if (scale != null) {
                    usage.putAttributeValue("precision", LONG_38);
                } else {
                    usage.deleteAttributeValue("precision");
                }
            }
        } else if (scale != null) {
            usage.putAttributeValue("precision", LONG_38);
        }
        super.validateDefaultValue(defaultValue, usage, dbObject);
    }

    public String getDDL(DataTypeUsage dataTypeUsage) {
        String ddl = this.getName();
        String precision = DataTypeHelper.toString(dataTypeUsage.getAttributeValue("precision"));
        Long scale = DataTypeHelper.toLong(dataTypeUsage.getAttributeValue("scale"));
        if (precision != null) {
            ddl = ddl + '(' + precision + (scale == null ? "" : ", " + scale) + ')';
        } else if (scale != null) {
            ddl = ddl + "(*, " + scale + ')';
        }
        return ddl;
    }
}

