/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.ArrayList;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.Column;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.Index;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.IndexPartition;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.sql.IndexObject;

public class OracleIndexPartitions
extends AbstractChildDBObject {
    @PropertyKey(value=OracleIndexPartitions.class, childOf={Index.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleIndexPartitions";
    public static final String TYPE = "INDEX PARTITION MODEL";

    public OracleIndexPartitions() {
    }

    public OracleIndexPartitions(PartitionType partitionType) {
        this.setPartitionType(partitionType);
    }

    public String getType() {
        return TYPE;
    }

    public PartitionType getPartitionType() {
        return (PartitionType)((Object)this.getProperty("partitionType"));
    }

    public IndexPartition[] getPartitions() {
        return this.getChildSupport("partitions").getChildArray(IndexPartition.class);
    }

    public DBObjectID[] getGlobalPartitionColumns() {
        return this.getChildSupport("globalPartitionColumns").getChildArray(DBObjectID.class);
    }

    public String[] getTablespaces() {
        return this.getChildSupport("tablespaces").getChildArray(String.class);
    }

    public Integer getGlobalHashQuantity() {
        return (Integer)this.getProperty("globalHashQuantity");
    }

    public void setPartitionType(PartitionType partitionType) {
        this.setProperty("partitionType", (Object)partitionType);
    }

    public void setGlobalPartitionColumns(DBObjectID[] partitionColumns) {
        this.getChildSupport("globalPartitionColumns").setChildArray(partitionColumns);
    }

    public void addGlobalPartitionColumn(DBObjectID partitionColumn) {
        if (partitionColumn != null) {
            this.getChildSupport("globalPartitionColumns").addChild(partitionColumn);
        }
    }

    public void removeGlobalPartitionColumn(DBObjectID partitionColumn) {
        this.getChildSupport("globalPartitionColumns").removeChild(partitionColumn);
    }

    public void setPartitions(IndexPartition[] partitions) {
        this.getChildSupport("partitions").setChildArray(partitions);
    }

    public void addPartition(IndexPartition partition) {
        this.getChildSupport("partitions").addChild(partition);
    }

    public void removePartition(IndexPartition partition) {
        this.getChildSupport("partitions").removeChild(partition);
    }

    public void setTablespaces(String[] tablespaces) {
        this.getChildSupport("tablespaces").setChildArray(tablespaces);
    }

    public void addTablespace(String tablespace) {
        if (tablespace != null) {
            this.getChildSupport("tablespaces").addChild(tablespace);
        }
    }

    public void setGlobalHashQuantity(Integer globalHashQuantity) {
        this.setProperty("globalHashQuantity", globalHashQuantity);
    }

    public static Column[] getValidGlobalPartitionColumns(Index index) {
        IndexObject colExpr;
        String expr;
        ArrayList<Column> columns = new ArrayList<Column>();
        Table table = index.getTable();
        IndexObject[] arr$ = index.getColumnExpressions();
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && table.getColumn(expr = (colExpr = arr$[i$]).getExpression().getSQLText()) != null && !"DESC".equals(colExpr.getOrder()); ++i$) {
            columns.add(table.getColumn(expr));
        }
        return columns.toArray(new Column[columns.size()]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PartitionType {
        GLOBAL_RANGE,
        GLOBAL_HASH,
        LOCAL_HASH,
        LOCAL_COMP,
        LOCAL_OTHER,
        DOMAIN,
        SUBPARTITION;

    }
}

