/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.ReferenceID;
import oracle.javatools.db.Table;
import oracle.javatools.db.ora.OracleDatabase;
import oracle.javatools.db.property.PropertyKey;
import oracle.javatools.db.property.Transient;

public class OracleExternalTableProperties
extends AbstractChildDBObject {
    @PropertyKey(value=OracleExternalTableProperties.class, childOf={Table.class}, provider=OracleDatabase.class)
    public static final String KEY = "OracleExternalTableProperties";
    public static final String TYPE = "EXTERNAL TABLE PROPERTIES";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_LOADER = "ORACLE_LOADER";
    public static final String ACCESS_DRIVER_TYPE_ORACLE_DATAPUMP = "ORACLE_DATAPUMP";
    public static final String REJECT_LIMIT_UNLIMITED = "UNLIMITED";

    public OracleExternalTableProperties() {
        this.setAccessUsingClob(false);
        this.setProjectColumn(ProjectColumn.ALL);
    }

    public String getType() {
        return TYPE;
    }

    public void setDefaultDirectory(DBObjectID defaultDirectory) {
        this.setProperty("defaultDirectory", defaultDirectory);
        if (defaultDirectory instanceof ReferenceID && ((ReferenceID)defaultDirectory).getType() == null) {
            ((ReferenceID)defaultDirectory).setType("DIRECTORY");
        }
    }

    public DBObjectID getDefaultDirectory() {
        return (DBObjectID)this.getProperty("defaultDirectory");
    }

    public void setLocationSpecifiers(LocationSpecifier[] locationSpecifiers) {
        this.getChildSupport("locationSpecifiers").setChildArray(locationSpecifiers);
    }

    public LocationSpecifier[] getLocationSpecifiers() {
        return this.getChildSupport("locationSpecifiers").getChildArray(LocationSpecifier.class);
    }

    public void addLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void addLocationSpecifier(DBObjectID directory, String specifier) {
        LocationSpecifier locationSpecifier = new LocationSpecifier(directory, specifier);
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void addLocationSpecifier(String specifier) {
        LocationSpecifier locationSpecifier = new LocationSpecifier(specifier);
        this.getChildSupport("locationSpecifiers").addChild(locationSpecifier);
    }

    public void removeLocationSpecifier(LocationSpecifier locationSpecifier) {
        this.getChildSupport("locationSpecifiers").removeChild(locationSpecifier);
    }

    public void removeAllLocationSpecifiers() {
        this.getChildSupport("locationSpecifiers").clearChildren();
    }

    public void setAccessDriverType(String accessDriverType) {
        this.setProperty("accessDriverType", accessDriverType);
    }

    public String getAccessDriverType() {
        return (String)this.getProperty("accessDriverType");
    }

    public void setAccessParameters(Object accessParameters) {
        this.setProperty("accessParameters", accessParameters);
    }

    public Object getAccessParameters() {
        return this.getProperty("accessParameters");
    }

    public void setAccessUsingClob(boolean accessUsingClob) {
        this.setProperty("accessUsingClob", accessUsingClob);
    }

    public boolean isAccessUsingClob() {
        return (Boolean)this.getProperty("accessUsingClob", false);
    }

    public void setRejectLimit(String rejectLimit) {
        this.setProperty("rejectLimit", rejectLimit);
    }

    public String getRejectLimit() {
        return (String)this.getProperty("rejectLimit");
    }

    public void setProjectColumn(ProjectColumn projectColumn) {
        this.setProperty("projectColumn", (Object)projectColumn);
    }

    public ProjectColumn getProjectColumn() {
        return (ProjectColumn)((Object)this.getProperty("projectColumn"));
    }

    public static class LocationSpecifier
    extends AbstractChildDBObject {
        public static final String TYPE = "LOCATION_SPECIFIER";

        public LocationSpecifier() {
            this(null);
        }

        public LocationSpecifier(String specifier) {
            this(null, specifier);
        }

        public LocationSpecifier(DBObjectID directory, String specifier) {
            this.setDirectory(directory);
            this.setSpecifier(specifier);
        }

        public String getType() {
            return TYPE;
        }

        public void setDirectory(DBObjectID directory) {
            this.setProperty("directory", directory);
        }

        public DBObjectID getDirectory() {
            return (DBObjectID)this.getProperty("directory");
        }

        public void setSpecifier(String specifier) {
            this.setProperty("specifier", specifier);
        }

        public String getSpecifier() {
            return (String)this.getProperty("specifier");
        }

        @Transient
        public String getName() {
            return this.getSpecifier();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ProjectColumn {
        ALL,
        REFERENCED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessType {
        BLOB,
        CLOB;

    }
}

