/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ora;

import java.util.List;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.ora.OracleIndexPartitions;
import oracle.javatools.db.ora.OracleStorageProperties;
import oracle.javatools.db.ora.TablePartition;
import oracle.javatools.util.ModelUtil;

public class IndexPartition
extends AbstractChildDBObject {
    public static final String TYPE = "INDEX PARTITION";

    public IndexPartition() {
        this((OracleIndexPartitions)null);
    }

    public IndexPartition(OracleIndexPartitions parent) {
        this(null, parent);
    }

    public IndexPartition(String name, OracleIndexPartitions parent) {
        super(name, parent);
        this.setKeyCompression(Boolean.FALSE);
    }

    public Boolean getKeyCompression() {
        return (Boolean)this.getProperty("keyCompression");
    }

    public Object[] getValuesLessThan() {
        return this.getChildSupport("valuesLessThan").getChildArray(Object.class);
    }

    public OracleStorageProperties getSegmentAttributes() {
        return (OracleStorageProperties)this.getProperty("segmentAttributes");
    }

    public OracleIndexPartitions getSubpartitions() {
        return (OracleIndexPartitions)this.getProperty("subpartitions");
    }

    public String getDomainParameters() {
        return (String)this.getProperty("domainParameters");
    }

    public String getType() {
        return TYPE;
    }

    public void setKeyCompression(Boolean keyCompression) {
        this.setProperty("keyCompression", keyCompression);
    }

    public void setValuesLessThan(Object[] values) {
        Object[] nValues;
        if (values == null) {
            nValues = null;
        } else {
            nValues = new Object[values.length];
            for (int i = 0; i < nValues.length; ++i) {
                nValues[i] = this.normaliseValue(values[i]);
            }
        }
        this.getChildSupport("valuesLessThan").setChildArray(nValues);
    }

    public void setValuesLessThan(String values) {
        if (ModelUtil.hasLength((String)values)) {
            List<String> list = TablePartition.splitValues(values);
            this.setValuesLessThan(list.toArray(new String[list.size()]));
        }
    }

    public void setSegmentAttributes(OracleStorageProperties segmentAttributes) {
        this.setProperty("segmentAttributes", segmentAttributes);
    }

    public void setSubpartitions(OracleIndexPartitions subpartitions) {
        this.setProperty("subpartitions", subpartitions);
    }

    public void setDomainParameters(String parameters) {
        this.setProperty("domainParameters", parameters);
    }

    public void addValue(Object value) {
        if (value != null) {
            this.getChildSupport("valuesLessThan").addChild(this.normaliseValue(value));
        }
    }

    private Object normaliseValue(Object value) {
        if (value instanceof String) {
            String s = (String)value;
            if (TablePartition.RangeValue.MAXVALUE.toString().equalsIgnoreCase(s)) {
                value = TablePartition.RangeValue.MAXVALUE;
            }
        }
        return value;
    }
}

