/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.execute;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import oracle.javatools.db.AbstractDatabase;
import oracle.javatools.db.CancelledException;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBSQLException;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.Database;
import oracle.javatools.db.execute.ConnectionWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatementWrapper {
    private static ExecutionProxy s_proxy;
    private Database m_db;
    private boolean m_reconnectFirst;
    private boolean m_locked;
    private Connection m_conn;
    private String m_name;
    private String m_identifier;
    private Statement m_stmt;
    private String[] m_statement;
    private boolean m_ignoreErrors;
    private boolean m_noThreads;
    private long m_nanos;
    private final StringBuffer m_queryLog = new StringBuffer();
    private static Collection<Listener> s_listeners;

    public StatementWrapper(String connName, Connection connection, String ... statements) {
        this.m_name = connName;
        this.m_conn = connection;
        this.setStatement(statements);
    }

    public StatementWrapper(Database db, String ... statements) {
        this(db, db.isConnectionClosed(null) == null, statements);
    }

    protected StatementWrapper(Database db, boolean reconnectFirst, String ... statements) {
        this.m_db = db;
        this.m_reconnectFirst = reconnectFirst;
        this.setStatement(statements);
    }

    public void setStatement(String ... statements) {
        this.m_statement = statements;
    }

    protected final String[] getStatementStrings() {
        return this.m_statement;
    }

    protected String getStatementTextForLog() {
        StringBuilder buff = new StringBuilder();
        if (this.m_statement != null) {
            for (String s : this.m_statement) {
                if (buff.length() > 0) {
                    buff.append("\n");
                }
                buff.append(s);
            }
        }
        return buff.toString();
    }

    protected final Statement getStatement() throws SQLException {
        if (this.m_stmt == null) {
            if (!this.m_locked) {
                throw new IllegalStateException("not executing, statement cannot be retrieved");
            }
            this.m_stmt = this.createStatment();
        }
        return this.m_stmt;
    }

    protected Statement createStatment() throws SQLException {
        return this.getConnection().createStatement();
    }

    public void setBypassExecutionProxy(boolean doNotThread) {
        this.m_noThreads = doNotThread;
    }

    protected final void setExecuting(boolean executing) {
        this.m_locked = executing;
    }

    public boolean execute() throws DBException {
        return this.doExecute(new ExecutionRunnable<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean runImpl() throws DBException {
                boolean retval = false;
                if (StatementWrapper.this.m_statement != null) {
                    StatementWrapper.this.setExecuting(true);
                    try {
                        if (StatementWrapper.this.m_db != null) {
                            ConnectionWrapper wrap = new ConnectionWrapper(StatementWrapper.this.m_db, StatementWrapper.this.getStatementTextForLog());
                            retval = wrap.call(new ConnectionWrapper.SQLCallable<Boolean>(wrap){

                                @Override
                                public Boolean call() throws SQLException {
                                    return StatementWrapper.this.executeStatements();
                                }
                            });
                        } else {
                            try {
                                retval = StatementWrapper.this.executeStatements();
                            }
                            catch (SQLException sqe) {
                                StatementWrapper.this.throwDBException(null, sqe);
                            }
                        }
                        Object var4_4 = null;
                        StatementWrapper.this.close();
                        StatementWrapper.this.setExecuting(false);
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        StatementWrapper.this.close();
                        StatementWrapper.this.setExecuting(false);
                        throw throwable;
                    }
                }
                return retval;
            }
        });
    }

    private boolean executeStatements() throws SQLException {
        boolean retval = true;
        for (String s : this.m_statement) {
            if (s == null) continue;
            try {
                retval = this.executeImpl(s) || retval;
            }
            catch (SQLException sqe) {
                if (this.m_ignoreErrors) continue;
                throw sqe;
            }
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean executeImpl(String stmt) throws SQLException {
        this.sqlTrace(this.getConnectionName(), stmt, new Object[0]);
        boolean result = false;
        try {
            if (this.m_db != null && this.m_db instanceof AbstractDatabase) {
                ((AbstractDatabase)this.m_db).setStatement(this.getStatement());
            }
            result = this.getStatement().execute(stmt);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (this.m_db != null && this.m_db instanceof AbstractDatabase) {
                ((AbstractDatabase)this.m_db).setStatement(null);
            }
            throw throwable;
        }
        if (this.m_db != null && this.m_db instanceof AbstractDatabase) {
            ((AbstractDatabase)this.m_db).setStatement(null);
        }
        return result;
    }

    protected final <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
        Object res;
        this.queryStarted();
        ExecutionProxy ep = StatementWrapper.getExecutionProxy();
        if (ep == null || this.m_noThreads) {
            r.run();
            res = r.getResult();
        } else {
            res = ep.doExecute(r);
        }
        this.queryFinished();
        return res;
    }

    public void close() {
        if (this.m_stmt != null) {
            try {
                this.m_stmt.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public final String getIdentifier() {
        return this.m_identifier;
    }

    public final void setIdentifier(String i) {
        this.m_identifier = i;
    }

    protected final Database getDatabase() {
        return this.m_db;
    }

    protected final void setDatabase(Database db) {
        this.m_db = db;
    }

    protected final String getConnectionName() {
        if (this.m_db == null) {
            return this.m_name;
        }
        return this.m_db.getConnectionName();
    }

    protected final Connection getConnection() {
        Connection retval;
        if (this.m_db == null) {
            retval = this.m_conn;
        } else {
            try {
                retval = this.m_db.getConnection(this.m_reconnectFirst);
            }
            catch (DBException dbe) {
                retval = this.m_db.getConnection();
            }
        }
        return retval;
    }

    protected boolean isIgnoreErrors() {
        return this.m_ignoreErrors;
    }

    public void setIgnoreErrors(boolean ignore) {
        this.m_ignoreErrors = ignore;
    }

    protected final void throwDBException(DBObject obj, String text, SQLException sqe) throws DBException {
        throw this.createDBSQLException(obj, text, sqe);
    }

    protected DBSQLException createDBSQLException(DBObject obj, String text, SQLException sqe) {
        return StatementWrapper.createDBSQLException(this.m_db, obj, text, sqe);
    }

    public final void throwDBException(SQLException sqe) throws DBException {
        this.throwDBException(null, sqe);
    }

    public final void throwDBException(DBObject obj, SQLException sqe) throws DBException {
        if (this.hasCancelled(sqe)) {
            throw new CancelledException();
        }
        this.throwDBException(obj, this.getStatementTextForLog(), sqe);
    }

    protected boolean hasCancelled(SQLException sqe) {
        return false;
    }

    protected final synchronized void sqlTrace(String dbName, String query, Object ... params) {
        StringBuilder paramList = null;
        if (params != null) {
            paramList = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                int index = query.indexOf(63);
                if (index < 0) continue;
                String param = params[i] == null ? "<null>" : "'" + params[i] + "'";
                query = query.substring(0, index) + param + query.substring(index + 1);
                paramList.append(param).append(", ");
            }
        }
        this.m_queryLog.append("\n");
        this.m_queryLog.append(query.trim());
        if (paramList != null && paramList.length() > 0) {
            this.m_queryLog.append("\n");
            this.m_queryLog.append(DBArb.getString(364));
            this.m_queryLog.append(" ");
            this.m_queryLog.append((CharSequence)paramList);
        }
    }

    protected final void queryStarted() {
        this.m_nanos = System.nanoTime();
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryStarted(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
    }

    protected final synchronized void queryFinished() {
        double millis = (double)(System.nanoTime() - this.m_nanos) / 1000000.0;
        this.m_nanos = 0L;
        if (s_listeners != null) {
            for (Listener list : s_listeners) {
                try {
                    list.queryFinished(this);
                }
                catch (Exception e) {
                    DBLog.logStackTrace(e);
                }
            }
        }
        if (this.m_queryLog != null) {
            this.m_queryLog.append("\n");
            this.m_queryLog.append(DBArb.format(365, Double.toString(millis)));
            DBLog.getSQLLog().log(Level.FINE, this.getConnectionName() + ": " + this.m_queryLog.toString());
        }
    }

    protected static final DBSQLException createDBSQLException(Database db, DBObject obj, String text, SQLException sqe) {
        if (db instanceof AbstractDatabase) {
            String msg = ((AbstractDatabase)db).getDBExceptionMessage(sqe);
            return new DBSQLException(obj, text, msg, sqe);
        }
        return new DBSQLException(obj, text, sqe);
    }

    public static final void addListener(Listener l) {
        if (l != null) {
            if (s_listeners == null) {
                s_listeners = new ArrayList<Listener>();
            }
            s_listeners.add(l);
        }
    }

    public static final boolean removeListener(Listener l) {
        return s_listeners != null && s_listeners.remove(l);
    }

    public static void setExecutionProxy(ExecutionProxy ep) {
        if (s_proxy != null) {
            DBLog.getLogger().info("changing execution proxy for db queries from " + s_proxy.getClass().getName() + " to " + (ep == null ? "null" : ep.getClass().getName()));
        }
        s_proxy = ep;
    }

    public static ExecutionProxy getExecutionProxy() {
        return s_proxy;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public abstract class ExecutionRunnable<T>
    implements Runnable {
        private T m_result;
        private DBException m_dbe;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized void run() {
            String key = "StatementExecution" + System.nanoTime();
            try {
                try {
                    DBUtil.suspendTimestampChecking(StatementWrapper.this.m_db, key);
                    this.m_result = null;
                    this.m_dbe = null;
                    this.m_result = this.runImpl();
                }
                catch (DBException dbe) {
                    this.m_dbe = dbe;
                    Object var4_3 = null;
                    DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, key);
                    return;
                }
                catch (Throwable t) {
                    this.m_dbe = new DBException(t);
                    Object var4_4 = null;
                    DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, key);
                    return;
                }
                Object var4_2 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, key);
                throw throwable;
            }
            DBUtil.resumeTimestampChecking(StatementWrapper.this.m_db, key);
        }

        public abstract T runImpl() throws DBException;

        public T getResult() throws DBException {
            if (this.m_dbe != null) {
                throw this.m_dbe;
            }
            return this.m_result;
        }

        public String getName() {
            return StatementWrapper.this.m_db == null ? "" : StatementWrapper.this.m_db.getConnectionName();
        }

        public String getLogText() {
            return StatementWrapper.this.m_queryLog == null ? null : StatementWrapper.this.m_queryLog.toString();
        }

        public void cancel() throws SQLException {
            if (StatementWrapper.this.m_stmt != null) {
                StatementWrapper.this.m_stmt.cancel();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ExecutionProxy {
        private boolean m_cancelling;
        private final List<ExecutionRunnable> m_running = new ArrayList<ExecutionRunnable>();

        public final synchronized void setCancelling(boolean cancel) {
            this.m_cancelling = cancel;
            if (cancel) {
                for (ExecutionRunnable run : this.m_running) {
                    try {
                        run.cancel();
                    }
                    catch (SQLException sqe) {
                        DBLog.getLogger().log(Level.WARNING, "Error cancelling statement execution: " + sqe.getMessage());
                    }
                }
                this.m_running.clear();
            }
        }

        private void checkCancelling() throws CancelledException {
            if (this.m_cancelling) {
                throw new CancelledException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private <T> T doExecute(ExecutionRunnable<T> r) throws DBException {
            ExecutionProxy executionProxy;
            this.checkCancelling();
            ExecutionProxy executionProxy2 = this;
            synchronized (executionProxy2) {
                this.checkCancelling();
                this.m_running.add(r);
            }
            try {
                executionProxy2 = this.execute(r);
                Object var5_5 = null;
                executionProxy = this;
            }
            catch (DBException dbe) {
                try {
                    if (this.m_cancelling && !(dbe instanceof CancelledException)) {
                        throw new CancelledException();
                    }
                    throw dbe;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    ExecutionProxy executionProxy3 = this;
                    synchronized (executionProxy3) {
                        this.m_running.remove(r);
                    }
                    throw throwable;
                }
            }
            synchronized (executionProxy) {
                this.m_running.remove(r);
            }
            return (T)executionProxy2;
        }

        public abstract <T> T execute(ExecutionRunnable<T> var1) throws DBException;
    }

    public static interface Listener {
        public void queryStarted(StatementWrapper var1);

        public void queryFinished(StatementWrapper var1);
    }
}

