/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.beans.PropertyChangeEvent;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.ChildDBObject;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectChange;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.GenericDBObjectComparator;
import oracle.javatools.db.diff.GenericDiffEngine;
import oracle.javatools.db.property.PropertyInfo;
import oracle.javatools.db.property.PropertyIterator;
import oracle.javatools.util.ModelUtil;

public class ResultSetApplier {
    private List<DBObjectChange> m_events;
    private boolean m_applyToB;

    public ResultSetApplier() {
        this(false);
    }

    public ResultSetApplier(boolean applyToB) {
        this.m_applyToB = applyToB;
    }

    private Object getOriginalObject(Difference rs) {
        return this.m_applyToB ? rs.getUpdatedObject() : rs.getOriginalObject();
    }

    private Object getUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getOriginalObject() : rs.getUpdatedObject();
    }

    private Integer getIndexOfUpdatedObject(Difference rs) {
        return this.m_applyToB ? rs.getIndexOfOriginalObject() : rs.getIndexOfUpdatedObject();
    }

    public final void apply(Difference rs) {
        this.m_events = new ArrayList<DBObjectChange>();
        if (!rs.isSame()) {
            if (rs.isList()) {
                Collection<? extends Difference> change = rs.getChildren();
                for (Difference difference : change) {
                    if (!difference.isModified() || !difference.isMap()) continue;
                    this.applyProperties(difference, null);
                }
            } else if (rs.isMap()) {
                this.applyProperties(rs, null);
            }
        }
    }

    private final void applyProperties(Difference rs, Difference parent) {
        Object original = this.getOriginalObject(rs);
        if (original != null) {
            TreeMap<PropertyInfo, Difference> process = new TreeMap<PropertyInfo, Difference>();
            Map<String, PropertyInfo> infos = PropertyIterator.getPropertyInfos(original);
            Collection<? extends Difference> changed = rs.getChildren();
            for (Difference difference : changed) {
                String propertyName = difference.getPropertyName();
                if (difference.isSame()) continue;
                Class objClass = rs.getDifferenceClass();
                if (Map.class.isAssignableFrom(objClass)) {
                    Object parentObj;
                    Object newPropValue = this.getUpdatedObject(difference);
                    ((Map)original).put(propertyName, newPropValue);
                    if (!(newPropValue instanceof ChildDBObject) || !((parentObj = this.getOriginalObject(parent)) instanceof DBObject)) continue;
                    ((ChildDBObject)newPropValue).setParent((DBObject)parentObj);
                    continue;
                }
                PropertyInfo info = infos.get(propertyName);
                if (info == null) {
                    throw new IllegalStateException("don't have a property info for property " + propertyName + " on object " + objClass);
                }
                process.put(info, difference);
            }
            for (PropertyInfo propertyInfo : process.keySet()) {
                Difference change = (Difference)process.get(propertyInfo);
                Object[] value = null;
                boolean setProp = false;
                if (change.isMap() && this.getModifiedObjectMapSize(change) > 0) {
                    if ("schema".equals(propertyInfo.getPropertyName()) && SchemaObject.class.isAssignableFrom(rs.getDifferenceClass())) {
                        value = this.getUpdatedObject(change);
                        setProp = true;
                    } else {
                        this.applyProperties(change, rs);
                        if (this.getOriginalObject(change) == null) {
                            value = this.getUpdatedObject(change);
                            setProp = true;
                        }
                    }
                } else if (change.isLeaf() || change.isMap() && this.getModifiedObjectMapSize(change) == 0) {
                    value = this.getUpdatedObject(change);
                    setProp = true;
                } else if (change.isList()) {
                    List list = this.applyList(change, rs);
                    value = Array.newInstance(change.getDifferenceClass().getComponentType(), list.size());
                    value = list.toArray((Object[])value);
                    setProp = true;
                }
                if (!setProp) continue;
                try {
                    propertyInfo.setPropertyValue(original, value);
                }
                catch (Exception e) {
                    DBLog.getLogger(this).log(Level.SEVERE, "Error applying property value", e);
                }
            }
            if (parent == null) {
                this.m_events.add(new ResultSetChange(rs));
            }
        }
    }

    private int getModifiedObjectMapSize(Difference change) {
        int size = 0;
        if (change.isMap()) {
            Collection<? extends Difference> children = change.getChildren();
            for (Difference difference : children) {
                if (!difference.isModified()) continue;
                ++size;
            }
        }
        return size;
    }

    private final List applyList(Difference rs, Difference parent) {
        ArrayList<Object> value = null;
        ArrayList<? extends Difference> changes = new ArrayList<Difference>(rs.getChildren());
        if (changes != null) {
            Collections.sort(changes, new Comparator<Difference>(){

                @Override
                public int compare(Difference o1, Difference o2) {
                    if (o1 == o2) {
                        return 0;
                    }
                    if (o1 == null) {
                        return -100;
                    }
                    if (o2 == null) {
                        return 100;
                    }
                    return ResultSetApplier.this.getIndexOfUpdatedObject(o1).compareTo(ResultSetApplier.this.getIndexOfUpdatedObject(o2));
                }
            });
            value = new ArrayList<Object>(changes.size());
            for (Difference difference : changes) {
                if (difference.isSame()) {
                    value.add(this.getOriginalObject(difference));
                    continue;
                }
                if (!difference.isSame() && !difference.isModified()) {
                    Object newObj = this.getUpdatedObject(difference);
                    if (newObj == null) continue;
                    value.add(newObj);
                    continue;
                }
                if (!difference.isModified()) continue;
                if (difference.isLeaf()) {
                    value.add(this.getUpdatedObject(difference));
                    continue;
                }
                if (difference.getOriginalObject().getClass() != difference.getUpdatedObject().getClass()) {
                    value.add(this.getUpdatedObject(difference));
                    continue;
                }
                this.applyProperties(difference, rs);
                value.add(this.getOriginalObject(difference));
            }
        }
        return value;
    }

    public DBObjectChange[] fireEvents() {
        for (DBObjectChange c : this.m_events) {
            DBObject obj = c.getDBObject();
            if (!(obj instanceof SystemObject)) continue;
            ((SystemObject)obj).fireObjectUpdated(c);
        }
        return this.m_events == null ? new DBObjectChange[]{} : this.m_events.toArray(new DBObjectChange[this.m_events.size()]);
    }

    private DBObjectChange fireLazyChangeEventImpl(SystemObject obj, SystemObject copyOfOriginal) {
        ResultSetChange change = new ResultSetChange(obj, copyOfOriginal);
        obj.fireObjectUpdated(change);
        return change;
    }

    public static DBObjectChange fireLazyChangeEvent(SystemObject obj, SystemObject copyOfOriginal) {
        ResultSetApplier app = new ResultSetApplier();
        return app.fireLazyChangeEventImpl(obj, copyOfOriginal);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class ResultSetChange
    extends DBObjectChange {
        private Difference m_rs;
        private DBObject m_lazyDiffObj;
        private List<DBObject> m_objectsAdded;
        private List<DBObject> m_objectsRemoved;
        private Map<DBObject, DBObjectChange> m_objectsChanged;
        private Map<String, PropertyChangeEvent> m_propsChanged;

        private ResultSetChange(Difference rs) {
            super((DBObject)ResultSetApplier.this.getOriginalObject(rs));
            this.m_rs = rs;
        }

        private ResultSetChange(DBObject toRebuild, DBObject copyOfOriginal) {
            super(toRebuild);
            this.m_lazyDiffObj = copyOfOriginal;
        }

        @Override
        public List<DBObject> getOwnedObjectsAdded() {
            if (this.m_objectsAdded == null) {
                this.loadResultSet();
            }
            return this.m_objectsAdded;
        }

        @Override
        public Map<DBObject, DBObjectChange> getOwnedObjectsChanged() {
            if (this.m_objectsChanged == null) {
                this.loadResultSet();
            }
            return this.m_objectsChanged;
        }

        @Override
        public List<DBObject> getOwnedObjectsRemoved() {
            if (this.m_objectsRemoved == null) {
                this.loadResultSet();
            }
            return this.m_objectsRemoved;
        }

        @Override
        public Map<String, PropertyChangeEvent> getPropertiesChanged() {
            if (this.m_propsChanged == null) {
                this.loadResultSet();
            }
            return this.m_propsChanged;
        }

        private Difference getDifference() {
            if (this.m_rs == null) {
                this.m_rs = GenericDiffEngine.getDiffEngine(true).diff(this.m_lazyDiffObj, this.getDBObject()).getResult();
            }
            return this.m_rs;
        }

        private void loadResultSet() {
            HashMap<DBObject, ResultSetChange> objectsChanged = new HashMap<DBObject, ResultSetChange>();
            HashMap<String, PropertyChangeEvent> propsChanged = new HashMap<String, PropertyChangeEvent>();
            ArrayList<DBObject> objectsAdded = new ArrayList<DBObject>();
            ArrayList<DBObject> objectsRemoved = new ArrayList<DBObject>();
            for (Difference difference : this.getDifference().getChildren()) {
                if (difference.isSame()) continue;
                boolean propChange = true;
                if (difference.isList()) {
                    Class propClass = difference.getDifferenceClass();
                    if (propClass.isArray() && DBObject.class.isAssignableFrom(propClass.getComponentType())) {
                        propChange = false;
                        for (Difference difference2 : difference.getChildren()) {
                            if (!difference2.isSame()) {
                                DBObject updated = (DBObject)ResultSetApplier.this.getUpdatedObject(difference2);
                                DBObject original = (DBObject)ResultSetApplier.this.getOriginalObject(difference2);
                                if (updated == null && original != null) {
                                    objectsRemoved.add(original);
                                } else if (updated != null && original == null) {
                                    objectsAdded.add(updated);
                                } else {
                                    objectsChanged.put(original, new ResultSetChange(difference2));
                                }
                            }
                            int indexA = difference2.getIndexOfOriginalObject();
                            int indexB = difference2.getIndexOfUpdatedObject();
                            if (indexA < 0 || indexB < 0 || indexA == indexB) continue;
                            objectsChanged.put((DBObject)ResultSetApplier.this.getOriginalObject(difference2), new ResultSetChange(difference2));
                        }
                    }
                } else if (difference.isMap()) {
                    GenericDBObjectComparator genericDBObjectComparator;
                    Object updated = ResultSetApplier.this.getUpdatedObject(difference);
                    Object original = ResultSetApplier.this.getOriginalObject(difference);
                    if (updated instanceof DBObject && original instanceof DBObject && (genericDBObjectComparator = new GenericDBObjectComparator()).compare(updated, original) == 0) {
                        propChange = false;
                        objectsChanged.put((DBObject)original, new ResultSetChange(difference));
                    }
                }
                if (!propChange) continue;
                String propName = difference.getPropertyName();
                PropertyChangeEvent pce = new PropertyChangeEvent(this.getDBObject(), propName, ResultSetApplier.this.getOriginalObject(difference), ResultSetApplier.this.getUpdatedObject(difference));
                propsChanged.put(propName, pce);
            }
            this.m_objectsAdded = Collections.unmodifiableList(objectsAdded);
            this.m_objectsRemoved = Collections.unmodifiableList(objectsRemoved);
            this.m_objectsChanged = Collections.unmodifiableMap(objectsChanged);
            this.m_propsChanged = Collections.unmodifiableMap(propsChanged);
        }

        @Override
        public boolean hasNameChanged() {
            if (this.m_rs == null) {
                DBObject obj = this.getDBObject();
                return DBUtil.getNameComparator().compare(this.m_lazyDiffObj, obj) != 0;
            }
            return super.hasNameChanged();
        }

        @Override
        public PropertyChangeEvent getPropertyChange(String propertyName) {
            Object newVal;
            Object oldVal;
            Object retval = this.m_lazyDiffObj != null && ("ID".equals(propertyName) || "schema".equals(propertyName) || "name".equals(propertyName) || "type".equals(propertyName)) ? (ModelUtil.areEqual((Object)(oldVal = this.m_lazyDiffObj.getProperty(propertyName)), (Object)(newVal = this.getDBObject().getProperty(propertyName))) ? null : new PropertyChangeEvent(this.getDBObject(), propertyName, oldVal, newVal)) : super.getPropertyChange(propertyName);
            return retval;
        }
    }
}

