/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.diff;

import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.diff.DifferenceFilter;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.DynamicPropertySet;
import oracle.javatools.util.DynamicPropertySetImpl;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Difference
implements Copyable,
DynamicPropertySet {
    private boolean m_same;
    private DynamicPropertySet m_props;
    private Difference m_parent;

    public Difference getParent() {
        return this.m_parent;
    }

    protected void setParent(Difference parent) {
        this.m_parent = parent;
    }

    public abstract String getPropertyName();

    public String getPropertyPath() {
        String parentPath;
        String propName = this.getPropertyName();
        String string = parentPath = this.m_parent == null ? null : this.m_parent.getPropertyPath();
        String path = ModelUtil.hasLength((String)parentPath) ? (ModelUtil.hasLength((String)propName) ? parentPath + "/" + propName : parentPath) : propName;
        return path;
    }

    public abstract boolean isModified();

    public boolean isSame() {
        return this.m_same;
    }

    public void setSame(boolean same) {
        this.m_same = same;
    }

    public abstract boolean isLeaf();

    public abstract boolean isMap();

    public abstract boolean isList();

    public abstract Object getObject(String var1);

    public abstract int getIndexOf(String var1);

    public abstract void setUpdateContributor(String var1);

    public abstract String getOriginalContributor();

    public abstract String getUpdateContributor();

    public abstract Collection<? extends Difference> getChildren();

    public abstract Class getDifferenceClass();

    public final Object getOriginalObject() {
        return this.getObject(this.getOriginalContributor());
    }

    public final Object getUpdatedObject() {
        return this.getObject(this.getUpdateContributor());
    }

    public final int getIndexOfOriginalObject() {
        return this.getIndexOf(this.getOriginalContributor());
    }

    public final int getIndexOfUpdatedObject() {
        return this.getIndexOf(this.getUpdateContributor());
    }

    public Difference getFilteredDifference(DifferenceFilter ... filters) {
        Difference retval = (Difference)this.copyTo(null);
        if (filters != null && filters.length > 0) {
            retval.applyFilters(filters);
        }
        return retval;
    }

    /*
     * WARNING - void declaration
     */
    private void applyFilters(DifferenceFilter ... filters) {
        block6: {
            if (this.isSame()) break block6;
            if (this.isLeaf()) {
                void var3_5;
                String propPath = this.getPropertyPath();
                boolean bl = false;
                while (var3_5 < filters.length && !this.isSame()) {
                    if (filters[var3_5].isFilteredProperty(this, propPath)) {
                        this.setSame(true);
                    }
                    ++var3_5;
                }
            } else {
                for (Difference difference : this.getChildren()) {
                    difference.applyFilters(filters);
                }
                this.setSame(true);
                for (Difference difference : this.getChildren()) {
                    if (difference.isSame()) continue;
                    this.setSame(false);
                    break;
                }
            }
        }
    }

    public final Map getProperties() {
        return this.m_props == null ? null : this.m_props.getProperties();
    }

    public final Object getProperty(String key) {
        return this.m_props == null ? null : this.m_props.getProperty(key);
    }

    public final Object getProperty(String key, Object defaultValue) {
        return this.m_props == null ? defaultValue : this.m_props.getProperty(key, defaultValue);
    }

    public final void setProperties(Map properties) {
        if (this.m_props == null) {
            this.m_props = new DynamicPropertySetImpl();
        }
        this.m_props.setProperties(properties);
    }

    public final void setProperty(String key, Object value) {
        if (this.m_props == null) {
            this.m_props = new DynamicPropertySetImpl();
        }
        this.m_props.setProperty(key, value);
    }

    protected void copyToImpl(Difference other) {
        other.m_same = this.m_same;
        other.m_props = this.m_props == null ? null : (DynamicPropertySet)this.m_props.copyTo(null);
    }

    public final void print() {
        this.print(DBLog.getLogger(this), DBLog.getTraceLogLevel());
    }

    public final void print(Logger logger, Level level) {
        if (logger.isLoggable(level)) {
            StringBuilder buff = new StringBuilder("\n");
            this.toString(buff, "");
            logger.log(level, buff.toString());
        }
    }

    private void toString(StringBuilder buff, String indent) {
        buff.append(indent).append(this.toString()).append("\n");
        indent = indent + "  ";
        for (Difference difference : this.getChildren()) {
            difference.toString(buff, indent);
        }
    }

    public String toString() {
        String spacer = "  ";
        StringBuilder buff = new StringBuilder();
        buff.append(this.isSame() ? "SAME " : "XXXX ").append("  ");
        buff.append(this.getPropertyName());
        if (this.isLeaf()) {
            buff.append("  ").append("(").append(String.valueOf(this.getOriginalObject())).append(" : ").append(String.valueOf(this.getUpdatedObject())).append(")");
        }
        int origI = this.getIndexOfOriginalObject();
        int updI = this.getIndexOfUpdatedObject();
        if (origI >= 0 || updI >= 0) {
            buff.append("  ").append(origI + " " + updI);
        }
        return buff.toString();
    }
}

