/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.dictionary;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import oracle.javatools.db.AbstractBuildableObject;
import oracle.javatools.db.AbstractDBObjectBuilder;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBException;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectBuilder;
import oracle.javatools.db.DBObjectCriteria;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectLister;
import oracle.javatools.db.Database;
import oracle.javatools.db.IdentifierBasedID;
import oracle.javatools.db.Index;
import oracle.javatools.db.NameBasedID;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.Table;
import oracle.javatools.db.ddl.DDLDatabase;
import oracle.javatools.db.dictionary.DictionaryQueries;
import oracle.javatools.db.execute.ConnectionWrapper;
import oracle.javatools.db.execute.QueryWrapper;
import oracle.javatools.db.extension.DBObjectRegistry;
import oracle.javatools.util.Holder;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DictionaryDatabase
extends DDLDatabase {
    private String m_username;
    private Map<String, DBObjectLister> m_listers;

    protected DictionaryDatabase(String connStore, String connName, Connection conn) {
        super(connStore, connName, conn);
    }

    protected final QueryWrapper newQueryWrapper(String query, Object ... params) {
        return this.newQueryWrapper(query, Arrays.asList(params));
    }

    protected QueryWrapper newQueryWrapper(String query, List params) {
        return new QueryWrapper((Database)this, query, params);
    }

    protected abstract DictionaryQueries getDictionaryQueries();

    protected boolean isSupportedType(String type) {
        return this.getBuilderForType(type) != null;
    }

    @Override
    public boolean supportsTimestamps(String objectType) {
        return this.getDictionaryQueries().getTimestampQueryByID() != null || this.getDictionaryQueries().getTimestampQueryByName(objectType) != null;
    }

    protected QueryWrapper[] getListQueries(DBObjectCriteria<? extends SystemObject> criteria) {
        QueryWrapper[] wrappers;
        QueryWrapper qw;
        List<String> params;
        String query;
        DictionaryQueries dictionary = this.getDictionaryQueries();
        ArrayList<QueryWrapper> queries = new ArrayList<QueryWrapper>();
        String ref = criteria.getNameLike();
        if (!ModelUtil.hasLength((String)ref)) {
            ref = "%";
        }
        Schema defSchema = null;
        Schema schema = null;
        try {
            schema = this.findSchema(criteria.getSchemaName());
            if (schema != null) {
                defSchema = this.getDefaultSchema();
            }
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, "Couldn't get schemas : " + dbe.getMessage());
        }
        String schemaName = criteria.getSchemaName();
        boolean defaultSchema = ModelUtil.areEqual((Object)schemaName, (Object)(defSchema == null ? null : defSchema.getName()));
        ArrayList<String> standardObj = new ArrayList<String>();
        for (String type : criteria.getTypes()) {
            if (!this.isSupportedType(type)) continue;
            if (dictionary.isCustomListQuery(type, defaultSchema, criteria)) {
                query = dictionary.getCustomListQuery(type, defaultSchema, criteria);
                params = this.getParameters(dictionary.getCustomListQueryParams(type, defaultSchema, criteria), schema, ref, new String[]{type});
                qw = this.newQueryWrapper(query, params);
                qw.setIdentifier(type);
                queries.add(qw);
                continue;
            }
            standardObj.add(type);
        }
        Object standardQueryParams = null;
        if (standardObj.size() > 0) {
            String[] standardTypes = standardObj.toArray(new String[standardObj.size()]);
            query = dictionary.getStandardListQuery(standardTypes);
            params = this.getParameters(dictionary.getStandardListQueryParams(), schema, ref, standardTypes);
            qw = this.newQueryWrapper(query, params);
            queries.add(0, qw);
        }
        if ((wrappers = queries.toArray(new QueryWrapper[queries.size()])).length > 1 && dictionary.canUnionListQueries()) {
            wrappers = new QueryWrapper[]{QueryWrapper.union(wrappers)};
        }
        return wrappers;
    }

    private String convertArrayToList(String[] types) {
        StringBuffer buf = new StringBuffer(types.length * 32);
        if (types.length > 0) {
            buf.append('\'').append(types[0]).append('\'');
            for (int i = 1; i < types.length; ++i) {
                buf.append(',').append('\'').append(types[i]).append('\'');
            }
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected <T extends SystemObject> Collection<T> listObjectsImpl(DBObjectCriteria<T> criteria) throws DBException {
        Object maxi;
        final ArrayList<DBObjectLister.ObjectInfo> objectInfos = new ArrayList<DBObjectLister.ObjectInfo>();
        final Schema schema = this.findSchema(criteria.getSchemaName());
        QueryWrapper[] queries = this.getListQueries(criteria);
        if (queries != null) {
            maxi = null;
            try {
                maxi = Integer.getInteger("oracle.db.MaxFetchCount");
            }
            catch (NumberFormatException nfe) {
                // empty catch block
            }
            final int maxCount = maxi == null ? Integer.MAX_VALUE : (Integer)maxi;
            for (int i = 0; i < queries.length; ++i) {
                final QueryWrapper wrap = queries[i];
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            int count = 0;
                            while (rs.next() && !Thread.currentThread().isInterrupted()) {
                                String type;
                                int cols = rs.getMetaData().getColumnCount();
                                String name = rs.getString(1);
                                String string = type = cols < 2 ? wrap.getIdentifier() : rs.getString(2).trim();
                                if (!ModelUtil.hasLength((String)type)) {
                                    throw new DBException(null, "Query is listing objects with an unknown type.");
                                }
                                if (!DictionaryDatabase.this.supportsObjectType(type = type.toUpperCase())) {
                                    DictionaryDatabase.this.getLogger().log(Level.WARNING, "Unsupported object type: " + type);
                                } else {
                                    Object idVal;
                                    Object object = idVal = cols < 3 ? null : rs.getObject(3);
                                    if (idVal instanceof String && ((String)idVal).equalsIgnoreCase("null") || idVal instanceof Number && ((Number)idVal).intValue() == 0) {
                                        idVal = null;
                                    }
                                    objectInfos.add(new DBObjectLister.ObjectInfo(type, schema, name, idVal));
                                    if (++count < maxCount) continue;
                                }
                                break;
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(sqe);
                        }
                    }
                };
                queries[i].executeQuery(500, r);
            }
        }
        if (DBObjectRegistry.isActive()) {
            maxi = this;
            synchronized (maxi) {
                if (this.m_listers == null) {
                    this.m_listers = DBObjectRegistry.getInstance().getListers(this.getDatabaseType(), this.getDatabaseVersion(), this);
                }
                HashSet<DBObjectLister> listers = new HashSet<DBObjectLister>();
                for (String type : criteria.getTypes()) {
                    DBObjectLister lister = this.m_listers.get(type);
                    if (lister == null) continue;
                    listers.add(lister);
                }
                for (DBObjectLister lister : listers) {
                    Collection<DBObjectLister.ObjectInfo> infos = lister.listObjects(criteria);
                    if (infos == null) continue;
                    objectInfos.addAll(infos);
                }
            }
        }
        ArrayList<SystemObject> objects = new ArrayList<SystemObject>();
        for (DBObjectLister.ObjectInfo info : objectInfos) {
            Object idVal;
            String name;
            String type;
            type = info.getType();
            SystemObject object = this.findOrCreateObject(type, schema, name = info.getName(), idVal = info.getIdentifier());
            if (object == null) continue;
            objects.add(object);
        }
        return objects;
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, Schema schema, String nameref, String[] typeList) {
        return this.getParameters(params, schema == null ? null : schema.getName(), nameref, typeList);
    }

    protected final List<String> getParameters(DictionaryQueries.Params[] params, String schema, String nameref, String[] typeList) {
        ArrayList<String> retval = new ArrayList<String>();
        block6: for (int i = 0; i < params.length; ++i) {
            switch (params[i]) {
                case SCHEMA: {
                    retval.add(schema);
                    continue block6;
                }
                case NAMEREF: {
                    retval.add(nameref);
                    continue block6;
                }
                case TYPES: {
                    String typeListString = this.convertArrayToList(typeList);
                    retval.add(typeListString);
                    continue block6;
                }
                case ALL_TYPES: {
                    retval.addAll(Arrays.asList(typeList));
                }
            }
        }
        return retval;
    }

    @Override
    protected final Long getExternalTimestampImpl(SystemObject obj) throws DBException {
        Long ts;
        if (!(obj instanceof SchemaObject)) {
            return null;
        }
        SchemaObject object = (SchemaObject)obj;
        DBObjectID id = object.getID();
        Long l = ts = id != null ? this.getExternalTimestampByID(id) : this.getExternalTimestampByName(object.getType(), object.getSchema(), object.getName());
        if (ts != null) {
            AbstractDBObjectBuilder tableBuilder;
            String type = object.getType();
            if ("PACKAGE".equals(type) || "TYPE".equals(type)) {
                Long tsBody = this.getExternalTimestampByName(type + " BODY", object.getSchema(), object.getName());
                if (tsBody != null && tsBody.compareTo(ts) > 0) {
                    ts = tsBody;
                }
            } else if ("TABLE".equals(type) && !(tableBuilder = (AbstractDBObjectBuilder)this.getBuilderForType(type)).needsBuilding((Table)object, "indexes", true)) {
                String key = "5501663 : Suspend getting timestamps while getting indexes";
                this.suspendTimestampQueries(key);
                Index[] indexes = ((Table)object).getIndexes();
                this.resumeTimestampQueries(key);
                for (Index index : indexes) {
                    Long idxTs = this.getExternalTimestamp(index);
                    if (idxTs == null && index.getID() != null) {
                        idxTs = this.getExternalTimestampByName(index.getType(), index.getSchema(), index.getName());
                    }
                    if (idxTs == null) {
                        Long existing = (Long)object.getProperty("Timestamp");
                        if (existing == null || !existing.equals(ts)) continue;
                        Long l2 = ts;
                        Long l3 = ts = Long.valueOf(ts + 1L);
                        continue;
                    }
                    if (idxTs.compareTo(ts) <= 0) continue;
                    ts = idxTs;
                }
            }
        }
        return ts;
    }

    protected final Long getExternalTimestampByID(DBObjectID id) throws DBException {
        Long result = null;
        String query = this.getDictionaryQueries().getTimestampQueryByID();
        if (id instanceof IdentifierBasedID && query != null) {
            final Holder holder = new Holder();
            final QueryWrapper qw = this.newQueryWrapper(query, ((IdentifierBasedID)id).getIdentifier());
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        Timestamp t;
                        if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(t.getTime()));
                        }
                    }
                    catch (SQLException ex) {
                        qw.throwDBException(ex);
                    }
                }
            };
            qw.executeQuery(r);
            result = (Long)holder.get();
        } else if (id instanceof BaseObjectID) {
            BaseObjectID baseID = (BaseObjectID)id;
            Schema s = this.findSchema(baseID.getSchemaName());
            result = this.getExternalTimestampByName(baseID.getType(), s, baseID.getName());
        }
        return result;
    }

    protected final Long getExternalTimestampByName(String type, Schema schema, String objectName) {
        Long result = null;
        String query = this.getDictionaryQueries().getTimestampQueryByName(type);
        if (query != null) {
            final Holder holder = new Holder();
            final QueryWrapper qw = this.newQueryWrapper(query, schema, objectName, type);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        Timestamp t;
                        if (rs.next() && (t = rs.getTimestamp(1)) != null) {
                            holder.set((Object)new Long(t.getTime()));
                        }
                    }
                    catch (SQLException ex) {
                        qw.throwDBException(ex);
                    }
                }
            };
            try {
                qw.executeQuery(r);
            }
            catch (DBException dbe) {
                // empty catch block
            }
            result = (Long)holder.get();
        }
        return result;
    }

    protected synchronized Map<String, Schema> loadSchemasImpl() throws DBException {
        final TreeMap<String, Schema> schemas = new TreeMap<String, Schema>();
        final QueryWrapper wrap = this.newQueryWrapper(this.getDictionaryQueries().getSchemasQuery(), new Object[0]);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    while (rs.next()) {
                        String username = rs.getString(1);
                        schemas.put(username, DictionaryDatabase.this.createSchema(username));
                    }
                }
                catch (SQLException ex) {
                    wrap.throwDBException(ex);
                }
            }
        };
        wrap.executeQuery(500, r);
        return schemas;
    }

    @Override
    public final boolean exists(String type, String schema, String name) {
        DictionaryQueries dictionary = this.getDictionaryQueries();
        String query = dictionary.getExistsQuery(type);
        if (query == null) {
            return super.exists(type, schema, name);
        }
        final Holder exists = new Holder((Object)false);
        List<String> params = this.getParameters(dictionary.getExistsQueryParams(type), schema, name, new String[]{type});
        final QueryWrapper wrap = this.newQueryWrapper(query, params);
        QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

            public void processResultSet(ResultSet rs) throws DBException {
                try {
                    exists.set((Object)rs.next());
                }
                catch (SQLException sqe) {
                    wrap.throwDBException(sqe);
                }
            }
        };
        try {
            wrap.executeQuery(r);
        }
        catch (DBException dbe) {
            this.getLogger().log(Level.WARNING, DBArb.format(377, type, name, dbe.getMessage()));
        }
        return (Boolean)exists.get();
    }

    @Override
    public final boolean isObjectValid(String objectType, String schema, String objectName) {
        boolean retval;
        DictionaryQueries dictionary = this.getDictionaryQueries();
        String query = dictionary.getObjectStatusQuery(objectType);
        if (query == null) {
            retval = super.isObjectValid(objectType, schema, objectName);
        } else {
            List<String> params = this.getParameters(dictionary.getObjectStatusQueryParams(objectType), schema, objectName, new String[]{objectType});
            final QueryWrapper wrap = this.newQueryWrapper(query, params);
            final Holder valid = new Holder((Object)false);
            QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                public void processResultSet(ResultSet rs) throws DBException {
                    try {
                        if (rs.next()) {
                            String state = rs.getString(1);
                            valid.set((Object)"VALID".equalsIgnoreCase(state));
                        }
                    }
                    catch (SQLException sqe) {
                        wrap.throwDBException(sqe);
                    }
                }
            };
            try {
                wrap.executeQuery(r);
            }
            catch (DBException dbe) {
                this.getLogger().log(Level.WARNING, DBArb.format(379, dbe.getMessage()));
            }
            retval = (Boolean)valid.get();
        }
        return retval;
    }

    @Override
    protected final SystemObject createByIDImpl(final DBObjectID id) throws DBException {
        AbstractBuildableObject object = null;
        String type = id.getType();
        final DBObjectBuilder builder = this.getBuilderForType(type);
        if (builder != null) {
            String name;
            Schema owner;
            Collection<SystemObject> queried;
            boolean setupObj = true;
            if (id instanceof IdentifierBasedID) {
                String query;
                Object ident = ((IdentifierBasedID)id).getIdentifier();
                if (builder != null && (query = this.getDictionaryQueries().getObjectQueryByID(type)) != null) {
                    final Holder holder = new Holder();
                    final QueryWrapper wrap = this.newQueryWrapper(query, ident);
                    QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                        public void processResultSet(ResultSet rs) throws DBException {
                            try {
                                if (rs.next()) {
                                    Schema owner = DictionaryDatabase.this.findSchema(rs.getString(1));
                                    String name = rs.getString(2);
                                    holder.set((Object)((AbstractBuildableObject)builder.createObject(name, owner, id)));
                                }
                            }
                            catch (SQLException ex) {
                                wrap.throwDBException((DBObject)holder.get(), ex);
                            }
                        }
                    };
                    wrap.executeQuery(r);
                    object = (AbstractBuildableObject)holder.get();
                }
            } else if (id instanceof NameBasedID && (queried = this.listObjectsImpl(new String[]{type}, owner = this.findSchema(((NameBasedID)id).getSchemaName()), name = ((NameBasedID)id).getName())) != null && queried.size() == 1) {
                setupObj = false;
                object = (AbstractBuildableObject)queried.iterator().next();
            }
            if (object != null && setupObj) {
                object.setID(id);
                this.markForLazyInit(object);
                this.cacheObject(object, true);
            }
        } else {
            object = (AbstractBuildableObject)super.createByIDImpl(id);
        }
        return object;
    }

    @Override
    protected final String getAliveTestStatement() {
        DictionaryQueries queries = this.getDictionaryQueries();
        return queries == null ? null : queries.getAliveTestStatement();
    }

    @Override
    public void close() {
        super.close();
        this.m_username = null;
    }

    @Override
    public final synchronized String getUserName() {
        DictionaryQueries queries = this.getDictionaryQueries();
        if (this.m_username == null) {
            String userQuery = queries.getUserNameQuery();
            if (userQuery == null) {
                try {
                    ConnectionWrapper wrapper = new ConnectionWrapper(this, "Query username from connection metadata");
                    this.m_username = wrapper.call(new ConnectionWrapper.SQLCallable<String>(wrapper){

                        @Override
                        public String call() throws SQLException {
                            return this.getConnection().getMetaData().getUserName();
                        }
                    });
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, DBArb.format(382, dbe.getMessage()));
                }
            } else {
                final QueryWrapper wrap = this.newQueryWrapper(userQuery, new Object[0]);
                final Holder name = new Holder();
                QueryWrapper.QueryRunnable r = new QueryWrapper.QueryRunnable(){

                    public void processResultSet(ResultSet rs) throws DBException {
                        try {
                            if (rs.next()) {
                                name.set((Object)rs.getString(1));
                            }
                        }
                        catch (SQLException sqe) {
                            wrap.throwDBException(sqe);
                        }
                    }
                };
                try {
                    wrap.executeQuery(r);
                }
                catch (DBException dbe) {
                    this.getLogger().log(Level.WARNING, DBArb.format(382, dbe.getMessage()));
                }
                this.m_username = (String)name.get();
            }
        }
        return this.m_username;
    }
}

