/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.ddl;

import java.util.ArrayList;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Ddl;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SchemaObject;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.ddl.DDL;
import oracle.javatools.db.ddl.DDLGenerator;
import oracle.javatools.db.ddl.DDLOptions;
import oracle.javatools.db.ddl.DDLType;
import oracle.javatools.db.ddl.UnsupportedDDLException;
import oracle.javatools.db.diff.Difference;
import oracle.javatools.db.diff.ResultSet;
import oracle.javatools.db.property.AbstractPropertyManager;
import oracle.javatools.db.property.PropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractDDLGenerator<T extends DDLType>
extends AbstractPropertyManager
implements DDLGenerator<T> {
    protected AbstractDDLGenerator(DBObjectProvider pro) {
        super(pro);
    }

    @Override
    public boolean supportsAction(String type, PropertyAction.Type action) {
        return false;
    }

    @Override
    protected boolean canCreate(String type, String prop) {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final DDL<T> getCreateDDL(DDLOptions options, DBObject ... objects) {
        void var6_8;
        ArrayList<DDL<T>> ddls = new ArrayList<DDL<T>>();
        DBObject[] arr$ = objects;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            DDL<T> ddl;
            DBObject obj = arr$[var6_8];
            if (obj != null && (ddl = this.getCreateDDLImpl(options, obj)) != null && ddl.size() > 0) {
                ddls.add(ddl);
            }
            ++var6_8;
        }
        DDL ddl = new DDL();
        if (ddls.size() > 0) {
            for (DDL dDL : ddls) {
                ddl.append(dDL);
            }
        }
        return ddl;
    }

    protected abstract DDL<T> getCreateDDLImpl(DDLOptions var1, DBObject ... var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public final DDL<T> getDeleteDDL(DDLOptions options, DBObject ... objects) {
        void var6_8;
        ArrayList<DDL<T>> ddls = new ArrayList<DDL<T>>();
        DBObject[] arr$ = objects;
        int len$ = arr$.length;
        boolean bl = false;
        while (var6_8 < len$) {
            DBObject obj = arr$[var6_8];
            DDL<T> ddl = this.getDeleteDDLImpl(options, obj);
            if (ddl != null && ddl.size() > 0) {
                ddls.add(ddl);
            }
            ++var6_8;
        }
        if (ddls.size() > 0) {
            DDL ddl = new DDL();
            for (DDL dDL : ddls) {
                ddl.append(dDL);
            }
            return ddl;
        }
        return null;
    }

    protected abstract DDL<T> getDeleteDDLImpl(DDLOptions var1, DBObject ... var2);

    @Override
    public final DDL<T> getUpdateDDL(DDLOptions options, Difference resultSet) {
        DDL ddl = new DDL();
        if ((resultSet.isMap() || resultSet.isLeaf()) && SystemObject.class.isAssignableFrom(resultSet.getDifferenceClass())) {
            this.processResultSet(options, resultSet, ddl);
        } else if (resultSet.isList()) {
            for (Difference difference : resultSet.getChildren()) {
                this.processResultSet(options, difference, ddl);
            }
        } else {
            DBLog.getLogger(this).warning("unexpected Difference type for DDL");
        }
        return ddl;
    }

    protected final void processResultSet(DDLOptions options, Difference rs, DDL<T> ddl) {
        if (!rs.isSame()) {
            SystemObject updated = (SystemObject)rs.getUpdatedObject();
            if (updated == null) {
                ddl.append(this.getDeleteDDL(options, (SystemObject)rs.getOriginalObject()));
            } else if (rs.getOriginalObject() == null) {
                ddl.append(this.getCreateDDL(options, updated));
            } else {
                DDL<T> updateDDL = null;
                updateDDL = this.getUpdateDDLImpl(options, rs);
                if (updateDDL == null || updateDDL.size() == 0) {
                    throw UnsupportedDDLException.updateNotSupported(updated);
                }
                ddl.append(updateDDL);
            }
        }
    }

    protected abstract DDL<T> getUpdateDDLImpl(DDLOptions var1, Difference var2);

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject obj, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), obj).convertToLegacy();
    }

    @Deprecated
    public final Ddl getCreateDDL(SchemaObject[] objects, boolean replace, boolean cascade) {
        return this.getCreateDDL(new DDLOptions(replace, cascade), objects).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject object, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), object).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(SchemaObject[] objects, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(true, cascade), objects).convertToLegacy();
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject oldObject, SchemaObject newObject) {
        return this.getUpdateDDL(new SchemaObject[]{oldObject}, new SchemaObject[]{newObject});
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(SchemaObject[] oldObjects, SchemaObject[] newObjects) {
        ResultSet rs = this.getProvider().getDiffEngine().diff(oldObjects, newObjects).getResult();
        return this.getUpdateDDL(rs, false, false);
    }

    @Deprecated
    public final Ddl[] getUpdateDDL(Difference resultSet, boolean replace, boolean cascade) {
        return this.getUpdateDDL(new DDLOptions(replace, cascade), resultSet).convertToLegacyArray();
    }

    @Deprecated
    public final Ddl getCreateDDL(Schema schema) {
        return this.getCreateDDL(new DDLOptions(), schema).convertToLegacy();
    }

    @Deprecated
    public final Ddl getDeleteDDL(Schema schema, boolean cascade) {
        return this.getDeleteDDL(new DDLOptions(false, cascade), schema).convertToLegacy();
    }
}

