/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeHelper;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.PredefinedDataType;
import oracle.javatools.db.sql.ParserUtils;
import oracle.javatools.db.sql.SQLQueryException;
import oracle.javatools.parser.plsql.data.PlsqlNode;
import oracle.javatools.parser.plsql.data.PlsqlRoot;
import oracle.javatools.util.ModelUtil;

public class NumericDataType
extends PredefinedDataType {
    public static final DataTypeAttribute UNSIGNED = new DataTypeAttribute("unsigned", 170, new String[]{"UNSIGNED"}, null, false, false);
    public static final MinMaxValue MIN_MAX_BIGINT = new MinMaxValue("-9223372036854775808", "9223372036854775807", 0);
    public static final MinMaxValue MIN_MAX_INT = new MinMaxValue("-2147483648", "2147483647", 0);
    public static final MinMaxValue MIN_MAX_MEDIUMINT = new MinMaxValue("-8388608", "8388607", 0);
    public static final MinMaxValue MIN_MAX_SMALLINT = new MinMaxValue("-32768", "32767", 0);
    public static final MinMaxValue MIN_MAX_SIGNED_TINYINT = new MinMaxValue("-128", "127", 0);
    public static final MinMaxValue MIN_MAX_UNSIGNED_TINYINT = new MinMaxValue("0", "255", 1);
    public static final MinMaxValue MIN_MAX_MONEY = new MinMaxValue("-922337203685477.5808", "922337203685477.5807", 0);
    public static final MinMaxValue MIN_MAX_SMALLMONEY = new MinMaxValue("-214748.3648", "214748.3647", 0);
    public static final MinMaxValue MIN_MAX_BIT = new MinMaxValue("0", "1", 1);
    private static final BigDecimal DECIMAL_0 = new BigDecimal("0");
    private static final BigDecimal DECIMAL_1 = new BigDecimal("1");
    private static final BigDecimal DECIMAL_2 = new BigDecimal("2");
    private int m_valueType = -1;
    private BigDecimal m_minIntValue;
    private BigDecimal m_maxIntValue;
    private BigDecimal m_maxUnsignedValue;
    private BigDecimal m_minNegativeValue;
    private BigDecimal m_maxNegativeValue;
    private BigDecimal m_minPositiveValue;
    private BigDecimal m_maxPositiveValue;

    public NumericDataType() {
    }

    public NumericDataType(int domain, String name, MinMaxValue minMaxValues) {
        super(domain, name);
        this.setMinMaxValues(minMaxValues);
    }

    public NumericDataType(int domain, String name, String definition, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
    }

    public NumericDataType(int domain, String name, String definition, long minPrecision, long maxPrecision, Long defaultPrecision, boolean isPrecisionMandatory, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
        this.addAttribute(new DataTypeAttribute("precision", 158, minPrecision, new Long(maxPrecision), defaultPrecision, isPrecisionMandatory), 0);
    }

    public NumericDataType(int domain, String name, String definition, long minPrecision, long maxPrecision, Long defaultPrecision, boolean isPrecisionMandatory, long minScale, Long maxScale, Long defaultScale, boolean isScaleMandatory, DataTypeAttribute[] attributes, MinMaxValue minMaxValues) {
        super(domain, name, definition, attributes);
        this.setMinMaxValues(minMaxValues);
        this.addAttribute(new DataTypeAttribute("precision", 158, minPrecision, new Long(maxPrecision), defaultPrecision, isPrecisionMandatory), 0);
        this.addAttribute(new DataTypeAttribute("scale", 159, minScale, maxScale, defaultScale, isScaleMandatory), 1);
    }

    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        NumericDataType target = (NumericDataType)other;
        super.copyToImpl(target, copyParent, idPolicy);
        target.m_valueType = this.m_valueType;
        target.m_minIntValue = this.m_minIntValue;
        target.m_maxIntValue = this.m_maxIntValue;
        target.m_maxUnsignedValue = this.m_maxUnsignedValue;
        target.m_minPositiveValue = this.m_minPositiveValue;
        target.m_minNegativeValue = this.m_minNegativeValue;
        target.m_maxPositiveValue = this.m_maxPositiveValue;
        target.m_maxNegativeValue = this.m_maxNegativeValue;
    }

    protected boolean equalsImpl(AbstractDBObject target) {
        NumericDataType other = (NumericDataType)target;
        return super.equalsImpl(other) && this.m_valueType == other.m_valueType && ModelUtil.areEqual((Object)this.m_minIntValue, (Object)other.m_minIntValue) && ModelUtil.areEqual((Object)this.m_maxIntValue, (Object)other.m_maxIntValue) && ModelUtil.areEqual((Object)this.m_minPositiveValue, (Object)other.m_minPositiveValue) && ModelUtil.areEqual((Object)this.m_maxPositiveValue, (Object)other.m_maxPositiveValue);
    }

    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
        super.validateUsage(dataTypeUsage, dbObject);
        DataTypeAttribute precisionAttr = this.getDataTypeAttribute("precision");
        DataTypeAttribute scaleAttr = this.getDataTypeAttribute("scale");
        if (precisionAttr != null && scaleAttr != null && scaleAttr.isDeclarable() && dataTypeUsage.hasAttributeValue("scale")) {
            Long precisionVal = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
            if (precisionVal == null) {
                precisionVal = (Long)precisionAttr.getDefaultValue();
            }
            if (scaleAttr.getMaxValue() == null) {
                if (precisionVal == null) {
                    throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(196, scaleAttr.getMinValue()));
                }
                Long scaleVal = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale");
                if (scaleVal != null && scaleVal.compareTo(precisionVal) > 0) {
                    throw new DataTypeValidationException(dbObject, this.getName(), DBArb.format(197, precisionVal));
                }
            }
        }
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
        if (dataTypeUsage != null && defaultValue != null) {
            String strDefaultValue = defaultValue.toString().trim();
            PlsqlNode node = null;
            try {
                PlsqlRoot parseTree = ParserUtils.parseQueryString(strDefaultValue, 2);
                if (parseTree.getUnits().length != 1) {
                    DBLog.log("Expecting 1 parse unit but got " + parseTree.getUnits().length, new Object[0]);
                    return;
                }
                node = parseTree.getUnits()[0];
                ParserUtils.checkErrors(parseTree, strDefaultValue);
            }
            catch (SQLQueryException x) {
                throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(212, x.getMessage()));
            }
            if (ParserUtils.isConstant(node)) {
                Long scaleVal;
                BigDecimal value = null;
                try {
                    String nodeValue = ParserUtils.getConstant(node);
                    if (nodeValue.length() > 0 && nodeValue.charAt(0) == '\'') {
                        nodeValue = nodeValue.substring(1, nodeValue.length() - 1);
                    }
                    if (nodeValue.length() == 0) {
                        return;
                    }
                    if ((nodeValue = nodeValue.trim()).length() == 0) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.getString(213));
                    }
                    value = new BigDecimal(nodeValue);
                }
                catch (NumberFormatException nfe) {
                    throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.getString(213));
                }
                DataTypeAttribute precisionAttr = this.getDataTypeAttribute("precision");
                DataTypeAttribute scaleAttr = this.getDataTypeAttribute("scale");
                Long precisionVal = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "precision");
                if (precisionVal == null && precisionAttr != null) {
                    precisionVal = (Long)precisionAttr.getDefaultValue();
                }
                if ((scaleVal = DataTypeHelper.getLongAttributeValue(dataTypeUsage, "scale")) == null && scaleAttr != null) {
                    scaleVal = (Long)scaleAttr.getDefaultValue();
                }
                if (precisionVal != null && scaleVal != null) {
                    int defaultValueScale = value.scale();
                    BigInteger unscaledValue = value.abs().unscaledValue();
                    String strUnscaledValue = unscaledValue.toString();
                    int defaultValuePrecision = strUnscaledValue.length();
                    for (int s = 0; defaultValuePrecision > 0 && s < defaultValueScale && strUnscaledValue.charAt(defaultValuePrecision - 1) == '0'; --defaultValuePrecision, ++s) {
                    }
                    if (defaultValueScale == 0) {
                        defaultValueScale = defaultValuePrecision - strUnscaledValue.length();
                    }
                    if (scaleVal.intValue() >= 0) {
                        if (defaultValueScale > scaleVal.intValue()) {
                            throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(207, new Long(defaultValueScale), scaleVal));
                        }
                    } else if (defaultValueScale > 0) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.getString(210));
                    }
                    if (defaultValuePrecision - defaultValueScale > precisionVal.intValue() - scaleVal.intValue()) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(206, strDefaultValue, precisionVal, scaleVal));
                    }
                } else {
                    boolean isUnsigned;
                    boolean validValue = false;
                    boolean bl = isUnsigned = dataTypeUsage.getAttributeValue("unsigned") != null;
                    if (this.m_valueType == 2) {
                        if (value.compareTo(DECIMAL_0) == 0 || (this.m_minPositiveValue == null || value.compareTo(this.m_minPositiveValue) >= 0) && (this.m_maxPositiveValue == null || value.compareTo(this.m_maxPositiveValue) <= 0)) {
                            validValue = true;
                        }
                        if (!(isUnsigned || this.m_minNegativeValue != null && value.compareTo(this.m_minNegativeValue) < 0 || this.m_maxNegativeValue != null && value.compareTo(this.m_maxNegativeValue) > 0)) {
                            validValue = true;
                        }
                    } else if (this.m_valueType == 0) {
                        BigDecimal maxValue;
                        BigDecimal minValue = isUnsigned ? DECIMAL_0 : this.m_minIntValue;
                        BigDecimal bigDecimal = maxValue = isUnsigned ? this.m_maxUnsignedValue : this.m_maxIntValue;
                        if (!(minValue != null && value.compareTo(minValue) < 0 || maxValue != null && value.compareTo(maxValue) > 0)) {
                            validValue = true;
                        }
                    } else if (this.m_valueType == 1) {
                        if (!(this.m_minIntValue != null && value.compareTo(this.m_minIntValue) < 0 || this.m_maxIntValue != null && value.compareTo(this.m_maxIntValue) > 0)) {
                            validValue = true;
                        }
                    } else {
                        DBLog.log("Min Max range not defined for " + this.getName(), new Object[0]);
                        validValue = true;
                    }
                    if (!validValue) {
                        throw new DefaultValueValidationException(dbObject, this.getName(), DBArb.format(209, strDefaultValue));
                    }
                }
            }
        }
    }

    private void setMinMaxValues(MinMaxValue minMaxValues) {
        if (minMaxValues != null) {
            this.m_valueType = minMaxValues.getValueType();
            if (this.m_valueType == 2) {
                this.m_minPositiveValue = minMaxValues.getMinValue();
                this.m_maxPositiveValue = minMaxValues.getMaxValue();
                this.m_minNegativeValue = minMaxValues.getMaxValue().negate();
                this.m_maxNegativeValue = minMaxValues.getMinValue().negate();
            } else {
                this.m_minIntValue = minMaxValues.getMinValue();
                this.m_maxIntValue = minMaxValues.getMaxValue();
                if (this.m_valueType == 0 && this.m_maxIntValue != null) {
                    this.m_maxUnsignedValue = this.m_maxIntValue.multiply(DECIMAL_2).add(DECIMAL_1);
                }
            }
        }
    }

    public static class MinMaxValue {
        public static final int SIGNED_INT = 0;
        public static final int UNSIGNED_INT = 1;
        public static final int FLOAT = 2;
        private BigDecimal m_minValue;
        private BigDecimal m_maxValue;
        private int m_valueType = -1;

        public MinMaxValue() {
        }

        public MinMaxValue(String minValue, String maxValue, int valueType) {
            this.m_minValue = new BigDecimal(minValue);
            this.m_maxValue = new BigDecimal(maxValue);
            this.m_valueType = valueType;
            assert (this.m_valueType == 2 || this.m_valueType == 0 || this.m_valueType == 1);
        }

        public BigDecimal getMinValue() {
            return this.m_minValue;
        }

        public BigDecimal getMaxValue() {
            return this.m_maxValue;
        }

        public int getValueType() {
            return this.m_valueType;
        }
    }
}

