/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.text.SimpleDateFormat;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.datatypes.BaseDateTimeDataType;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DefaultValueValidationException;

public class DateDataType
extends BaseDateTimeDataType {
    private static final String DATE_FORMAT = "ddMMMyy";
    private static final String ORACLE_FORMAT = "DD-MON-RR";
    private static SimpleDateFormat s_date;

    public DateDataType() {
    }

    public DateDataType(int domain, String name) {
        super(domain, name);
    }

    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
        String err;
        super.validateDefaultValue(defaultValue, dataTypeUsage, dbObject);
        if (null == s_date) {
            s_date = new SimpleDateFormat(DATE_FORMAT);
        }
        if (null != (err = this.validateDateTime(defaultValue, s_date, ORACLE_FORMAT, dbObject))) {
            throw new DefaultValueValidationException(dbObject, this.getName(), err);
        }
    }
}

