/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.HashMap;
import java.util.Map;
import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBUtil;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DataTypeUsage
extends AbstractChildDBObject {
    public static final String TYPE = "DataTypeUsage";
    private Map<String, Object> m_attributeValues = new HashMap<String, Object>();

    protected DataTypeUsage() {
    }

    protected DataTypeUsage(DataType dt) {
        if (dt != null) {
            this.setDataTypeID(dt.getID());
        }
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject target) {
        return super.equalsImpl(target) && DBUtil.areEqualIgnoreNullValues(this.m_attributeValues, ((DataTypeUsage)target).m_attributeValues);
    }

    @Override
    protected void copyToImpl(AbstractDBObject target, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(target, copyParent, idPolicy);
        ((DataTypeUsage)target).m_attributeValues.clear();
        ModelUtil.deepCopy(this.m_attributeValues, ((DataTypeUsage)target).m_attributeValues);
    }

    public final void setDataTypeID(DBObjectID dataTypeID) {
        this.setProperty("dataTypeID", dataTypeID);
    }

    public final DBObjectID getDataTypeID() {
        return (DBObjectID)this.getProperty("dataTypeID");
    }

    public final void setAttributeValues(Map<String, Object> attributeValues) {
        if (attributeValues == null) {
            this.m_attributeValues.clear();
        } else {
            this.m_attributeValues = attributeValues;
        }
    }

    public final Map<String, Object> getAttributeValues() {
        return this.m_attributeValues;
    }

    public final Object getAttributeValue(String name) {
        return this.m_attributeValues.get(name);
    }

    public final void putAttributeValue(String name, Object value) {
        this.m_attributeValues.put(name, value);
    }

    public final void deleteAttributeValue(String name) {
        this.m_attributeValues.remove(name);
    }

    public final boolean hasAttributeValue(String name) {
        return this.m_attributeValues.containsKey(name);
    }
}

