/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import oracle.javatools.db.DBCore;
import oracle.javatools.db.JdbcDatabase;
import oracle.javatools.db.Schema;
import oracle.javatools.db.datatypes.ComplexType;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeID;
import oracle.javatools.db.datatypes.DataTypeSynonym;
import oracle.javatools.db.datatypes.UserDataType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DataTypeRegistry {
    private final Map<Class, Object> m_complexTypes = new HashMap<Class, Object>();
    private final Map<Class, Object> m_dataTypes = new HashMap<Class, Object>();
    private final Map<DataType, DataType> m_ansiMap = new HashMap<DataType, DataType>();
    private Map<String, DataType> m_ansiTypes;
    private final Map<DataType, DataType> m_synonyms = new HashMap<DataType, DataType>();
    private final Map<Class, Object> m_registered = new HashMap<Class, Object>();
    private static ArrayList<Class> s_genericJdbcClasses = new ArrayList();

    private DataTypeRegistry() {
    }

    private synchronized Map getDataTypesImpl(Class queryClass) {
        Object entry = this.m_dataTypes.get(queryClass);
        if (entry instanceof Registerer) {
            this.m_dataTypes.remove(queryClass);
            ((Registerer)entry).registerDataTypes(this);
            this.m_registered.put(queryClass, entry);
            entry = this.m_dataTypes.get(queryClass);
        }
        if (entry instanceof Map) {
            return (Map)entry;
        }
        return null;
    }

    private synchronized Map getComplexTypesImpl(Class queryClass) {
        Object entry = this.m_complexTypes.get(queryClass);
        if (entry instanceof Registerer) {
            this.m_complexTypes.remove(queryClass);
            ((Registerer)entry).registerComplexTypes(this);
            this.m_registered.put(queryClass, entry);
            entry = this.m_complexTypes.get(queryClass);
        }
        if (entry instanceof Map) {
            return (Map)entry;
        }
        return null;
    }

    public synchronized void registerProvider(Registerer reg, Class provider) {
        this.m_dataTypes.put(provider, reg);
        this.m_complexTypes.put(provider, reg);
    }

    public synchronized void registerDataType(DataType type, Class provider) {
        this.registerDataType(type, provider, null);
    }

    public synchronized void registerDataType(DataType type, Class provider, DataType ansiType) {
        Object entry = this.m_dataTypes.get(provider);
        if (entry instanceof Registerer) {
            throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
        }
        HashMap<String, DataType> types = (HashMap<String, DataType>)entry;
        if (types == null) {
            types = new HashMap<String, DataType>();
            this.m_dataTypes.put(provider, types);
        }
        String name = type.getName().toUpperCase();
        assert (!types.containsKey(name));
        types.put(name, type);
        type.setID(new DataTypeID(name, provider));
        if (ansiType != null) {
            this.mapToAnsiType(type, ansiType);
        }
    }

    public synchronized void registerComplexType(ComplexType type, Class provider) {
        HashMap<String, ComplexType> types;
        Schema schema = type.getSchema();
        assert (schema != null);
        String schemaName = schema.getName();
        Object entry = this.m_complexTypes.get(provider);
        if (entry instanceof Registerer) {
            throw new IllegalArgumentException("Cannot register datatypes for this provider - it has a Registerer for that purpose.");
        }
        HashMap schemaMap = (HashMap)entry;
        if (schemaMap == null) {
            schemaMap = new HashMap();
            this.m_complexTypes.put(provider, schemaMap);
        }
        if ((types = (HashMap<String, ComplexType>)schemaMap.get(schemaName)) == null) {
            types = new HashMap<String, ComplexType>();
            schemaMap.put(schemaName, types);
        }
        String name = type.getName().toUpperCase();
        assert (!types.containsKey(name));
        types.put(name, type);
        type.setID(new DataTypeID(name, schemaName, provider));
    }

    public DataType createUserDataType(String name, Class provider) {
        UserDataType type = new UserDataType(name);
        if (DataTypeRegistry.isGenericJdbcClass(provider)) {
            this.registerAnsiType(type);
        } else {
            this.registerDataType(type, provider);
        }
        return type;
    }

    public DataType findDataType(String name, Class provider) {
        DataType type = this.findDataType(name, provider, true);
        if (type == null && provider != null && JdbcDatabase.class.isAssignableFrom(provider)) {
            return this.findAnsiType(name);
        }
        return type;
    }

    private DataType findDataType(String name, Class provider, boolean incSuperClasses) {
        for (Class queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            DataType type;
            Map entry = this.getDataTypesImpl(queryClass);
            if (entry != null && (type = (DataType)entry.get(name.toUpperCase())) != null) {
                return type;
            }
            if (incSuperClasses) {
                continue;
            }
            queryClass = null;
            break;
        }
        return null;
    }

    public ComplexType findComplexType(String name, String schemaName, Class provider) {
        for (Class queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            ComplexType type;
            Map schemaMap;
            Map entry = this.getComplexTypesImpl(queryClass);
            if (entry != null && (schemaMap = (Map)entry.get(schemaName)) != null && (type = (ComplexType)schemaMap.get(name.toUpperCase())) != null) {
                return type;
            }
            Registerer reg = (Registerer)this.m_registered.get(queryClass);
            if (reg != null && reg.includeSuperclassComplexTypes()) {
                continue;
            }
            queryClass = null;
            break;
        }
        return null;
    }

    public DataType[] listDataTypes(Class provider) {
        return this.listDataTypes(provider, true);
    }

    private DataType[] listDataTypes(Class provider, boolean incSuperClasses) {
        ArrayList types = new ArrayList();
        for (Class queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            Map entry = this.getDataTypesImpl(queryClass);
            if (entry != null) {
                types.addAll(entry.values());
            }
            if (incSuperClasses) {
                continue;
            }
            queryClass = null;
            break;
        }
        return types.toArray(new DataType[types.size()]);
    }

    public ComplexType[] listComplexTypes(String schemaName, Class provider) {
        ArrayList types = new ArrayList();
        for (Class queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            Registerer reg;
            Map schemaMap;
            Map entry = this.getComplexTypesImpl(queryClass);
            if (entry != null && (schemaMap = (Map)entry.get(schemaName)) != null) {
                types.addAll(schemaMap.values());
            }
            if ((reg = (Registerer)this.m_registered.get(queryClass)) != null && reg.includeSuperclassComplexTypes()) {
                continue;
            }
            queryClass = null;
            break;
        }
        return types.toArray(new ComplexType[types.size()]);
    }

    public String[] listComplexTypeSchemas(Class provider) {
        TreeSet schemas = new TreeSet();
        for (Class queryClass = provider; queryClass != null && !queryClass.equals(Object.class); queryClass = queryClass.getSuperclass()) {
            Registerer reg;
            Map entry = this.getComplexTypesImpl(queryClass);
            if (entry != null) {
                schemas.addAll(entry.keySet());
            }
            if ((reg = (Registerer)this.m_registered.get(queryClass)) != null && reg.includeSuperclassComplexTypes()) {
                continue;
            }
            queryClass = null;
            break;
        }
        return schemas.toArray(new String[schemas.size()]);
    }

    public boolean isRegisteredType(DataType type) {
        return type.getID() instanceof DataTypeID;
    }

    public synchronized DataType registerSynonym(String synonym, DataType baseType, Class provider) {
        DataTypeSynonym synType = new DataTypeSynonym(synonym, baseType);
        this.registerSynonym(synType, baseType, provider);
        return synType;
    }

    public synchronized void registerSynonym(DataType synonymType, DataType baseType, Class provider) {
        this.registerDataType(synonymType, provider);
        this.m_synonyms.put(synonymType, baseType);
    }

    public boolean isSynonymType(DataType type) {
        return this.m_synonyms.containsKey(type);
    }

    public DataType getBaseType(DataType synonym) {
        return this.m_synonyms.get(synonym);
    }

    private synchronized void registerAnsiType(DataType ansiType) {
        ansiType.setID(new DataTypeID(ansiType.getName(), JdbcDatabase.class));
        this.m_ansiTypes.put(ansiType.getName(), ansiType);
    }

    public DataType findAnsiType(String name) {
        this.initAnsiTypes();
        return this.m_ansiTypes.get(name.toUpperCase());
    }

    public DataType[] getAnsiTypes() {
        this.initAnsiTypes();
        Collection<DataType> c = this.m_ansiTypes.values();
        return c.toArray(new DataType[c.size()]);
    }

    public synchronized void mapToAnsiType(DataType type, String ansiTypeName) {
        DataType ansiType = this.findAnsiType(ansiTypeName);
        assert (ansiType != null);
        this.m_ansiMap.put(type, ansiType);
    }

    public synchronized void mapToAnsiType(DataType type, DataType ansiType) {
        this.initAnsiTypes();
        assert (ansiType != null && this.m_ansiTypes.containsKey(ansiType.getName()));
        this.m_ansiMap.put(type, ansiType);
    }

    public DataType getMappedAnsiType(DataType type) {
        return this.m_ansiMap.get(type);
    }

    public DataType getMappedType(String ansiTypeName, Class provider) {
        return this.getMappedType(ansiTypeName, provider, true);
    }

    private DataType getMappedType(String ansiTypeName, Class provider, boolean incSuperClasses) {
        while (provider != null && !provider.equals(Object.class)) {
            Map providerMap = (Map)this.m_dataTypes.get(provider);
            if (providerMap != null) {
                Collection providerTypes = providerMap.values();
                for (DataType providerType : providerTypes) {
                    DataType ansiType = this.m_ansiMap.get(providerType);
                    if (ansiType == null || !ansiType.getName().equals(ansiTypeName)) continue;
                    return providerType;
                }
            }
            if (!incSuperClasses) break;
            provider = provider.getSuperclass();
        }
        return null;
    }

    private synchronized void initAnsiTypes() {
        if (this.m_ansiTypes == null) {
            this.m_ansiTypes = new HashMap<String, DataType>();
            this.registerAnsiType(JdbcDatabase.ANSI_BIT);
            this.registerAnsiType(JdbcDatabase.ANSI_BIT_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_CHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_CHARACTER_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_CLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_VARCHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_NATIONAL_CHARACTER_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_NCHAR_VARYING);
            this.registerAnsiType(JdbcDatabase.ANSI_NCLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_NVARCHAR);
            this.registerAnsiType(JdbcDatabase.ANSI_BINARY_LARGE_OBJECT);
            this.registerAnsiType(JdbcDatabase.ANSI_BLOB);
            this.registerAnsiType(JdbcDatabase.ANSI_DATE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME_WITH_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIME_WITHOUT_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP_WITH_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_TIMESTAMP_WITHOUT_TIME_ZONE);
            this.registerAnsiType(JdbcDatabase.ANSI_BIGINT);
            this.registerAnsiType(JdbcDatabase.ANSI_DEC);
            this.registerAnsiType(JdbcDatabase.ANSI_DECIMAL);
            this.registerAnsiType(JdbcDatabase.ANSI_DOUBLE_PRECISION);
            this.registerAnsiType(JdbcDatabase.ANSI_FLOAT);
            this.registerAnsiType(JdbcDatabase.ANSI_INT);
            this.registerAnsiType(JdbcDatabase.ANSI_INTEGER);
            this.registerAnsiType(JdbcDatabase.ANSI_NUMERIC);
            this.registerAnsiType(JdbcDatabase.ANSI_REAL);
            this.registerAnsiType(JdbcDatabase.ANSI_SMALLINT);
            this.registerAnsiType(JdbcDatabase.ANSI_BOOLEAN);
            this.registerAnsiType(JdbcDatabase.ANSI_INTERVAL);
            this.registerAnsiType(JdbcDatabase.ANSI_REF);
            this.registerAnsiType(JdbcDatabase.ANSI_ROW);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataTypeRegistry getInstance() {
        DBCore core = DBCore.getInstance();
        Class<DataTypeRegistry> clazz = DataTypeRegistry.class;
        synchronized (DataTypeRegistry.class) {
            DataTypeRegistry dtr = core.get(DataTypeRegistry.class);
            if (dtr == null) {
                dtr = new DataTypeRegistry();
                core.put(dtr);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return dtr;
        }
    }

    public static final void registerGenericJdbcClass(Class<? extends JdbcDatabase> clz) {
        s_genericJdbcClasses.add(clz);
    }

    public static final boolean isGenericJdbcClass(Class clz) {
        return s_genericJdbcClasses.contains(clz);
    }

    static {
        s_genericJdbcClasses.add(JdbcDatabase.class);
    }

    public static class Registerer {
        protected void registerDataTypes(DataTypeRegistry dtr) {
        }

        protected void registerComplexTypes(DataTypeRegistry dtr) {
        }

        protected boolean includeSuperclassTypes() {
            return true;
        }

        protected boolean includeSuperclassComplexTypes() {
            return true;
        }
    }
}

