/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.DBException;
import oracle.javatools.db.DBLog;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeRegistry;
import oracle.javatools.util.ModelUtil;

public final class DataTypeID
implements DBObjectID {
    private String m_typeName;
    private String m_schemaName;
    private Class m_providerClass;
    private static final String s_stringPrefix = "DataTypeID:";

    public DataTypeID() {
    }

    DataTypeID(String typeName, Class providerClass) {
        this.m_typeName = typeName;
        this.m_providerClass = providerClass;
    }

    DataTypeID(String typeName, String schemaName, Class providerClass) {
        this.m_schemaName = schemaName;
        this.m_typeName = typeName;
        this.m_providerClass = providerClass;
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public void setTypeName(String name) {
        this.m_typeName = name;
    }

    public Class getProviderClass() {
        return this.m_providerClass;
    }

    public void setProviderClass(Class clz) {
        this.m_providerClass = clz;
    }

    public String getSchemaName() {
        return this.m_schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.m_schemaName = schemaName;
    }

    public boolean equals(DBObjectID id) {
        return this.equals(id, true);
    }

    public boolean equals(DBObjectID id, boolean strict) {
        return id instanceof DataTypeID && this.equalsImpl((DataTypeID)id);
    }

    protected boolean equalsImpl(DataTypeID id) {
        return ModelUtil.areEqual((Object)this.m_typeName, (Object)id.m_typeName) && ModelUtil.areEqual((Object)this.m_schemaName, (Object)id.m_schemaName) && ModelUtil.areEqual((Object)this.m_providerClass, (Object)id.m_providerClass);
    }

    public Object copyTo(Object target) {
        DataTypeID copy = target == null ? new DataTypeID() : (DataTypeID)target;
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(DataTypeID target) {
        target.m_providerClass = this.m_providerClass;
        target.m_schemaName = this.m_schemaName;
        target.m_typeName = this.m_typeName;
    }

    public String getType() {
        return null;
    }

    public DBObject resolveID() throws DBException {
        DataTypeRegistry dtr = DataTypeRegistry.getInstance();
        DataType resolved = null;
        if (this.m_providerClass != null && (resolved = this.m_schemaName != null ? dtr.findComplexType(this.m_typeName, this.m_schemaName, this.m_providerClass) : dtr.findDataType(this.m_typeName, this.m_providerClass)) == null) {
            DBLog.log("DataTypeID: DataType " + this.m_typeName + " not found in provider " + this.m_providerClass, new Object[0]);
            resolved = dtr.createUserDataType(this.m_typeName, this.m_providerClass);
        }
        return resolved;
    }

    public DBObjectID getParent() {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof DBObjectID && this.equals((DBObjectID)obj);
    }

    public String toString() {
        return s_stringPrefix + (this.m_providerClass == null ? "null" : this.m_providerClass.getName()) + ":" + this.m_schemaName + ":" + this.m_typeName;
    }

    public static final boolean isIDType(String idString) {
        return idString.startsWith(s_stringPrefix);
    }

    public static DataTypeID createFromString(String idString) {
        String[] bits;
        DataTypeID retval = null;
        if (DataTypeID.isIDType(idString) && (bits = idString.split(":")).length == 4) {
            try {
                Class<?> clz = Class.forName(bits[1]);
                retval = new DataTypeID(bits[3], bits[2], clz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return retval;
    }
}

