/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import oracle.javatools.db.AbstractChildDBObject;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.DBArb;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.util.ModelUtil;

public class DataTypeAttribute
extends AbstractChildDBObject {
    public static final String TYPE = "DatatypeAttribute";
    public static final String DATATYPE_NAME = "name";
    public static final String DATATYPE_SIZE = "size";
    public static final String DATATYPE_PRECISION = "precision";
    public static final String DATATYPE_SCALE = "scale";
    public static final String DATATYPE_UNSIGNED = "unsigned";
    public static final int DATATYPE_CHAR = 0;
    public static final int DATATYPE_LONG = 1;
    private static final int NOLABEL = -1;
    private int m_labelIndex = -1;
    private int m_valueType;
    private String[] m_values;
    private Long m_minValue;
    private Long m_maxValue;
    private Object m_defaultValue;
    private boolean m_isExtensible = false;
    private boolean m_isMandatory = false;
    private boolean m_isDeclarable = false;

    public DataTypeAttribute() {
    }

    public DataTypeAttribute(String name, long minValue, long maxValue) {
        super(name);
        this.m_valueType = 1;
        this.m_minValue = new Long(minValue);
        this.m_maxValue = new Long(maxValue);
    }

    public DataTypeAttribute(String name, int labelIndex, long minValue, Long maxValue, Long defaultValue, boolean isMandatory) {
        super(name);
        this.m_valueType = 1;
        this.m_labelIndex = labelIndex;
        this.m_minValue = new Long(minValue);
        this.m_maxValue = maxValue;
        this.m_defaultValue = defaultValue;
        this.m_isMandatory = isMandatory;
        this.m_isDeclarable = true;
    }

    public DataTypeAttribute(String name, int labelIndex, String defaultValue, boolean isMandatory) {
        super(name);
        this.m_valueType = 0;
        this.m_labelIndex = labelIndex;
        this.m_defaultValue = defaultValue;
        this.m_isMandatory = isMandatory;
        this.m_isDeclarable = true;
        this.m_isExtensible = true;
        this.m_values = null;
    }

    public DataTypeAttribute(String name, int labelIndex, String[] values, String defaultValue, boolean isExtensible, boolean isMandatory) {
        super(name);
        this.m_valueType = 0;
        this.m_labelIndex = labelIndex;
        this.m_defaultValue = defaultValue;
        this.m_isExtensible = isExtensible;
        this.m_isMandatory = isMandatory;
        this.m_values = values;
        this.m_isDeclarable = true;
    }

    public DataTypeAttribute(String name) {
        super(name);
        this.m_valueType = 0;
    }

    public int getValueType() {
        return this.m_valueType;
    }

    public String getLabel() {
        return this.m_labelIndex == -1 ? this.getName() : DBArb.getString(this.m_labelIndex);
    }

    public Long getMinValue() {
        return this.m_minValue;
    }

    public Long getMaxValue() {
        return this.m_maxValue;
    }

    public String[] getValues() {
        return this.m_values;
    }

    public Object getDefaultValue() {
        return this.m_defaultValue;
    }

    public boolean isDeclarable() {
        return this.m_isDeclarable;
    }

    public boolean isMandatory() {
        return this.m_isMandatory;
    }

    public boolean isExtensible() {
        return this.m_isExtensible;
    }

    public final String getType() {
        return TYPE;
    }

    protected boolean equalsImpl(AbstractDBObject other) {
        DataTypeAttribute target = (DataTypeAttribute)other;
        return super.equalsImpl(target) && target.m_labelIndex == this.m_labelIndex && target.m_valueType == this.m_valueType && target.m_isExtensible == this.m_isExtensible && target.m_isDeclarable == this.m_isDeclarable && target.m_isMandatory == this.m_isMandatory && ModelUtil.areEqual((Object)this.m_minValue, (Object)target.m_minValue) && ModelUtil.areEqual((Object)this.m_maxValue, (Object)target.m_maxValue) && ModelUtil.areEqual((Object)this.m_defaultValue, (Object)target.m_defaultValue) && ModelUtil.areEqual((Object)this.m_values, (Object)target.m_values);
    }

    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        super.copyToImpl(other, copyParent, idPolicy);
        DataTypeAttribute target = (DataTypeAttribute)other;
        target.m_labelIndex = this.m_labelIndex;
        target.m_valueType = this.m_valueType;
        target.m_isExtensible = this.m_isExtensible;
        target.m_isMandatory = this.m_isMandatory;
        target.m_isDeclarable = this.m_isDeclarable;
        target.m_minValue = this.m_minValue;
        target.m_maxValue = this.m_maxValue;
        target.m_defaultValue = this.m_defaultValue;
        target.m_values = this.m_values;
    }
}

