/*
 * Decompiled with CFR 0.152.
 */
package oracle.javatools.db.datatypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import oracle.javatools.db.AbstractDBObject;
import oracle.javatools.db.BaseObjectID;
import oracle.javatools.db.DBObject;
import oracle.javatools.db.DBObjectID;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.IDPolicy;
import oracle.javatools.db.Schema;
import oracle.javatools.db.SpecPlSql;
import oracle.javatools.db.datatypes.DataType;
import oracle.javatools.db.datatypes.DataTypeAttribute;
import oracle.javatools.db.datatypes.DataTypeUsage;
import oracle.javatools.db.datatypes.DataTypeValidationException;
import oracle.javatools.db.datatypes.DefaultValueValidationException;
import oracle.javatools.db.datatypes.ObjectTypeUsage;
import oracle.javatools.db.plsql.PlSqlSearch;
import oracle.javatools.db.plsql.PlSqlSearchException;
import oracle.javatools.db.property.Transient;
import oracle.javatools.util.ModelUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComplexType
extends SpecPlSql
implements DataType {
    public static final String TYPE = "TYPE";
    public static final String OBJECT_TYPECODE = "OBJECT";
    public static final String COLLECTION_TYPECODE = "COLLECTION";
    public static final String BODY_TYPE = "TYPE BODY";
    public static final String TABLE_TYPE = "TABLE";
    public static final String VARRAY_TYPE = "VARYING ARRAY";
    private String m_typeCode = "OBJECT";
    private String m_collType = "";
    private boolean m_final = true;
    private boolean m_instantiable = true;
    private DataTypeUsage m_ofTypeUsage;
    private DBObjectID m_underTypeID;
    private boolean m_authidCurrentUser;
    private Integer m_limit;
    private String m_OID;
    private String m_sqljExtenalName;
    private SQLJUsingType m_sqljUsing;
    private boolean m_madeDeclarative = false;
    private final DataTypeAttribute[] m_dataTypeAttributes = new DataTypeAttribute[0];
    private ArrayList<String> m_declaratorErrors = new ArrayList();

    public ComplexType() {
    }

    public ComplexType(String name, Schema schema) {
        super(name, schema);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    @Override
    protected void copyToImpl(AbstractDBObject other, DBObject copyParent, IDPolicy idPolicy) {
        ComplexType copy = (ComplexType)other;
        super.copyToImpl(copy, copyParent, idPolicy);
        copy.m_typeCode = this.m_typeCode;
        copy.m_collType = this.m_collType;
        copy.m_final = this.m_final;
        copy.m_instantiable = this.m_instantiable;
        copy.m_authidCurrentUser = this.m_authidCurrentUser;
        copy.m_limit = this.m_limit;
        copy.m_ofTypeUsage = this.copyObject(this.m_ofTypeUsage, copy, idPolicy);
        copy.m_underTypeID = this.m_underTypeID;
        copy.m_OID = this.m_OID;
        copy.m_sqljExtenalName = this.m_sqljExtenalName;
        copy.m_sqljUsing = this.m_sqljUsing;
    }

    @Override
    protected boolean equalsImpl(AbstractDBObject other) {
        ComplexType target = (ComplexType)other;
        return super.equalsImpl(target) && ModelUtil.areEqual((Object)this.m_typeCode, (Object)target.m_typeCode) && ModelUtil.areEqual((Object)this.m_collType, (Object)target.m_collType) && ModelUtil.areEqual((Object)this.m_ofTypeUsage, (Object)target.m_ofTypeUsage) && ModelUtil.areEqual((Object)this.m_underTypeID, (Object)target.m_underTypeID) && ModelUtil.areEqual((Object)this.m_limit, (Object)target.m_limit) && ModelUtil.areEqual((Object)this.m_OID, (Object)target.m_OID) && ModelUtil.areEqual((Object)this.m_sqljExtenalName, (Object)target.m_sqljExtenalName) && ModelUtil.areEqual((Object)((Object)this.m_sqljUsing), (Object)((Object)target.m_sqljUsing)) && this.m_final == target.m_final && this.m_instantiable == target.m_instantiable && this.m_authidCurrentUser == target.m_authidCurrentUser;
    }

    @Override
    protected void getOwnedObjectsImpl(Collection<DBObject> c, String ... types) {
        super.getOwnedObjectsImpl(c, types);
        this.includeOwnedObject(c, this.m_ofTypeUsage, types);
    }

    @Override
    protected void getReferenceIDsImpl(Collection<DBObjectID> refs) {
        super.getReferenceIDsImpl(refs);
        if (this.m_underTypeID != null) {
            refs.add(this.m_underTypeID);
        }
    }

    @Override
    public boolean replaceReferenceIDs(Map<DBObjectID, DBObjectID> idMap) {
        boolean replaced = super.replaceReferenceIDs(idMap);
        if (idMap.containsKey(this.m_underTypeID)) {
            this.m_underTypeID = idMap.get(this.m_underTypeID);
            replaced = true;
        }
        return replaced;
    }

    public boolean isFinal() {
        this.checkInit();
        return this.m_final;
    }

    public void setFinal(boolean isFinal) {
        this.checkInit();
        this.m_final = isFinal;
    }

    public boolean isInstantiable() {
        this.checkInit();
        return this.m_instantiable;
    }

    public void setInstantiable(boolean isInstantiable) {
        this.checkInit();
        this.m_instantiable = isInstantiable;
    }

    public String getTypeCode() {
        this.checkInit();
        return this.m_typeCode;
    }

    public void setTypeCode(String typeCode) {
        if (typeCode == null || typeCode.equals("")) {
            this.m_typeCode = typeCode;
            this.getChildSupport("dataTypeAttributes").clearChildren();
        } else if (OBJECT_TYPECODE.equals(typeCode) || COLLECTION_TYPECODE.equals(typeCode) || this.getSchema() != null && "SYS".equals(this.getSchema().getName()) && this.getName().equals(typeCode)) {
            this.m_typeCode = typeCode;
        } else {
            throw new IllegalArgumentException("ComplexType: Invalid typecode " + typeCode);
        }
    }

    public String getCollectionType() {
        this.checkInit();
        return this.m_collType;
    }

    public void setCollectionType(String collType) {
        if (collType == null || collType.equals("") || TABLE_TYPE.equals(collType) || VARRAY_TYPE.equals(collType)) {
            this.m_collType = collType == null ? "" : collType;
        } else if (collType != null && !collType.equals("")) {
            throw new IllegalArgumentException("ComplexType: Invalid collType " + collType);
        }
    }

    public void setAuthidCurrentUser(boolean authidCurrentUser) {
        this.checkInit();
        this.m_authidCurrentUser = authidCurrentUser;
    }

    public boolean isAuthidCurrentUser() {
        this.checkInit();
        return this.m_authidCurrentUser;
    }

    public void setLimit(Integer limit) {
        this.m_limit = limit;
    }

    public Integer getLimit() {
        this.checkInit();
        return this.m_limit;
    }

    public void setOfTypeUsage(DataTypeUsage ofTypeUsage) {
        this.checkInit();
        this.changeParent(this.m_ofTypeUsage, ofTypeUsage);
        this.m_ofTypeUsage = ofTypeUsage;
    }

    public DataTypeUsage getOfTypeUsage() {
        this.checkInit();
        return this.m_ofTypeUsage;
    }

    public void setUnderTypeID(DBObjectID underTypeID) {
        this.checkInit();
        this.m_underTypeID = underTypeID;
    }

    public DBObjectID getUnderTypeID() {
        this.checkInit();
        return this.m_underTypeID;
    }

    @Override
    public String getDDL(DataTypeUsage dataTypeUsage) {
        String name;
        String schemaName;
        StringBuffer fsb = new StringBuffer();
        DBObjectProvider pro = this.getID() instanceof BaseObjectID ? ((BaseObjectID)this.getID()).getProvider() : null;
        Schema s = this.getSchema();
        if (s != null && ModelUtil.hasLength((String)(schemaName = s.getName()))) {
            if (pro != null) {
                schemaName = pro.getExternalName(schemaName);
            }
            fsb.append(schemaName).append(".");
        }
        if ((name = this.getName()) != null && pro != null) {
            name = pro.getExternalName(name);
        }
        fsb.append(name);
        return fsb.toString();
    }

    @Override
    public DataTypeAttribute[] getDataTypeAttributes() {
        return this.m_dataTypeAttributes;
    }

    @Override
    public boolean hasDataTypeAttribute(String name) {
        return false;
    }

    @Override
    public DataTypeAttribute getDataTypeAttribute(String name) {
        return null;
    }

    @Override
    public DataTypeUsage createDefaultUsage() {
        return new ObjectTypeUsage(this);
    }

    @Override
    public DataTypeUsage createUsage(Map<String, Object> attributes) {
        return new ObjectTypeUsage(this);
    }

    @Override
    public void validateUsage(DataTypeUsage dataTypeUsage, DBObject dbObject) throws DataTypeValidationException {
    }

    @Override
    public void validateDefaultValue(Object defaultValue, DataTypeUsage dataTypeUsage, DBObject dbObject) throws DefaultValueValidationException {
    }

    public void setOID(String oid) {
        this.checkInit();
        this.m_OID = oid;
    }

    public String getOID() {
        this.checkInit();
        return this.m_OID;
    }

    public void setSqljExternalName(String sqljExternalName) {
        this.checkInit();
        this.m_sqljExtenalName = sqljExternalName;
    }

    public String getSqljExternalName() {
        this.checkInit();
        return this.m_sqljExtenalName;
    }

    public void setSqljUsing(SQLJUsingType sqljUsing) {
        this.checkInit();
        this.m_sqljUsing = sqljUsing;
    }

    public SQLJUsingType getSqljUsing() {
        this.checkInit();
        return this.m_sqljUsing;
    }

    @Transient
    public final void setMadeDeclarative(boolean madeDeclarative) {
        this.m_madeDeclarative = madeDeclarative;
    }

    @Transient
    public final boolean isMadeDeclarative() {
        return this.m_madeDeclarative;
    }

    @Override
    public void setSource(String source) {
        super.setSource(source);
        this.m_madeDeclarative = false;
        this.m_declaratorErrors = new ArrayList();
    }

    @Override
    public boolean matches(String usageString) {
        StringBuffer searchExpr = new StringBuffer("[? .] {");
        searchExpr.append("\"").append(this.getName()).append("\" |");
        searchExpr.append(this.getName().toUpperCase()).append("}");
        PlSqlSearch search = null;
        try {
            search = new PlSqlSearch(searchExpr.toString());
            return search.matches(usageString);
        }
        catch (PlSqlSearchException e) {
            return false;
        }
    }

    @Override
    public DataTypeUsage createUsage(String usageString) {
        return new ObjectTypeUsage(this);
    }

    @Transient
    public void addDeclaratorError(String error) {
        this.m_declaratorErrors.add(error);
    }

    @Transient
    public List<String> getDeclaratorErrors() {
        return this.m_declaratorErrors;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SQLJUsingType {
        SQLData,
        CustomDatum,
        OraData;

    }
}

